/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.notjustnameplates.nameplates;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.youhavetrouble.notjustnameplates.NotJustNameplates;
import me.youhavetrouble.notjustnameplates.displays.DisplayContent;
import me.youhavetrouble.notjustnameplates.nameplates.Nameplate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;

public class NameplateManager
implements Listener {
    private final Map<UUID, Nameplate> nameplates = new HashMap<UUID, Nameplate>();
    private final Set<UUID> playersWithNameplatesOff = new HashSet<UUID>();

    public NameplateManager(NotJustNameplates plugin) {
        this.reloadNameplates();
        Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> this.nameplates.values().forEach(Nameplate::update), 0L, 1L);
        Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> Bukkit.getWorlds().forEach(world -> world.getEntities().forEach(entity -> {
            if (!(entity instanceof TextDisplay)) {
                return;
            }
            TextDisplay textDisplay = (TextDisplay)entity;
            if (!textDisplay.getPersistentDataContainer().has(Nameplate.NAMEPLATE_KEY)) {
                return;
            }
            for (Nameplate nameplate : this.nameplates.values()) {
                if (nameplate.getEntity() != textDisplay) continue;
                return;
            }
            textDisplay.remove();
        })), 100L, 100L);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        UUID joinerUuid = event.getPlayer().getUniqueId();
        DisplayContent displayContent = NotJustNameplates.getInstance().getDisplayContentForPlayerBasedOnPermission(event.getPlayer());
        if (displayContent == null) {
            return;
        }
        this.nameplates.put(joinerUuid, new Nameplate(joinerUuid, displayContent));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Nameplate nameplate = this.nameplates.get(event.getPlayer().getUniqueId());
        if (nameplate == null) {
            return;
        }
        nameplate.remove();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerSneak(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        Nameplate nameplate = this.nameplates.get(player.getUniqueId());
        if (nameplate == null) {
            return;
        }
        if (nameplate.getContent().getCurrentFrame().sneakOverride() == null) {
            return;
        }
        nameplate.update();
    }

    public void reloadNameplates() {
        this.nameplates.values().forEach(Nameplate::remove);
        this.nameplates.clear();
        for (Player player : Bukkit.getOnlinePlayers()) {
            DisplayContent displayContent = NotJustNameplates.getPluginConfig().getDisplayContent("default");
            for (Map.Entry<String, DisplayContent> entry : NotJustNameplates.getPluginConfig().getDisplayContents().entrySet()) {
                if (!player.hasPermission("notjustnameplates.display." + entry.getKey())) continue;
                displayContent = entry.getValue();
                break;
            }
            this.nameplates.put(player.getUniqueId(), new Nameplate(player.getUniqueId(), displayContent));
        }
    }

    public Map<UUID, Nameplate> getNameplates() {
        return Collections.unmodifiableMap(this.nameplates);
    }

    public Set<UUID> getPlayersWithNameplatesOff() {
        return this.playersWithNameplatesOff;
    }

    public void nameplatesToggle(Player player, boolean hide) {
        if (hide) {
            this.playersWithNameplatesOff.add(player.getUniqueId());
            this.nameplates.values().forEach(nameplate -> {
                if (nameplate.playerUuid.equals(player.getUniqueId())) {
                    return;
                }
                TextDisplay display = nameplate.getEntity();
                if (display == null) {
                    return;
                }
                player.hideEntity((Plugin)NotJustNameplates.getInstance(), (Entity)display);
            });
            return;
        }
        this.playersWithNameplatesOff.remove(player.getUniqueId());
        this.nameplates.values().forEach(nameplate -> {
            if (nameplate.playerUuid.equals(player.getUniqueId())) {
                return;
            }
            TextDisplay display = nameplate.getEntity();
            if (display == null) {
                return;
            }
            player.showEntity((Plugin)NotJustNameplates.getInstance(), (Entity)display);
        });
    }
}

