/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.notjustnameplates.text;

import me.clip.placeholderapi.PlaceholderAPI;
import me.youhavetrouble.notjustnameplates.NotJustNameplates;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class TextParser {
    public static Component parseWithPlaceholders(String input, Player player) {
        MiniMessage miniMessage = MiniMessage.builder().tags(TagResolver.builder().resolvers(new TagResolver[]{StandardTags.defaults(), TextParser.placeholderTag(player)}).build()).build();
        return miniMessage.deserialize((Object)input);
    }

    @NotNull
    public static TagResolver placeholderTag(@NotNull Player player) {
        return TagResolver.resolver((String)"placeholder", (argumentQueue, context) -> {
            String placeholder;
            switch (placeholder = argumentQueue.popOr("placeholder tag requires an argument").value()) {
                case "name": {
                    return Tag.selfClosingInserting((Component)player.name());
                }
                case "displayname": {
                    return Tag.selfClosingInserting((Component)player.displayName());
                }
            }
            if (!NotJustNameplates.isPapiHooked()) {
                return Tag.selfClosingInserting((Component)Component.text((String)placeholder));
            }
            String parsedPlaceholder = PlaceholderAPI.setPlaceholders((Player)player, (String)("%" + placeholder + "%"));
            if (parsedPlaceholder.contains("\u00a7")) {
                TextComponent componentPlaceholder = LegacyComponentSerializer.legacySection().deserialize(parsedPlaceholder);
                return Tag.selfClosingInserting((Component)componentPlaceholder);
            }
            return Tag.selfClosingInserting((Component)MiniMessage.miniMessage().deserialize((Object)parsedPlaceholder));
        });
    }
}

