/*
 * Decompiled with CFR 0.152.
 */
package dev.attackeight.just_enough_vh.jei;

import dev.attackeight.just_enough_vh.JustEnoughVH;
import dev.attackeight.just_enough_vh.jei.ForgeItem;
import dev.attackeight.just_enough_vh.jei.LabeledLootInfo;
import dev.attackeight.just_enough_vh.mixin.AltarIngredientAccessor;
import dev.attackeight.just_enough_vh.mixin.IngredientAmountAccessor;
import dev.attackeight.just_enough_vh.mixin.ProductEntryAccessor;
import dev.attackeight.just_enough_vh.mixin.RewardEntryAccessor;
import dev.attackeight.just_enough_vh.mixin.RewardPoolAccessor;
import io.github.a1qs.vaultadditions.config.vault.AbstractStatueLootConfig;
import iskallia.vault.config.OmegaSoulShardConfig;
import iskallia.vault.config.SoulShardConfig;
import iskallia.vault.config.altar.entry.AltarIngredientEntry;
import iskallia.vault.config.entry.IntRangeEntry;
import iskallia.vault.config.entry.ItemStackEntry;
import iskallia.vault.config.entry.recipe.ConfigForgeRecipe;
import iskallia.vault.config.entry.vending.ProductEntry;
import iskallia.vault.config.recipe.ForgeRecipesConfig;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.integration.jei.lootinfo.LootInfo;
import iskallia.vault.util.data.WeightedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class JEIRecipeProvider {
    protected static <R extends VaultForgeRecipe, T extends ConfigForgeRecipe<R>, S extends ForgeRecipesConfig<T, R>> List<ForgeItem> getForgeRecipes(S config) {
        ArrayList<ForgeItem> recipes = new ArrayList<ForgeItem>();
        config.getConfigRecipes().forEach(b -> recipes.add(new ForgeItem(b.makeRecipe().getInputs(), b.makeRecipe().getDisplayOutput(100))));
        return recipes;
    }

    protected static List<LootInfo> getFromPool(WeightedList<ProductEntry> pool) {
        ArrayList loot = new ArrayList();
        int total = pool.getTotalWeight();
        pool.forEach(b -> loot.add(JEIRecipeProvider.addWeight((WeightedList.Entry<ProductEntry>)b, total)));
        return List.of(new LootInfo(loot));
    }

    protected static ItemStack addWeight(WeightedList.Entry<ProductEntry> productEntry, int totalWeight) {
        ProductEntryAccessor entry = (ProductEntryAccessor)productEntry.value;
        if (!ForgeRegistries.ITEMS.containsKey(((ProductEntry)productEntry.value).getItem().getRegistryName())) {
            return ItemStack.f_41583_;
        }
        return JEIRecipeProvider.formatItemStack((ItemLike)((ProductEntry)productEntry.value).getItem(), entry.getAmountMin(), entry.getAmountMax(), productEntry.weight, totalWeight);
    }

    protected static List<LabeledLootInfo> getShopPedestalLoot() {
        List pedestalInfo;
        ArrayList<LabeledLootInfo> lootInfo = new ArrayList<LabeledLootInfo>();
        try {
            pedestalInfo = (List)ModConfigs.SHOP_PEDESTAL.getClass().getMethod("getTrades", new Class[0]).invoke((Object)ModConfigs.SHOP_PEDESTAL, new Object[0]);
        }
        catch (Exception e) {
            JustEnoughVH.LOGGER.error(e.toString());
            return new ArrayList<LabeledLootInfo>();
        }
        pedestalInfo.forEach(tierInfo -> {
            List tier = (List)tierInfo.getLeft();
            int minLevel = (Integer)tierInfo.getRight();
            AtomicInteger totalWeight = new AtomicInteger();
            tier.forEach(d -> totalWeight.addAndGet(((Double)d.getRight()).intValue()));
            ArrayList<ItemStack> offers = new ArrayList<ItemStack>();
            tier.forEach(offerInfo -> {
                ItemStack currentOffer = (ItemStack)offerInfo.getLeft();
                if (!JustEnoughVH.SHOP_PEDESTAL_ITEMS.containsKey((Object)currentOffer.m_41720_().getRegistryName())) {
                    JustEnoughVH.SHOP_PEDESTAL_ITEMS.put((Object)currentOffer.m_41720_().getRegistryName(), (Object)minLevel);
                }
                offers.add(JEIRecipeProvider.formatItemStack((ItemLike)currentOffer.m_41720_(), ((IntRangeEntry)offerInfo.getMiddle()).getMin(), ((IntRangeEntry)offerInfo.getMiddle()).getMax(), ((Double)offerInfo.getRight()).intValue(), totalWeight.get(), true));
            });
            lootInfo.add(LabeledLootInfo.of(offers, (Component)new TextComponent("Level " + minLevel + "+ "), null));
        });
        return lootInfo;
    }

    protected static List<LabeledLootInfo> getBlackMarketLoot() {
        ArrayList<LabeledLootInfo> lootInfo = new ArrayList<LabeledLootInfo>();
        Set tradesList = ModConfigs.SOUL_SHARD.getTrades();
        tradesList.forEach(b -> {
            int minLevel = b.getMinLevel();
            int randomPrice = b.getShardTradePrice();
            ArrayList<ItemStack> shardTrades = new ArrayList<ItemStack>();
            AtomicInteger totalWeight = new AtomicInteger();
            b.getShardTrades().forEach(d -> totalWeight.addAndGet(d.weight));
            b.getShardTrades().forEach(c -> {
                ItemStack currentTrade = ((SoulShardConfig.ShardTrade)c.value).getItemEntry().createItemStack();
                if (!JustEnoughVH.BLACK_MARKET_ITEMS.containsKey((Object)currentTrade.m_41720_().getRegistryName())) {
                    JustEnoughVH.BLACK_MARKET_ITEMS.put((Object)currentTrade.m_41720_().getRegistryName(), (Object)minLevel);
                }
                shardTrades.add(JEIRecipeProvider.formatItemStack((ItemLike)currentTrade.m_41720_(), ((SoulShardConfig.ShardTrade)c.value).getMinPrice(), ((SoulShardConfig.ShardTrade)c.value).getMaxPrice(), c.weight, totalWeight.get(), true));
            });
            lootInfo.add(LabeledLootInfo.of(shardTrades, (Component)new TextComponent("Common Slot: Level " + minLevel + "+ "), (Component)new TextComponent("Soul Trade Price: " + randomPrice)));
        });
        Set omegaTradesList = ModConfigs.OMEGA_SOUL_SHARD.getTrades();
        omegaTradesList.forEach(b -> {
            int minLevel = b.getMinLevel();
            ArrayList<ItemStack> shardTrades = new ArrayList<ItemStack>();
            AtomicInteger totalWeight = new AtomicInteger();
            b.getShardTrades().forEach(d -> totalWeight.addAndGet(d.weight));
            b.getShardTrades().forEach(c -> {
                ItemStack currentTrade = ((OmegaSoulShardConfig.ShardTrade)c.value).getItem();
                if (!JustEnoughVH.OMEGA_BLACK_MARKET_ITEMS.containsKey((Object)currentTrade.m_41720_().getRegistryName())) {
                    JustEnoughVH.OMEGA_BLACK_MARKET_ITEMS.put((Object)currentTrade.m_41720_().getRegistryName(), (Object)minLevel);
                }
                shardTrades.add(JEIRecipeProvider.formatItemStack((ItemLike)currentTrade.m_41720_(), ((OmegaSoulShardConfig.ShardTrade)c.value).getMinPrice(), ((OmegaSoulShardConfig.ShardTrade)c.value).getMaxPrice(), c.weight, totalWeight.get(), true));
            });
            lootInfo.add(LabeledLootInfo.of(shardTrades, (Component)new TextComponent("Omega Slot: Level " + minLevel + "+ "), null));
        });
        return lootInfo;
    }

    protected static List<LabeledLootInfo> getModBoxLoot() {
        ArrayList<LabeledLootInfo> lootInfo = new ArrayList<LabeledLootInfo>();
        ModConfigs.MOD_BOX.POOL.forEach((mod, k) -> {
            AtomicInteger totalWeight = new AtomicInteger();
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            k.forEach(d -> totalWeight.addAndGet(d.weight));
            k.forEach(c -> {
                ProductEntryAccessor accessor = (ProductEntryAccessor)c;
                results.add(JEIRecipeProvider.formatItemStack((ItemLike)((ProductEntry)c.value).getItem(), accessor.getAmountMin(), accessor.getAmountMax(), c.weight, totalWeight.get()));
            });
            lootInfo.add(LabeledLootInfo.of(results, (Component)new TextComponent("Mod: " + mod), null));
        });
        return lootInfo;
    }

    protected static List<LabeledLootInfo> getBountyRewards() {
        ArrayList<LabeledLootInfo> toReturn = new ArrayList<LabeledLootInfo>();
        RewardPoolAccessor rewardPools = (RewardPoolAccessor)ModConfigs.REWARD_CONFIG;
        rewardPools.getPOOLS().forEach((id, entry) -> {
            TreeMap<Integer, LabeledLootInfo> lootInfo = new TreeMap<Integer, LabeledLootInfo>();
            if (!id.equals("submission")) {
                entry.forEach((minLevel, rewards) -> {
                    AtomicInteger totalWeight = new AtomicInteger();
                    ArrayList<ItemStack> results = new ArrayList<ItemStack>();
                    RewardEntryAccessor rewardEntry = (RewardEntryAccessor)rewards;
                    IntRangeEntry vaultExp = rewardEntry.getVaultExp();
                    rewards.getItemPool().getPool().forEach(stack -> totalWeight.addAndGet(stack.weight));
                    rewards.getItemPool().getPool().forEach(stack -> results.add(JEIRecipeProvider.formatItemStack((ItemLike)((ItemStackEntry)stack.value).getMatchingStack().m_41720_(), ((ItemStackEntry)stack.value).getMinCount(), ((ItemStackEntry)stack.value).getMaxCount(), stack.weight, totalWeight.get())));
                    lootInfo.put((Integer)minLevel, LabeledLootInfo.of(results, (Component)new TextComponent("Reward Pool: " + id + " Level: " + minLevel + "+"), (Component)new TextComponent("Vault Exp Reward: " + vaultExp.getMin() + "-" + vaultExp.getMax())));
                });
            }
            lootInfo.forEach((n, i) -> toReturn.add((LabeledLootInfo)i));
        });
        return toReturn;
    }

    protected static List<LabeledLootInfo> getAltarIngredients() {
        ArrayList<LabeledLootInfo> toReturn = new ArrayList<LabeledLootInfo>();
        AltarIngredientAccessor rewardPools = (AltarIngredientAccessor)ModConfigs.VAULT_ALTAR_INGREDIENTS;
        TreeMap<Integer, List> lootInfo = new TreeMap<Integer, List>();
        rewardPools.getLEVELS().forEach((minLevel, entry) -> {
            ArrayList pool = new ArrayList();
            entry.forEach((slot, rewards) -> {
                AtomicInteger totalWeight = new AtomicInteger();
                ArrayList<List<ItemStack>> results = new ArrayList<List<ItemStack>>();
                rewards.forEach(stack -> totalWeight.addAndGet(stack.weight));
                rewards.forEach(stack -> {
                    IntRangeEntry amounts = ((IngredientAmountAccessor)stack.value).getAmount();
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (ItemStack stackInGroup : ((AltarIngredientEntry)stack.value).getItems()) {
                        stacks.add(JEIRecipeProvider.formatItemStack((ItemLike)stackInGroup.m_41720_(), amounts.getMin(), amounts.getMax(), stack.weight, totalWeight.get()));
                    }
                    results.add(stacks);
                });
                pool.add(new LabeledLootInfo(results, (Component)new TextComponent("Reward Pool: " + slot + " Level: " + minLevel + "+")));
            });
            lootInfo.put((Integer)minLevel, pool);
        });
        lootInfo.forEach((i, n) -> toReturn.addAll((Collection<LabeledLootInfo>)n));
        return toReturn;
    }

    protected static List<LabeledLootInfo> getMaterialBoxLoot() {
        ArrayList<LabeledLootInfo> toReturn = new ArrayList<LabeledLootInfo>();
        TreeMap<Integer, List> lootInfo = new TreeMap<Integer, List>();
        ModConfigs.MATERIAL_BOX.LEVELS.forEach(levelEntry -> {
            ArrayList pool = new ArrayList();
            AtomicInteger totalWeight = new AtomicInteger();
            ArrayList results = new ArrayList();
            levelEntry.pool.forEach(stack -> totalWeight.addAndGet(stack.weight));
            levelEntry.pool.forEach((group, weight) -> {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (ProductEntry stackInGroup : group.entries) {
                    ProductEntryAccessor accessor = (ProductEntryAccessor)stackInGroup;
                    stacks.add(JEIRecipeProvider.formatItemStack((ItemLike)stackInGroup.getItem(), accessor.getAmountMin(), accessor.getAmountMax(), weight.intValue(), totalWeight.get()));
                }
                results.add(stacks);
                pool.add(new LabeledLootInfo(results, (Component)new TextComponent(" Level: " + levelEntry.level + "+")));
            });
            lootInfo.put(levelEntry.getLevel(), pool);
        });
        lootInfo.forEach((i, n) -> toReturn.addAll((Collection<LabeledLootInfo>)n));
        return toReturn;
    }

    protected static <T extends AbstractStatueLootConfig> List<LabeledLootInfo> getStatueLoot(T lootConfig) {
        ArrayList<LabeledLootInfo> toReturn = new ArrayList<LabeledLootInfo>();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int interval = lootConfig.getInterval();
        int minCount = lootConfig.getRollRange().getMin();
        int maxCount = lootConfig.getRollRange().getMax();
        int totalWeight = lootConfig.getDrops().getTotalWeight();
        lootConfig.getDrops().forEach((product, weight) -> {
            ProductEntryAccessor accessor = (ProductEntryAccessor)product;
            items.add(JEIRecipeProvider.formatItemStack((ItemLike)product.getItem(), accessor.getAmountMin(), accessor.getAmountMax(), weight.intValue(), totalWeight));
        });
        toReturn.add(LabeledLootInfo.of(items, (Component)new TextComponent("Interval: " + interval), (Component)new TextComponent("Count: " + minCount + " - " + maxCount)));
        return toReturn;
    }

    private static ItemStack formatItemStack(ItemLike item, int amountMin, int amountMax, int weight, int totalWeight, boolean cost) {
        ItemStack result = new ItemStack(item, amountMax);
        double chance = (double)weight / (double)totalWeight * 100.0;
        CompoundTag nbt = result.m_41698_("display");
        ListTag list = nbt.m_128437_("Lore", 8);
        TextComponent chanceLabel = new TextComponent("Chance: ");
        chanceLabel.m_130946_(String.format("%.2f", chance));
        chanceLabel.m_130946_("%");
        list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)chanceLabel.m_130940_(ChatFormatting.YELLOW))));
        if (amountMin != amountMax) {
            TextComponent countLabel = new TextComponent(cost ? "Cost: " : "Count: ");
            countLabel.m_130946_(amountMin + " - " + amountMax);
            list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)countLabel)));
        }
        nbt.m_128365_("Lore", (Tag)list);
        return result;
    }

    private static ItemStack formatItemStack(ItemLike item, int amountMin, int amountMax, int weight, int totalWeight) {
        return JEIRecipeProvider.formatItemStack(item, amountMin, amountMax, weight, totalWeight, false);
    }
}

