/*
 * Decompiled with CFR 0.152.
 */
package dev.attackeight.the_vault_jei.jei;

import dev.attackeight.the_vault_jei.TheVaultJEI;
import dev.attackeight.the_vault_jei.jei.ForgeItem;
import dev.attackeight.the_vault_jei.jei.JEIRecipeProvider;
import dev.attackeight.the_vault_jei.jei.LabeledIngredientPool;
import dev.attackeight.the_vault_jei.jei.LabeledLootInfo;
import dev.attackeight.the_vault_jei.jei.category.ForgeItemRecipeCategory;
import dev.attackeight.the_vault_jei.jei.category.LabeledIngredientPoolRecipeCategory;
import dev.attackeight.the_vault_jei.jei.category.LabeledLootInfoRecipeCategory;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.integration.jei.lootinfo.LootInfo;
import iskallia.vault.integration.jei.lootinfo.LootInfoRecipeCategory;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@JeiPlugin
public class TheVaultJEIPlugin
implements IModPlugin {
    public static final RecipeType<ForgeItem> CATALYSTS = RecipeType.create((String)"the_vault", (String)"forge_catalysts", ForgeItem.class);
    public static final RecipeType<ForgeItem> TOOLS = RecipeType.create((String)"the_vault", (String)"forge_tools", ForgeItem.class);
    public static final RecipeType<ForgeItem> GEAR = RecipeType.create((String)"the_vault", (String)"forge_gear", ForgeItem.class);
    public static final RecipeType<ForgeItem> INSCRIPTIONS = RecipeType.create((String)"the_vault", (String)"forge_inscription", ForgeItem.class);
    public static final RecipeType<LootInfo> MYSTERY_BOX = RecipeType.create((String)"the_vault", (String)"mystery_box", LootInfo.class);
    public static final RecipeType<LootInfo> MYSTERY_EGG = RecipeType.create((String)"the_vault", (String)"mystery_egg", LootInfo.class);
    public static final RecipeType<LootInfo> HOSTILE_EGG = RecipeType.create((String)"the_vault", (String)"hostile_egg", LootInfo.class);
    public static final RecipeType<LabeledLootInfo> BLACK_MARKET = RecipeType.create((String)"the_vault", (String)"black_market", LabeledLootInfo.class);
    public static final RecipeType<LabeledLootInfo> MOD_BOX = RecipeType.create((String)"the_vault", (String)"mod_box", LabeledLootInfo.class);
    public static final RecipeType<LabeledLootInfo> BOUNTY_REWARDS = RecipeType.create((String)"the_vault", (String)"bounty_rewards", LabeledLootInfo.class);
    public static final RecipeType<LabeledIngredientPool> ALTAR_INGREDIENTS = RecipeType.create((String)"the_vault", (String)"altar_ingredients", LabeledIngredientPool.class);

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CATALYST_INFUSION_TABLE), new RecipeType[]{CATALYSTS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.TOOL_STATION), new RecipeType[]{TOOLS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.VAULT_FORGE), new RecipeType[]{GEAR});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.INSCRIPTION_TABLE), new RecipeType[]{INSCRIPTIONS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.MYSTERY_BOX), new RecipeType[]{MYSTERY_BOX});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.MYSTERY_EGG), new RecipeType[]{MYSTERY_EGG});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.MYSTERY_HOSTILE_EGG), new RecipeType[]{HOSTILE_EGG});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BLACK_MARKET), new RecipeType[]{BLACK_MARKET});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.MOD_BOX), new RecipeType[]{MOD_BOX});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BOUNTY_BLOCK), new RecipeType[]{BOUNTY_REWARDS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.VAULT_ALTAR), new RecipeType[]{ALTAR_INGREDIENTS});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeForgeItemCategory(guiHelper, CATALYSTS, (ItemLike)ModBlocks.CATALYST_INFUSION_TABLE)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeForgeItemCategory(guiHelper, TOOLS, (ItemLike)ModBlocks.TOOL_STATION)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeForgeItemCategory(guiHelper, GEAR, (ItemLike)ModBlocks.VAULT_FORGE)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeForgeItemCategory(guiHelper, INSCRIPTIONS, (ItemLike)ModBlocks.INSCRIPTION_TABLE)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeLootInfoCategory(guiHelper, MYSTERY_BOX, (ItemLike)ModItems.MYSTERY_BOX)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeLootInfoCategory(guiHelper, MYSTERY_EGG, (ItemLike)ModItems.MYSTERY_EGG)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeLootInfoCategory(guiHelper, HOSTILE_EGG, (ItemLike)ModItems.MYSTERY_HOSTILE_EGG)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeLabeledLootInfoCategory(guiHelper, BLACK_MARKET, (ItemLike)ModBlocks.BLACK_MARKET)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeLabeledLootInfoCategory(guiHelper, MOD_BOX, (ItemLike)ModItems.MOD_BOX)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeLabeledLootInfoCategory(guiHelper, BOUNTY_REWARDS, (ItemLike)ModBlocks.BOUNTY_BLOCK)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeLabeledIngredientPoolCategory(guiHelper, ALTAR_INGREDIENTS, (ItemLike)ModBlocks.VAULT_ALTAR)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(CATALYSTS, JEIRecipeProvider.getCatalystRecipes());
        registration.addRecipes(TOOLS, JEIRecipeProvider.getToolRecipes());
        registration.addRecipes(GEAR, JEIRecipeProvider.getGearRecipes());
        registration.addRecipes(INSCRIPTIONS, JEIRecipeProvider.getInscriptionRecipes());
        registration.addRecipes(MYSTERY_BOX, JEIRecipeProvider.getMysteryBoxLoot());
        registration.addRecipes(MYSTERY_EGG, JEIRecipeProvider.getMysteryEggLoot());
        registration.addRecipes(HOSTILE_EGG, JEIRecipeProvider.getHostileEggLoot());
        registration.addRecipes(BLACK_MARKET, JEIRecipeProvider.getBlackMarketLoot());
        registration.addRecipes(MOD_BOX, JEIRecipeProvider.getModBoxLoot());
        registration.addRecipes(BOUNTY_REWARDS, JEIRecipeProvider.getBountyRewards());
        registration.addRecipes(ALTAR_INGREDIENTS, JEIRecipeProvider.getAltarIngredients());
    }

    public ResourceLocation getPluginUid() {
        return TheVaultJEI.rl("jei_integration");
    }

    private LootInfoRecipeCategory makeLootInfoCategory(IGuiHelper guiHelper, RecipeType<LootInfo> recipeType, ItemLike icon) {
        return new LootInfoRecipeCategory(guiHelper, recipeType, new ItemStack(icon), icon.m_5456_().m_7626_(new ItemStack(icon)));
    }

    private LabeledLootInfoRecipeCategory makeLabeledLootInfoCategory(IGuiHelper guiHelper, RecipeType<LabeledLootInfo> recipeType, ItemLike icon) {
        return new LabeledLootInfoRecipeCategory(guiHelper, recipeType, new ItemStack(icon), icon.m_5456_().m_7626_(new ItemStack(icon)));
    }

    private LabeledIngredientPoolRecipeCategory makeLabeledIngredientPoolCategory(IGuiHelper guiHelper, RecipeType<LabeledIngredientPool> recipeType, ItemLike icon) {
        return new LabeledIngredientPoolRecipeCategory(guiHelper, recipeType, new ItemStack(icon), icon.m_5456_().m_7626_(new ItemStack(icon)));
    }

    private ForgeItemRecipeCategory makeForgeItemCategory(IGuiHelper guiHelper, RecipeType<ForgeItem> recipeType, ItemLike icon) {
        return new ForgeItemRecipeCategory(guiHelper, recipeType, new ItemStack(icon), icon.m_5456_().m_7626_(new ItemStack(icon)));
    }
}

