/*
 * Decompiled with CFR 0.152.
 */
package dev.attackeight.the_vault_jei.jei;

import dev.attackeight.the_vault_jei.TheVaultJEI;
import dev.attackeight.the_vault_jei.jei.ForgeItem;
import dev.attackeight.the_vault_jei.jei.LabeledLootInfo;
import dev.attackeight.the_vault_jei.mixin.AltarIngredientAccessor;
import dev.attackeight.the_vault_jei.mixin.ArenaGiftStatueLootConfigAccessor;
import dev.attackeight.the_vault_jei.mixin.GiftStatueLootConfigAccessor;
import dev.attackeight.the_vault_jei.mixin.IngredientAmountAccessor;
import dev.attackeight.the_vault_jei.mixin.MegaGiftStatueLootConfigAccessor;
import dev.attackeight.the_vault_jei.mixin.ProductEntryAccessor;
import dev.attackeight.the_vault_jei.mixin.RewardEntryAccessor;
import dev.attackeight.the_vault_jei.mixin.RewardPoolAccessor;
import dev.attackeight.the_vault_jei.mixin.VaultStatueStatueLootConfigAccessor;
import io.github.a1qs.vaultadditions.config.CustomVaultConfigRegistry;
import iskallia.vault.config.OmegaSoulShardConfig;
import iskallia.vault.config.SoulShardConfig;
import iskallia.vault.config.altar.entry.AltarIngredientEntry;
import iskallia.vault.config.entry.IntRangeEntry;
import iskallia.vault.config.entry.ItemStackEntry;
import iskallia.vault.config.entry.recipe.ConfigForgeRecipe;
import iskallia.vault.config.entry.vending.ProductEntry;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.integration.jei.lootinfo.LootInfo;
import iskallia.vault.util.data.WeightedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class JEIRecipeProvider {
    protected static List<ForgeItem> getCatalystRecipes() {
        return JEIRecipeProvider.getForgeRecipes(ModConfigs.CATALYST_RECIPES.getConfigRecipes());
    }

    protected static List<ForgeItem> getToolRecipes() {
        return JEIRecipeProvider.getForgeRecipes(ModConfigs.TOOL_RECIPES.getConfigRecipes());
    }

    protected static List<ForgeItem> getGearRecipes() {
        List<ForgeItem> recipes = JEIRecipeProvider.getForgeRecipes(ModConfigs.GEAR_RECIPES.getConfigRecipes());
        recipes.addAll(JEIRecipeProvider.getForgeRecipes(ModConfigs.TRINKET_RECIPES.getConfigRecipes()));
        return recipes;
    }

    protected static List<ForgeItem> getInscriptionRecipes() {
        return JEIRecipeProvider.getForgeRecipes(ModConfigs.INSCRIPTION_RECIPES.getConfigRecipes());
    }

    protected static List<ForgeItem> getJewelCraftingRecipes() {
        return JEIRecipeProvider.getForgeRecipes(ModConfigs.JEWEL_CRAFTING_RECIPES.getConfigRecipes());
    }

    private static <R extends VaultForgeRecipe, T extends ConfigForgeRecipe<R>> List<ForgeItem> getForgeRecipes(List<T> configRecipes) {
        ArrayList<ForgeItem> recipes = new ArrayList<ForgeItem>();
        configRecipes.forEach(b -> recipes.add(new ForgeItem(b.makeRecipe().getInputs(), b.makeRecipe().getDisplayOutput(100))));
        return recipes;
    }

    protected static List<LootInfo> getMysteryBoxLoot() {
        ArrayList<LootInfo> lootInfo = new ArrayList<LootInfo>();
        lootInfo.add(JEIRecipeProvider.getFromPool((WeightedList<ProductEntry>)ModConfigs.MYSTERY_BOX.POOL));
        return lootInfo;
    }

    protected static List<LootInfo> getMysteryEggLoot() {
        ArrayList<LootInfo> lootInfo = new ArrayList<LootInfo>();
        lootInfo.add(JEIRecipeProvider.getFromPool((WeightedList<ProductEntry>)ModConfigs.MYSTERY_EGG.POOL));
        return lootInfo;
    }

    protected static List<LootInfo> getHostileEggLoot() {
        ArrayList<LootInfo> lootInfo = new ArrayList<LootInfo>();
        lootInfo.add(JEIRecipeProvider.getFromPool((WeightedList<ProductEntry>)ModConfigs.MYSTERY_HOSTILE_EGG.POOL));
        return lootInfo;
    }

    protected static List<LootInfo> getPandorasBoxLoot() {
        ArrayList<LootInfo> lootInfo = new ArrayList<LootInfo>();
        lootInfo.add(JEIRecipeProvider.getFromPool((WeightedList<ProductEntry>)ModConfigs.PANDORAS_BOX.POOL));
        return lootInfo;
    }

    protected static LootInfo getFromPool(WeightedList<ProductEntry> pool) {
        ArrayList loot = new ArrayList();
        int total = pool.getTotalWeight();
        pool.forEach(b -> loot.add(JEIRecipeProvider.addWeight((WeightedList.Entry<ProductEntry>)b, total)));
        return new LootInfo(loot);
    }

    protected static ItemStack addWeight(WeightedList.Entry<ProductEntry> productEntry, int totalWeight) {
        ProductEntryAccessor entry = (ProductEntryAccessor)productEntry.value;
        if (!ForgeRegistries.ITEMS.containsKey(((ProductEntry)productEntry.value).getItem().getRegistryName())) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)((ProductEntry)productEntry.value).getItem(), entry.getAmountMax());
        CompoundTag nbt = stack.m_41698_("display");
        ListTag list = nbt.m_128437_("Lore", 8);
        TextComponent component = new TextComponent("Chance: ");
        double chance = (double)productEntry.weight / (double)totalWeight * 100.0;
        component.m_130946_(String.format("%.2f", chance));
        component.m_130946_("%");
        list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)component.m_130940_(ChatFormatting.YELLOW))));
        if (entry.getAmountMax() != entry.getAmountMin()) {
            TextComponent countLabel = new TextComponent("Count: ");
            countLabel.m_130946_(entry.getAmountMin() + " - " + entry.getAmountMax());
            list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)countLabel)));
        }
        nbt.m_128365_("Lore", (Tag)list);
        return stack;
    }

    protected static List<LabeledLootInfo> getShopPedestalLoot() {
        List pedestalInfo;
        ArrayList<LabeledLootInfo> lootInfo = new ArrayList<LabeledLootInfo>();
        try {
            pedestalInfo = (List)ModConfigs.SHOP_PEDESTAL.getClass().getMethod("getTrades", new Class[0]).invoke((Object)ModConfigs.SHOP_PEDESTAL, new Object[0]);
        }
        catch (Exception e) {
            TheVaultJEI.LOGGER.error(e.toString());
            return new ArrayList<LabeledLootInfo>();
        }
        pedestalInfo.forEach(tierInfo -> {
            List tier = (List)tierInfo.getLeft();
            int minLevel = (Integer)tierInfo.getRight();
            AtomicInteger totalWeight = new AtomicInteger();
            tier.forEach(d -> totalWeight.addAndGet(((Double)d.getRight()).intValue()));
            ArrayList<ItemStack> offers = new ArrayList<ItemStack>();
            tier.forEach(offerInfo -> {
                ItemStack currentOffer = (ItemStack)offerInfo.getLeft();
                int minPrice = ((IntRangeEntry)offerInfo.getMiddle()).getMin();
                int maxPrice = ((IntRangeEntry)offerInfo.getMiddle()).getMax();
                double chance = (Double)offerInfo.getRight() / (double)totalWeight.get() * 100.0;
                CompoundTag nbt = currentOffer.m_41698_("display");
                ListTag list = nbt.m_128437_("Lore", 8);
                TextComponent chanceLabel = new TextComponent("Chance: ");
                chanceLabel.m_130946_(String.format("%.2f", chance));
                chanceLabel.m_130946_("%");
                list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)chanceLabel.m_130940_(ChatFormatting.YELLOW))));
                TextComponent costLabel = new TextComponent("Cost: ");
                costLabel.m_130946_(minPrice + " - " + maxPrice);
                list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)costLabel)));
                nbt.m_128365_("Lore", (Tag)list);
                if (!TheVaultJEI.SHOP_PEDESTAL_ITEMS.containsKey((Object)currentOffer.m_41720_().getRegistryName())) {
                    TheVaultJEI.SHOP_PEDESTAL_ITEMS.put((Object)currentOffer.m_41720_().getRegistryName(), (Object)minLevel);
                }
                offers.add(currentOffer);
            });
            lootInfo.add(LabeledLootInfo.of(offers, (Component)new TextComponent("Level " + minLevel + "+ "), null));
        });
        return lootInfo;
    }

    protected static List<LabeledLootInfo> getBlackMarketLoot() {
        ArrayList<LabeledLootInfo> lootInfo = new ArrayList<LabeledLootInfo>();
        Set tradesList = ModConfigs.SOUL_SHARD.getTrades();
        tradesList.forEach(b -> {
            int minLevel = b.getMinLevel();
            int randomPrice = b.getShardTradePrice();
            ArrayList<ItemStack> shardTrades = new ArrayList<ItemStack>();
            AtomicInteger totalWeight = new AtomicInteger();
            b.getShardTrades().forEach(d -> totalWeight.addAndGet(d.weight));
            b.getShardTrades().forEach(c -> {
                ItemStack currentTrade = ((SoulShardConfig.ShardTrade)c.value).getItemEntry().createItemStack();
                int minPrice = ((SoulShardConfig.ShardTrade)c.value).getMinPrice();
                int maxPrice = ((SoulShardConfig.ShardTrade)c.value).getMaxPrice();
                double chance = (double)c.weight / (double)totalWeight.get() * 100.0 * 2.0;
                CompoundTag nbt = currentTrade.m_41698_("display");
                ListTag list = nbt.m_128437_("Lore", 8);
                TextComponent chanceLabel = new TextComponent("Chance: ");
                chanceLabel.m_130946_(String.format("%.2f", chance));
                chanceLabel.m_130946_("%");
                list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)chanceLabel.m_130940_(ChatFormatting.YELLOW))));
                TextComponent costLabel = new TextComponent("Cost: ");
                costLabel.m_130946_(minPrice + " - " + maxPrice);
                list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)costLabel)));
                nbt.m_128365_("Lore", (Tag)list);
                if (!TheVaultJEI.BLACK_MARKET_ITEMS.containsKey((Object)currentTrade.m_41720_().getRegistryName())) {
                    TheVaultJEI.BLACK_MARKET_ITEMS.put((Object)currentTrade.m_41720_().getRegistryName(), (Object)minLevel);
                }
                shardTrades.add(currentTrade);
            });
            lootInfo.add(LabeledLootInfo.of(shardTrades, (Component)new TextComponent("Common Slot: Level " + minLevel + "+ "), (Component)new TextComponent("Soul Trade Price: " + randomPrice)));
        });
        Set omegaTradesList = ModConfigs.OMEGA_SOUL_SHARD.getTrades();
        omegaTradesList.forEach(b -> {
            int minLevel = b.getMinLevel();
            ArrayList<ItemStack> shardTrades = new ArrayList<ItemStack>();
            AtomicInteger totalWeight = new AtomicInteger();
            b.getShardTrades().forEach(d -> totalWeight.addAndGet(d.weight));
            b.getShardTrades().forEach(c -> {
                ItemStack currentTrade = ((OmegaSoulShardConfig.ShardTrade)c.value).getItem();
                int minPrice = ((OmegaSoulShardConfig.ShardTrade)c.value).getMinPrice();
                int maxPrice = ((OmegaSoulShardConfig.ShardTrade)c.value).getMaxPrice();
                double chance = (double)c.weight / (double)totalWeight.get() * 100.0;
                CompoundTag nbt = currentTrade.m_41698_("display");
                ListTag list = nbt.m_128437_("Lore", 8);
                TextComponent chanceLabel = new TextComponent("Chance: ");
                chanceLabel.m_130946_(String.format("%.2f", chance));
                chanceLabel.m_130946_("%");
                list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)chanceLabel.m_130940_(ChatFormatting.YELLOW))));
                TextComponent costLabel = new TextComponent("Cost: ");
                costLabel.m_130946_(minPrice + " - " + maxPrice);
                list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)costLabel)));
                nbt.m_128365_("Lore", (Tag)list);
                if (!TheVaultJEI.OMEGA_BLACK_MARKET_ITEMS.containsKey((Object)currentTrade.m_41720_().getRegistryName())) {
                    TheVaultJEI.OMEGA_BLACK_MARKET_ITEMS.put((Object)currentTrade.m_41720_().getRegistryName(), (Object)minLevel);
                }
                shardTrades.add(currentTrade);
            });
            lootInfo.add(LabeledLootInfo.of(shardTrades, (Component)new TextComponent("Omega Slot: Level " + minLevel + "+ "), null));
        });
        return lootInfo;
    }

    protected static List<LabeledLootInfo> getModBoxLoot() {
        ArrayList<LabeledLootInfo> lootInfo = new ArrayList<LabeledLootInfo>();
        ModConfigs.MOD_BOX.POOL.forEach((mod, k) -> {
            AtomicInteger totalWeight = new AtomicInteger();
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            k.forEach(d -> totalWeight.addAndGet(d.weight));
            k.forEach(c -> {
                ProductEntryAccessor entry = (ProductEntryAccessor)c.value;
                ItemStack result = new ItemStack((ItemLike)((ProductEntry)c.value).getItem(), entry.getAmountMax());
                double chance = (double)c.weight / (double)totalWeight.get() * 100.0;
                CompoundTag nbt = result.m_41698_("display");
                ListTag list = nbt.m_128437_("Lore", 8);
                TextComponent chanceLabel = new TextComponent("Chance: ");
                chanceLabel.m_130946_(String.format("%.2f", chance));
                chanceLabel.m_130946_("%");
                list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)chanceLabel.m_130940_(ChatFormatting.YELLOW))));
                if (entry.getAmountMin() != entry.getAmountMax()) {
                    TextComponent countLabel = new TextComponent("Count: ");
                    countLabel.m_130946_(entry.getAmountMin() + " - " + entry.getAmountMax());
                    list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)countLabel)));
                }
                nbt.m_128365_("Lore", (Tag)list);
                results.add(result);
            });
            lootInfo.add(LabeledLootInfo.of(results, (Component)new TextComponent("Mod: " + mod), null));
        });
        return lootInfo;
    }

    protected static List<LabeledLootInfo> getBountyRewards() {
        ArrayList<LabeledLootInfo> toReturn = new ArrayList<LabeledLootInfo>();
        RewardPoolAccessor rewardPools = (RewardPoolAccessor)ModConfigs.REWARD_CONFIG;
        rewardPools.getPOOLS().forEach((id, entry) -> {
            TreeMap<Integer, LabeledLootInfo> lootInfo = new TreeMap<Integer, LabeledLootInfo>();
            if (!id.equals("submission")) {
                entry.forEach((minLevel, rewards) -> {
                    AtomicInteger totalWeight = new AtomicInteger();
                    ArrayList<ItemStack> results = new ArrayList<ItemStack>();
                    RewardEntryAccessor rewardEntry = (RewardEntryAccessor)rewards;
                    IntRangeEntry vaultExp = rewardEntry.getVaultExp();
                    rewardEntry.getItemPool().getPool().forEach(stack -> totalWeight.addAndGet(stack.weight));
                    rewardEntry.getItemPool().getPool().forEach(stack -> {
                        ItemStack result = new ItemStack((ItemLike)((ItemStackEntry)stack.value).getMatchingStack().m_41720_(), ((ItemStackEntry)stack.value).getMaxCount());
                        double chance = (double)stack.weight / (double)totalWeight.get() * 100.0;
                        CompoundTag nbt = result.m_41698_("display");
                        ListTag list = nbt.m_128437_("Lore", 8);
                        TextComponent chanceLabel = new TextComponent("Chance: ");
                        chanceLabel.m_130946_(String.format("%.2f", chance));
                        chanceLabel.m_130946_("%");
                        list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)chanceLabel.m_130940_(ChatFormatting.YELLOW))));
                        if (((ItemStackEntry)stack.value).getMinCount() != ((ItemStackEntry)stack.value).getMaxCount()) {
                            TextComponent countLabel = new TextComponent("Count: ");
                            countLabel.m_130946_(((ItemStackEntry)stack.value).getMinCount() + " - " + ((ItemStackEntry)stack.value).getMaxCount());
                            list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)countLabel)));
                        }
                        nbt.m_128365_("Lore", (Tag)list);
                        results.add(result);
                    });
                    lootInfo.put((Integer)minLevel, LabeledLootInfo.of(results, (Component)new TextComponent("Reward Pool: " + id + " Level: " + minLevel + "+"), (Component)new TextComponent("Vault Exp Reward: " + vaultExp.getMin() + "-" + vaultExp.getMax())));
                });
            }
            lootInfo.forEach((n, i) -> toReturn.add((LabeledLootInfo)i));
        });
        return toReturn;
    }

    protected static List<LabeledLootInfo> getAltarIngredients() {
        ArrayList<LabeledLootInfo> toReturn = new ArrayList<LabeledLootInfo>();
        AltarIngredientAccessor rewardPools = (AltarIngredientAccessor)ModConfigs.VAULT_ALTAR_INGREDIENTS;
        TreeMap<Integer, List> lootInfo = new TreeMap<Integer, List>();
        rewardPools.getLEVELS().forEach((minLevel, entry) -> {
            ArrayList pool = new ArrayList();
            entry.forEach((slot, rewards) -> {
                AtomicInteger totalWeight = new AtomicInteger();
                ArrayList<List<ItemStack>> results = new ArrayList<List<ItemStack>>();
                rewards.forEach(stack -> totalWeight.addAndGet(stack.weight));
                rewards.forEach(stack -> {
                    IntRangeEntry amounts = ((IngredientAmountAccessor)stack.value).getAmount();
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (ItemStack stackInGroup : ((AltarIngredientEntry)stack.value).getItems()) {
                        ItemStack result = new ItemStack((ItemLike)stackInGroup.m_41720_(), amounts.getMax());
                        double chance = (double)stack.weight / (double)totalWeight.get() * 100.0;
                        CompoundTag nbt = result.m_41698_("display");
                        ListTag list = nbt.m_128437_("Lore", 8);
                        TextComponent chanceLabel = new TextComponent("Chance: ");
                        chanceLabel.m_130946_(String.format("%.2f", chance));
                        chanceLabel.m_130946_("%");
                        list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)chanceLabel.m_130940_(ChatFormatting.YELLOW))));
                        if (amounts.getMin() != amounts.getMax()) {
                            TextComponent countLabel = new TextComponent("Count: ");
                            countLabel.m_130946_(amounts.getMin() + " - " + amounts.getMax());
                            list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)countLabel)));
                        }
                        nbt.m_128365_("Lore", (Tag)list);
                        stacks.add(result);
                    }
                    results.add(stacks);
                });
                pool.add(new LabeledLootInfo(results, (Component)new TextComponent("Reward Pool: " + slot + " Level: " + minLevel + "+")));
            });
            lootInfo.put((Integer)minLevel, pool);
        });
        lootInfo.forEach((i, n) -> toReturn.addAll((Collection<LabeledLootInfo>)n));
        return toReturn;
    }

    protected static List<LabeledLootInfo> getArenaStatueLoot() {
        ArrayList<LabeledLootInfo> toReturn = new ArrayList<LabeledLootInfo>();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArenaGiftStatueLootConfigAccessor accessor = (ArenaGiftStatueLootConfigAccessor)CustomVaultConfigRegistry.STATUE_LOOT_ARENA;
        int interval = CustomVaultConfigRegistry.STATUE_LOOT_ARENA.getInterval();
        int minCount = accessor.getMinItemGenerated();
        int maxCount = accessor.getMaxItemGenerated();
        int totalWeight = accessor.getLOOT().getTotalWeight();
        accessor.getLOOT().forEach((k, v) -> {
            ItemStack result = k.createItemStack();
            double chance = v.doubleValue() / (double)totalWeight * 100.0;
            CompoundTag nbt = result.m_41698_("display");
            ListTag list = nbt.m_128437_("Lore", 8);
            TextComponent chanceLabel = new TextComponent("Chance: ");
            chanceLabel.m_130946_(String.format("%.2f", chance));
            chanceLabel.m_130946_("%");
            list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)chanceLabel.m_130940_(ChatFormatting.YELLOW))));
            nbt.m_128365_("Lore", (Tag)list);
            items.add(result);
        });
        toReturn.add(LabeledLootInfo.of(items, (Component)new TextComponent("Interval: " + interval), (Component)new TextComponent("Count: " + minCount + " - " + maxCount)));
        return toReturn;
    }

    protected static List<LabeledLootInfo> getGiftStatueLoot() {
        ArrayList<LabeledLootInfo> toReturn = new ArrayList<LabeledLootInfo>();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        GiftStatueLootConfigAccessor accessor = (GiftStatueLootConfigAccessor)CustomVaultConfigRegistry.STATUE_LOOT_GIFT;
        int interval = CustomVaultConfigRegistry.STATUE_LOOT_GIFT.getInterval();
        int minCount = accessor.getMinItemGenerated();
        int maxCount = accessor.getMaxItemGenerated();
        int totalWeight = accessor.getLOOT().getTotalWeight();
        accessor.getLOOT().forEach((k, v) -> {
            ItemStack result = k.createItemStack();
            double chance = v.doubleValue() / (double)totalWeight * 100.0;
            CompoundTag nbt = result.m_41698_("display");
            ListTag list = nbt.m_128437_("Lore", 8);
            TextComponent chanceLabel = new TextComponent("Chance: ");
            chanceLabel.m_130946_(String.format("%.2f", chance));
            chanceLabel.m_130946_("%");
            list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)chanceLabel.m_130940_(ChatFormatting.YELLOW))));
            nbt.m_128365_("Lore", (Tag)list);
            items.add(result);
        });
        toReturn.add(LabeledLootInfo.of(items, (Component)new TextComponent("Interval: " + interval), (Component)new TextComponent("Count: " + minCount + " - " + maxCount)));
        return toReturn;
    }

    protected static List<LabeledLootInfo> getMegaGiftStatueLoot() {
        ArrayList<LabeledLootInfo> toReturn = new ArrayList<LabeledLootInfo>();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        MegaGiftStatueLootConfigAccessor accessor = (MegaGiftStatueLootConfigAccessor)CustomVaultConfigRegistry.STATUE_LOOT_MEGA_GIFT;
        int interval = CustomVaultConfigRegistry.STATUE_LOOT_MEGA_GIFT.getInterval();
        int minCount = accessor.getMinItemGenerated();
        int maxCount = accessor.getMaxItemGenerated();
        int totalWeight = accessor.getLOOT().getTotalWeight();
        accessor.getLOOT().forEach((k, v) -> {
            ItemStack result = k.createItemStack();
            double chance = v.doubleValue() / (double)totalWeight * 100.0;
            CompoundTag nbt = result.m_41698_("display");
            ListTag list = nbt.m_128437_("Lore", 8);
            TextComponent chanceLabel = new TextComponent("Chance: ");
            chanceLabel.m_130946_(String.format("%.2f", chance));
            chanceLabel.m_130946_("%");
            list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)chanceLabel.m_130940_(ChatFormatting.YELLOW))));
            nbt.m_128365_("Lore", (Tag)list);
            items.add(result);
        });
        toReturn.add(LabeledLootInfo.of(items, (Component)new TextComponent("Interval: " + interval), (Component)new TextComponent("Count: " + minCount + " - " + maxCount)));
        return toReturn;
    }

    protected static List<LabeledLootInfo> getVaultStatueLoot() {
        ArrayList<LabeledLootInfo> toReturn = new ArrayList<LabeledLootInfo>();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        VaultStatueStatueLootConfigAccessor accessor = (VaultStatueStatueLootConfigAccessor)CustomVaultConfigRegistry.STATUE_LOOT_VAULT;
        int interval = CustomVaultConfigRegistry.STATUE_LOOT_VAULT.getInterval();
        int minCount = accessor.getMinItemGenerated();
        int maxCount = accessor.getMaxItemGenerated();
        int totalWeight = accessor.getLOOT().getTotalWeight();
        accessor.getLOOT().forEach((k, v) -> {
            ItemStack result = k.createItemStack();
            double chance = v.doubleValue() / (double)totalWeight * 100.0;
            CompoundTag nbt = result.m_41698_("display");
            ListTag list = nbt.m_128437_("Lore", 8);
            TextComponent chanceLabel = new TextComponent("Chance: ");
            chanceLabel.m_130946_(String.format("%.2f", chance));
            chanceLabel.m_130946_("%");
            list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)chanceLabel.m_130940_(ChatFormatting.YELLOW))));
            nbt.m_128365_("Lore", (Tag)list);
            items.add(result);
        });
        toReturn.add(LabeledLootInfo.of(items, (Component)new TextComponent("Interval: " + interval), (Component)new TextComponent("Count: " + minCount + " - " + maxCount)));
        return toReturn;
    }
}

