/*
 * Decompiled with CFR 0.152.
 */
package dev.attackeight.the_vault_jei.jei;

import dev.attackeight.the_vault_jei.TheVaultJEI;
import dev.attackeight.the_vault_jei.jei.ForgeItem;
import dev.attackeight.the_vault_jei.jei.JEIRecipeProvider;
import dev.attackeight.the_vault_jei.jei.LabeledLootInfo;
import dev.attackeight.the_vault_jei.jei.category.ForgeItemRecipeCategory;
import dev.attackeight.the_vault_jei.jei.category.LabeledIngredientPoolRecipeCategory;
import dev.attackeight.the_vault_jei.jei.category.LabeledLootInfoRecipeCategory;
import dev.attackeight.the_vault_jei.utils.ModConfig;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.integration.jei.lootinfo.LootInfo;
import iskallia.vault.integration.jei.lootinfo.LootInfoRecipeCategory;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@JeiPlugin
public class TheVaultJEIPlugin
implements IModPlugin {
    public static final RecipeType<ForgeItem> CATALYSTS = RecipeType.create((String)"the_vault", (String)"forge_catalysts", ForgeItem.class);
    public static final RecipeType<ForgeItem> TOOLS = RecipeType.create((String)"the_vault", (String)"forge_tools", ForgeItem.class);
    public static final RecipeType<ForgeItem> GEAR = RecipeType.create((String)"the_vault", (String)"forge_gear", ForgeItem.class);
    public static final RecipeType<ForgeItem> INSCRIPTIONS = RecipeType.create((String)"the_vault", (String)"forge_inscription", ForgeItem.class);
    public static final RecipeType<ForgeItem> JEWEL_CRAFTING = RecipeType.create((String)"the_vault", (String)"jewel_crafting", ForgeItem.class);
    public static final RecipeType<LootInfo> MYSTERY_BOX = RecipeType.create((String)"the_vault", (String)"mystery_box", LootInfo.class);
    public static final RecipeType<LootInfo> MYSTERY_EGG = RecipeType.create((String)"the_vault", (String)"mystery_egg", LootInfo.class);
    public static final RecipeType<LootInfo> HOSTILE_EGG = RecipeType.create((String)"the_vault", (String)"hostile_egg", LootInfo.class);
    public static final RecipeType<LootInfo> PANDORAS_BOX = RecipeType.create((String)"the_vault", (String)"pandoras_box", LootInfo.class);
    public static final RecipeType<LabeledLootInfo> BLACK_MARKET = RecipeType.create((String)"the_vault", (String)"black_market", LabeledLootInfo.class);
    public static final RecipeType<LabeledLootInfo> MOD_BOX = RecipeType.create((String)"the_vault", (String)"mod_box", LabeledLootInfo.class);
    public static final RecipeType<LabeledLootInfo> BOUNTY_REWARDS = RecipeType.create((String)"the_vault", (String)"bounty_rewards", LabeledLootInfo.class);
    public static final RecipeType<LabeledLootInfo> SHOP_PEDESTAL = RecipeType.create((String)"the_vault", (String)"shop_pedestal", LabeledLootInfo.class);
    public static final RecipeType<LabeledLootInfo> VA_ARENA_STATUE = RecipeType.create((String)"vaultadditions", (String)"arena_statue", LabeledLootInfo.class);
    public static final RecipeType<LabeledLootInfo> VA_GIFT_STATUE = RecipeType.create((String)"vaultadditions", (String)"gift_statue", LabeledLootInfo.class);
    public static final RecipeType<LabeledLootInfo> VA_MEGA_GIFT_STATUE = RecipeType.create((String)"vaultadditions", (String)"mega_gift_statue", LabeledLootInfo.class);
    public static final RecipeType<LabeledLootInfo> VA_VAULT_STATUE = RecipeType.create((String)"vaultadditions", (String)"vault_statue", LabeledLootInfo.class);
    public static final RecipeType<LabeledLootInfo> ALTAR_INGREDIENTS = RecipeType.create((String)"the_vault", (String)"altar_ingredients", LabeledLootInfo.class);

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CATALYST_INFUSION_TABLE), new RecipeType[]{CATALYSTS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.TOOL_STATION), new RecipeType[]{TOOLS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.VAULT_FORGE), new RecipeType[]{GEAR});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.INSCRIPTION_TABLE), new RecipeType[]{INSCRIPTIONS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.JEWEL_CRAFTING_TABLE), new RecipeType[]{JEWEL_CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.MYSTERY_BOX), new RecipeType[]{MYSTERY_BOX});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.MYSTERY_EGG), new RecipeType[]{MYSTERY_EGG});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.MYSTERY_HOSTILE_EGG), new RecipeType[]{HOSTILE_EGG});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BLACK_MARKET), new RecipeType[]{BLACK_MARKET});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.MOD_BOX), new RecipeType[]{MOD_BOX});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BOUNTY_BLOCK), new RecipeType[]{BOUNTY_REWARDS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SHOP_PEDESTAL), new RecipeType[]{SHOP_PEDESTAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.VAULT_ALTAR), new RecipeType[]{ALTAR_INGREDIENTS});
        if (ModConfig.shouldShow()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.PANDORAS_BOX), new RecipeType[]{PANDORAS_BOX});
        }
        if (TheVaultJEI.vaLoaded()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)io.github.a1qs.vaultadditions.init.ModBlocks.LOOT_STATUE_ARENA.get()), new RecipeType[]{VA_ARENA_STATUE});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)io.github.a1qs.vaultadditions.init.ModBlocks.LOOT_STATUE_GIFT.get()), new RecipeType[]{VA_GIFT_STATUE});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)io.github.a1qs.vaultadditions.init.ModBlocks.LOOT_STATUE_GIFT_MEGA.get()), new RecipeType[]{VA_MEGA_GIFT_STATUE});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)io.github.a1qs.vaultadditions.init.ModBlocks.LOOT_STATUE_VAULT.get()), new RecipeType[]{VA_VAULT_STATUE});
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeForgeItemCategory(guiHelper, CATALYSTS, (ItemLike)ModBlocks.CATALYST_INFUSION_TABLE)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeForgeItemCategory(guiHelper, TOOLS, (ItemLike)ModBlocks.TOOL_STATION)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeForgeItemCategory(guiHelper, GEAR, (ItemLike)ModBlocks.VAULT_FORGE)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeForgeItemCategory(guiHelper, INSCRIPTIONS, (ItemLike)ModBlocks.INSCRIPTION_TABLE)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeForgeItemCategory(guiHelper, JEWEL_CRAFTING, (ItemLike)ModBlocks.JEWEL_CRAFTING_TABLE)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeLootInfoCategory(guiHelper, MYSTERY_BOX, (ItemLike)ModItems.MYSTERY_BOX)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeLootInfoCategory(guiHelper, MYSTERY_EGG, (ItemLike)ModItems.MYSTERY_EGG)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeLootInfoCategory(guiHelper, HOSTILE_EGG, (ItemLike)ModItems.MYSTERY_HOSTILE_EGG)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeLabeledLootInfoCategory(guiHelper, BLACK_MARKET, (ItemLike)ModBlocks.BLACK_MARKET)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeLabeledLootInfoCategory(guiHelper, MOD_BOX, (ItemLike)ModItems.MOD_BOX)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeLabeledLootInfoCategory(guiHelper, BOUNTY_REWARDS, (ItemLike)ModBlocks.BOUNTY_BLOCK)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeLabeledLootInfoCategory(guiHelper, SHOP_PEDESTAL, (ItemLike)ModBlocks.SHOP_PEDESTAL)});
        registration.addRecipeCategories(new IRecipeCategory[]{this.makeLabeledIngredientPoolCategory(guiHelper, ALTAR_INGREDIENTS, (ItemLike)ModBlocks.VAULT_ALTAR)});
        if (ModConfig.shouldShow()) {
            registration.addRecipeCategories(new IRecipeCategory[]{this.makeLootInfoCategory(guiHelper, PANDORAS_BOX, (ItemLike)ModItems.PANDORAS_BOX)});
        }
        if (TheVaultJEI.vaLoaded()) {
            registration.addRecipeCategories(new IRecipeCategory[]{this.makeLabeledLootInfoCategory(guiHelper, VA_ARENA_STATUE, (ItemLike)io.github.a1qs.vaultadditions.init.ModBlocks.LOOT_STATUE_ARENA.get())});
            registration.addRecipeCategories(new IRecipeCategory[]{this.makeLabeledLootInfoCategory(guiHelper, VA_GIFT_STATUE, (ItemLike)io.github.a1qs.vaultadditions.init.ModBlocks.LOOT_STATUE_GIFT.get())});
            registration.addRecipeCategories(new IRecipeCategory[]{this.makeLabeledLootInfoCategory(guiHelper, VA_MEGA_GIFT_STATUE, (ItemLike)io.github.a1qs.vaultadditions.init.ModBlocks.LOOT_STATUE_GIFT_MEGA.get())});
            registration.addRecipeCategories(new IRecipeCategory[]{this.makeLabeledLootInfoCategory(guiHelper, VA_VAULT_STATUE, (ItemLike)io.github.a1qs.vaultadditions.init.ModBlocks.LOOT_STATUE_VAULT.get())});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(CATALYSTS, JEIRecipeProvider.getCatalystRecipes());
        registration.addRecipes(TOOLS, JEIRecipeProvider.getToolRecipes());
        registration.addRecipes(GEAR, JEIRecipeProvider.getGearRecipes());
        registration.addRecipes(INSCRIPTIONS, JEIRecipeProvider.getInscriptionRecipes());
        registration.addRecipes(JEWEL_CRAFTING, JEIRecipeProvider.getJewelCraftingRecipes());
        registration.addRecipes(MYSTERY_BOX, JEIRecipeProvider.getMysteryBoxLoot());
        registration.addRecipes(MYSTERY_EGG, JEIRecipeProvider.getMysteryEggLoot());
        registration.addRecipes(HOSTILE_EGG, JEIRecipeProvider.getHostileEggLoot());
        registration.addRecipes(BLACK_MARKET, JEIRecipeProvider.getBlackMarketLoot());
        registration.addRecipes(MOD_BOX, JEIRecipeProvider.getModBoxLoot());
        registration.addRecipes(BOUNTY_REWARDS, JEIRecipeProvider.getBountyRewards());
        registration.addRecipes(SHOP_PEDESTAL, JEIRecipeProvider.getShopPedestalLoot());
        registration.addRecipes(ALTAR_INGREDIENTS, JEIRecipeProvider.getAltarIngredients());
        if (ModConfig.shouldShow()) {
            registration.addRecipes(PANDORAS_BOX, JEIRecipeProvider.getPandorasBoxLoot());
        }
        if (TheVaultJEI.vaLoaded()) {
            registration.addRecipes(VA_ARENA_STATUE, JEIRecipeProvider.getArenaStatueLoot());
            registration.addRecipes(VA_GIFT_STATUE, JEIRecipeProvider.getGiftStatueLoot());
            registration.addRecipes(VA_MEGA_GIFT_STATUE, JEIRecipeProvider.getMegaGiftStatueLoot());
            registration.addRecipes(VA_VAULT_STATUE, JEIRecipeProvider.getVaultStatueLoot());
        }
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return TheVaultJEI.rl("jei_integration");
    }

    private LootInfoRecipeCategory makeLootInfoCategory(IGuiHelper guiHelper, RecipeType<LootInfo> recipeType, ItemLike icon) {
        return new LootInfoRecipeCategory(guiHelper, recipeType, new ItemStack(icon), icon.m_5456_().m_7626_(new ItemStack(icon)));
    }

    private LabeledLootInfoRecipeCategory makeLabeledLootInfoCategory(IGuiHelper guiHelper, RecipeType<LabeledLootInfo> recipeType, ItemLike icon) {
        return new LabeledLootInfoRecipeCategory(guiHelper, recipeType, new ItemStack(icon), icon.m_5456_().m_7626_(new ItemStack(icon)));
    }

    private LabeledIngredientPoolRecipeCategory makeLabeledIngredientPoolCategory(IGuiHelper guiHelper, RecipeType<LabeledLootInfo> recipeType, ItemLike icon) {
        return new LabeledIngredientPoolRecipeCategory(guiHelper, recipeType, new ItemStack(icon), icon.m_5456_().m_7626_(new ItemStack(icon)));
    }

    private ForgeItemRecipeCategory makeForgeItemCategory(IGuiHelper guiHelper, RecipeType<ForgeItem> recipeType, ItemLike icon) {
        return new ForgeItemRecipeCategory(guiHelper, recipeType, new ItemStack(icon), icon.m_5456_().m_7626_(new ItemStack(icon)));
    }
}

