/*
 * Decompiled with CFR 0.152.
 */
package dev.attackeight.just_enough_vh.jei;

import dev.attackeight.just_enough_vh.JustEnoughVH;
import dev.attackeight.just_enough_vh.jei.ForgeItem;
import dev.attackeight.just_enough_vh.jei.LabeledLootInfo;
import dev.attackeight.just_enough_vh.jei.RecyclerRecipe;
import dev.attackeight.just_enough_vh.mixin.raid.ChallengeActionConfigAccessor;
import dev.attackeight.just_enough_vh.mixin.raid.FloatingItemRewardChallengeActionConfigAccessor;
import dev.attackeight.just_enough_vh.mixin.raid.LevelPoolAccessor;
import dev.attackeight.just_enough_vh.mixin.raid.PoolChallengeActionConfigAccessor;
import dev.attackeight.just_enough_vh.mixin.raid.RaidActionsConfigAccessor;
import dev.attackeight.just_enough_vh.mixin.raid.ReferenceChallengeActionConfigAccessor;
import dev.attackeight.just_enough_vh.mixin.raid.TileRewardChallengeConfigAccessor;
import dev.attackeight.just_enough_vh.mixin.raid.VanillaAttributeChallengeActionConfigAccessor;
import io.github.a1qs.vaultadditions.config.vault.AbstractStatueLootConfig;
import iskallia.vault.block.PlaceholderBlock;
import iskallia.vault.block.entity.challenge.raid.action.ChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.FloatingItemRewardChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.PoolChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.ReferenceChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.TileRewardChallengeAction;
import iskallia.vault.block.entity.challenge.raid.action.VanillaAttributeChallengeAction;
import iskallia.vault.config.LootInfoConfig;
import iskallia.vault.config.OmegaSoulShardConfig;
import iskallia.vault.config.SoulShardConfig;
import iskallia.vault.config.VaultRecyclerConfig;
import iskallia.vault.config.altar.entry.AltarIngredientEntry;
import iskallia.vault.config.entry.ChanceItemStackEntry;
import iskallia.vault.config.entry.ConditionalChanceItemStackEntry;
import iskallia.vault.config.entry.IntRangeEntry;
import iskallia.vault.config.entry.ItemStackEntry;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.config.entry.recipe.ConfigForgeRecipe;
import iskallia.vault.config.entry.vending.ProductEntry;
import iskallia.vault.config.recipe.ForgeRecipesConfig;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.world.loot.LootTableInfo;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.integration.jei.lootinfo.LootInfo;
import iskallia.vault.tags.ModItemTags;
import iskallia.vault.util.data.WeightedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;

public class JEIRecipeProvider {
    public static <R extends VaultForgeRecipe, T extends ConfigForgeRecipe<R>, S extends ForgeRecipesConfig<T, R>> List<ForgeItem> getForgeRecipes(S config) {
        ArrayList<ForgeItem> recipes = new ArrayList<ForgeItem>();
        config.getConfigRecipes().forEach(b -> recipes.add(new ForgeItem(b.makeRecipe().getInputs(), b.makeRecipe().getDisplayOutput(100))));
        return recipes;
    }

    public static List<LootInfo> getFromPool(iskallia.vault.util.data.WeightedList<ProductEntry> pool) {
        ArrayList loot = new ArrayList();
        int total = pool.getTotalWeight();
        pool.forEach(b -> loot.add(JEIRecipeProvider.addWeight((WeightedList.Entry<ProductEntry>)b, total)));
        return List.of(new LootInfo(loot));
    }

    public static ItemStack addWeight(WeightedList.Entry<ProductEntry> productEntry, int totalWeight) {
        if (!ForgeRegistries.ITEMS.containsKey(((ProductEntry)productEntry.value).getItem().getRegistryName())) {
            return ItemStack.f_41583_;
        }
        return JEIRecipeProvider.formatItemStack(((ProductEntry)productEntry.value).generateItemStack(), ((ProductEntry)productEntry.value).amountMin, ((ProductEntry)productEntry.value).amountMax, productEntry.weight, totalWeight);
    }

    public static List<LabeledLootInfo> labelDefaultLootInfo(ResourceLocation location) {
        ArrayList<LabeledLootInfo> toReturn = new ArrayList<LabeledLootInfo>();
        Set<ResourceLocation> lootTableKeys = JEIRecipeProvider.getLootTableKeysForLootInfoGroup(location);
        lootTableKeys.forEach(lootTable -> {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            LootTableInfo.getItemsForLootTableKey((ResourceLocation)lootTable).forEach(item -> itemStacks.add(((Item)ForgeRegistries.ITEMS.getValue(item)).m_7968_()));
            String[] splitLocation = lootTable.m_135815_().split("_");
            String pool = splitLocation[splitLocation.length - 1].replace("lvl", "");
            TextComponent label = new TextComponent("Pool: " + pool);
            try {
                Integer.parseInt(pool);
                label = new TextComponent("Level: " + pool + "+");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            toReturn.add(LabeledLootInfo.of(itemStacks, (Component)label, null));
        });
        return toReturn;
    }

    public static RecipeType<LabeledLootInfo> adapt(RecipeType<LootInfo> oldType) {
        return RecipeType.create((String)"just_enough_vh", (String)oldType.getUid().m_135815_(), LabeledLootInfo.class);
    }

    public static Set<ResourceLocation> getLootTableKeysForLootInfoGroup(ResourceLocation lootInfoGroupKey) {
        LootInfoConfig.LootInfo lootInfo = (LootInfoConfig.LootInfo)ModConfigs.LOOT_INFO_CONFIG.getLootInfoMap().get(lootInfoGroupKey);
        return lootInfo != null ? lootInfo.getLootTableKeys() : Collections.emptySet();
    }

    public static List<LabeledLootInfo> getShopPedestalLoot() {
        List pedestalInfo;
        ArrayList<LabeledLootInfo> lootInfo = new ArrayList<LabeledLootInfo>();
        try {
            pedestalInfo = (List)ModConfigs.SHOP_PEDESTAL.getClass().getMethod("getTrades", new Class[0]).invoke((Object)ModConfigs.SHOP_PEDESTAL, new Object[0]);
        }
        catch (Exception e) {
            JustEnoughVH.LOGGER.error(e.toString());
            return new ArrayList<LabeledLootInfo>();
        }
        pedestalInfo.forEach(tierInfo -> {
            List tier = (List)tierInfo.getLeft();
            int minLevel = (Integer)tierInfo.getRight();
            AtomicInteger totalWeight = new AtomicInteger();
            tier.forEach(d -> totalWeight.addAndGet(((Double)d.getRight()).intValue()));
            ArrayList<ItemStack> offers = new ArrayList<ItemStack>();
            tier.forEach(offerInfo -> {
                ItemStack currentOffer = (ItemStack)offerInfo.getLeft();
                if (!JustEnoughVH.SHOP_PEDESTAL_ITEMS.containsKey((Object)currentOffer.m_41720_().getRegistryName())) {
                    JustEnoughVH.SHOP_PEDESTAL_ITEMS.put((Object)currentOffer.m_41720_().getRegistryName(), (Object)minLevel);
                }
                offers.add(JEIRecipeProvider.formatItemStack(currentOffer, ((IntRangeEntry)offerInfo.getMiddle()).getMin(), ((IntRangeEntry)offerInfo.getMiddle()).getMax(), ((Double)offerInfo.getRight()).intValue(), totalWeight.get(), currentOffer.m_41613_()));
            });
            lootInfo.add(LabeledLootInfo.of(offers, (Component)new TextComponent("Level " + minLevel + "+ "), null));
        });
        return lootInfo;
    }

    public static List<LabeledLootInfo> getBlackMarketLoot() {
        ArrayList<LabeledLootInfo> lootInfo = new ArrayList<LabeledLootInfo>();
        Set tradesList = ModConfigs.SOUL_SHARD.getTrades();
        tradesList.forEach(b -> {
            int minLevel = b.getMinLevel();
            int randomPrice = b.getShardTradePrice();
            ArrayList<ItemStack> shardTrades = new ArrayList<ItemStack>();
            AtomicInteger totalWeight = new AtomicInteger();
            b.getShardTrades().forEach(d -> totalWeight.addAndGet(d.weight));
            b.getShardTrades().forEach(c -> {
                ItemStack currentTrade = ((SoulShardConfig.ShardTrade)c.value).getItemEntry().createItemStack();
                if (!JustEnoughVH.BLACK_MARKET_ITEMS.containsKey((Object)currentTrade.m_41720_().getRegistryName())) {
                    JustEnoughVH.BLACK_MARKET_ITEMS.put((Object)currentTrade.m_41720_().getRegistryName(), (Object)minLevel);
                }
                shardTrades.add(JEIRecipeProvider.formatItemStack(currentTrade, ((SoulShardConfig.ShardTrade)c.value).getMinPrice(), ((SoulShardConfig.ShardTrade)c.value).getMaxPrice(), c.weight, totalWeight.get(), ((SoulShardConfig.ShardTrade)c.value).getItemEntry().AMOUNT));
            });
            lootInfo.add(LabeledLootInfo.of(shardTrades, (Component)new TextComponent("Common Slot: Level " + minLevel + "+ "), (Component)new TextComponent("Soul Trade Price: " + randomPrice)));
        });
        Set omegaTradesList = ModConfigs.OMEGA_SOUL_SHARD.getTrades();
        omegaTradesList.forEach(b -> {
            int minLevel = b.getMinLevel();
            ArrayList<ItemStack> shardTrades = new ArrayList<ItemStack>();
            AtomicInteger totalWeight = new AtomicInteger();
            b.getShardTrades().forEach(d -> totalWeight.addAndGet(d.weight));
            b.getShardTrades().forEach(c -> {
                ItemStack currentTrade = ((OmegaSoulShardConfig.ShardTrade)c.value).getItem();
                if (!JustEnoughVH.OMEGA_BLACK_MARKET_ITEMS.containsKey((Object)currentTrade.m_41720_().getRegistryName())) {
                    JustEnoughVH.OMEGA_BLACK_MARKET_ITEMS.put((Object)currentTrade.m_41720_().getRegistryName(), (Object)minLevel);
                }
                shardTrades.add(JEIRecipeProvider.formatItemStack(currentTrade, ((OmegaSoulShardConfig.ShardTrade)c.value).getMinPrice(), ((OmegaSoulShardConfig.ShardTrade)c.value).getMaxPrice(), c.weight, totalWeight.get(), ((OmegaSoulShardConfig.ShardTrade)c.value).getItemEntry().AMOUNT));
            });
            lootInfo.add(LabeledLootInfo.of(shardTrades, (Component)new TextComponent("Omega Slot: Level " + minLevel + "+ "), null));
        });
        return lootInfo;
    }

    public static List<LabeledLootInfo> getModBoxLoot() {
        ArrayList<LabeledLootInfo> lootInfo = new ArrayList<LabeledLootInfo>();
        ModConfigs.MOD_BOX.POOL.forEach((mod, k) -> {
            AtomicInteger totalWeight = new AtomicInteger();
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            k.forEach(d -> totalWeight.addAndGet(d.weight));
            k.forEach(c -> results.add(JEIRecipeProvider.formatItemStack(((ProductEntry)c.value).generateItemStack(), ((ProductEntry)c.value).amountMin, ((ProductEntry)c.value).amountMin, c.weight, totalWeight.get())));
            lootInfo.add(LabeledLootInfo.of(results, (Component)new TextComponent("Mod: " + mod), null));
        });
        return lootInfo;
    }

    public static List<LabeledLootInfo> getBountyRewards() {
        ArrayList<LabeledLootInfo> toReturn = new ArrayList<LabeledLootInfo>();
        ModConfigs.REWARD_CONFIG.POOLS.forEach((id, entry) -> {
            TreeMap<Integer, LabeledLootInfo> lootInfo = new TreeMap<Integer, LabeledLootInfo>();
            if (!id.equals("submission")) {
                entry.forEach((minLevel, rewards) -> {
                    AtomicInteger totalWeight = new AtomicInteger();
                    ArrayList<ItemStack> results = new ArrayList<ItemStack>();
                    IntRangeEntry vaultExp = rewards.vaultExp;
                    rewards.getItemPool().getPool().forEach(stack -> totalWeight.addAndGet(stack.weight));
                    rewards.getItemPool().getPool().forEach(stack -> results.add(JEIRecipeProvider.formatItemStack(((ItemStackEntry)stack.value).getMatchingStack(), ((ItemStackEntry)stack.value).getMinCount(), ((ItemStackEntry)stack.value).getMaxCount(), stack.weight, totalWeight.get())));
                    lootInfo.put((Integer)minLevel, LabeledLootInfo.of(results, (Component)new TextComponent("Reward Pool: " + id + " Level: " + minLevel + "+"), (Component)new TextComponent("Vault Exp Reward: " + vaultExp.getMin() + "-" + vaultExp.getMax())));
                });
            }
            lootInfo.forEach((n, i) -> toReturn.add((LabeledLootInfo)i));
        });
        return toReturn;
    }

    public static List<LabeledLootInfo> getAltarIngredients() {
        ArrayList<LabeledLootInfo> toReturn = new ArrayList<LabeledLootInfo>();
        TreeMap<Integer, List> lootInfo = new TreeMap<Integer, List>();
        ModConfigs.VAULT_ALTAR_INGREDIENTS.getLEVELS().forEach((minLevel, entry) -> {
            ArrayList pool = new ArrayList();
            entry.forEach((slot, rewards) -> {
                AtomicInteger totalWeight = new AtomicInteger();
                ArrayList<List<ItemStack>> results = new ArrayList<List<ItemStack>>();
                rewards.forEach(stack -> totalWeight.addAndGet(stack.weight));
                rewards.forEach(stack -> {
                    IntRangeEntry amounts = ((AltarIngredientEntry)stack.value).amount;
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (ItemStack stackInGroup : ((AltarIngredientEntry)stack.value).getItems()) {
                        stacks.add(JEIRecipeProvider.formatItemStack(stackInGroup, amounts.getMin(), amounts.getMax(), stack.weight, totalWeight.get()));
                    }
                    results.add(stacks);
                });
                pool.add(new LabeledLootInfo(results, (Component)new TextComponent("Reward Pool: " + slot + " Level: " + minLevel + "+")));
            });
            lootInfo.put((Integer)minLevel, pool);
        });
        lootInfo.forEach((i, n) -> toReturn.addAll((Collection<LabeledLootInfo>)n));
        return toReturn;
    }

    public static List<LabeledLootInfo> getMaterialBoxLoot() {
        ArrayList<LabeledLootInfo> toReturn = new ArrayList<LabeledLootInfo>();
        TreeMap<Integer, List> lootInfo = new TreeMap<Integer, List>();
        ModConfigs.MATERIAL_BOX.LEVELS.forEach(levelEntry -> {
            ArrayList pool = new ArrayList();
            AtomicInteger totalWeight = new AtomicInteger();
            ArrayList results = new ArrayList();
            levelEntry.pool.forEach(stack -> totalWeight.addAndGet(stack.weight));
            levelEntry.pool.forEach((group, weight) -> {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (ProductEntry stackInGroup : group.entries) {
                    stacks.add(JEIRecipeProvider.formatItemStack(stackInGroup.generateItemStack(), stackInGroup.amountMin, stackInGroup.amountMax, weight.intValue(), totalWeight.get()));
                }
                results.add(stacks);
                pool.add(new LabeledLootInfo(results, (Component)new TextComponent(" Level: " + levelEntry.level + "+")));
            });
            lootInfo.put(levelEntry.getLevel(), pool);
        });
        lootInfo.forEach((i, n) -> toReturn.addAll((Collection<LabeledLootInfo>)n));
        return toReturn;
    }

    public static List<RecyclerRecipe> getRecyclerRecipes() {
        ArrayList<RecyclerRecipe> toReturn = new ArrayList<RecyclerRecipe>();
        VaultRecyclerConfig.RecyclerOutput gearOutput = ModConfigs.VAULT_RECYCLER.getGearRecyclingOutput();
        for (VaultGearRarity rarity : VaultGearRarity.values()) {
            if (rarity.equals((Object)VaultGearRarity.UNIQUE) || rarity.equals((Object)VaultGearRarity.SPECIAL)) continue;
            List<ItemStack> pieceStack = JEIRecipeProvider.generatePieceStack(rarity);
            List<ItemStack> outputs = List.of(JEIRecipeProvider.addLoreToRecyclerOutput(gearOutput.getMainOutput(), rarity), JEIRecipeProvider.addLoreToRecyclerOutput((ChanceItemStackEntry)gearOutput.getExtraOutput1(), rarity), JEIRecipeProvider.addLoreToRecyclerOutput((ChanceItemStackEntry)gearOutput.getExtraOutput2(), rarity));
            toReturn.add(new RecyclerRecipe(pieceStack, outputs));
        }
        VaultRecyclerConfig.RecyclerOutput trinketOutput = ModConfigs.VAULT_RECYCLER.getTrinketRecyclingOutput();
        toReturn.add(JEIRecipeProvider.getRecyclerRecipe(new ItemStack((ItemLike)ModItems.TRINKET), trinketOutput));
        VaultRecyclerConfig.RecyclerOutput jewelOutput = ModConfigs.VAULT_RECYCLER.getJewelRecyclingOutput();
        toReturn.add(JEIRecipeProvider.getRecyclerRecipe(new ItemStack((ItemLike)ModItems.JEWEL), jewelOutput));
        VaultRecyclerConfig.RecyclerOutput inscriptionOutput = ModConfigs.VAULT_RECYCLER.getInscriptionRecyclingOutput();
        toReturn.add(JEIRecipeProvider.getRecyclerRecipe(new ItemStack((ItemLike)ModItems.INSCRIPTION), inscriptionOutput));
        VaultRecyclerConfig.RecyclerOutput charmOutput = ModConfigs.VAULT_RECYCLER.getCharmRecyclingOutput();
        toReturn.add(JEIRecipeProvider.getRecyclerRecipe(new ItemStack((ItemLike)ModItems.VAULT_GOD_CHARM), charmOutput));
        VaultRecyclerConfig.RecyclerOutput voidStoneOutput = ModConfigs.VAULT_RECYCLER.getVoidStoneRecyclingOutput();
        toReturn.add(JEIRecipeProvider.getRecyclerRecipe(new ItemStack((ItemLike)ModItems.VOID_STONE), voidStoneOutput));
        return toReturn;
    }

    public static RecyclerRecipe getRecyclerRecipe(ItemStack input, VaultRecyclerConfig.RecyclerOutput output) {
        return RecyclerRecipe.of(input, List.of(JEIRecipeProvider.addLoreToRecyclerOutput(output.getMainOutput()), JEIRecipeProvider.addLoreToRecyclerOutput((ChanceItemStackEntry)output.getExtraOutput1()), JEIRecipeProvider.addLoreToRecyclerOutput((ChanceItemStackEntry)output.getExtraOutput2())));
    }

    public static ItemStack addLoreToRecyclerOutput(ChanceItemStackEntry entry) {
        return JEIRecipeProvider.addLoreToRecyclerOutput(entry, null);
    }

    public static ItemStack addLoreToRecyclerOutput(ChanceItemStackEntry entry, @Nullable VaultGearRarity rarity) {
        AtomicReference<ItemStack> toReturn = new AtomicReference<ItemStack>(entry.getMatchingStack());
        AtomicReference<Float> chance = new AtomicReference<Float>(Float.valueOf(entry.getChance()));
        if (rarity != null && chance.get().floatValue() < 1.0f) {
            chance.updateAndGet(v -> Float.valueOf(v.floatValue() + ModConfigs.VAULT_RECYCLER.getAdditionalOutputRarityChance(rarity)));
        }
        try {
            if (entry instanceof ConditionalChanceItemStackEntry) {
                ConditionalChanceItemStackEntry ccise = (ConditionalChanceItemStackEntry)entry;
                ccise.getConditionalOutputs().forEach((condition, chanceItemStackEntry) -> {
                    if (condition.matches(rarity, false) || condition.matches(rarity, true)) {
                        toReturn.set(chanceItemStackEntry.getMatchingStack());
                        chance.set(Float.valueOf(chanceItemStackEntry.getChance()));
                    }
                });
            }
        }
        catch (NullPointerException ccise) {
            // empty catch block
        }
        CompoundTag nbt = toReturn.get().m_41698_("display");
        ListTag list = nbt.m_128437_("Lore", 8);
        TextComponent chanceLabel = new TextComponent("Chance: ");
        chanceLabel.m_130946_(String.format("%.0f", Float.valueOf(chance.get().floatValue() * 100.0f)));
        chanceLabel.m_130946_("%");
        list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)chanceLabel.m_130940_(ChatFormatting.YELLOW))));
        if (entry.getMinCount() != entry.getMaxCount()) {
            TextComponent countLabel = new TextComponent("Count: ");
            countLabel.m_130946_(entry.getMinCount() + " - " + entry.getMaxCount());
            list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)countLabel)));
        }
        nbt.m_128365_("Lore", (Tag)list);
        return chance.get().floatValue() == 0.0f ? ItemStack.f_41583_ : toReturn.get();
    }

    public static List<ItemStack> generatePieceStack(VaultGearRarity rarity) {
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>();
        ITag vaultGear = Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).getTag(ModItemTags.VAULT_GEAR);
        for (Item gear : vaultGear) {
            ItemStack itemStack = new ItemStack((ItemLike)gear);
            Object rollType = rarity.toString().toLowerCase();
            char firstLetter = Character.toTitleCase(((String)rollType).substring(0, 1).charAt(0));
            String restLetters = ((String)rollType).substring(1);
            rollType = firstLetter + restLetters;
            AttributeGearData data = AttributeGearData.read((ItemStack)itemStack);
            data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_ROLL_TYPE, rollType);
            data.write(itemStack);
            toReturn.add(itemStack);
        }
        return toReturn;
    }

    protected static List<LabeledLootInfo> getChallengeActionLoot() {
        ArrayList<LabeledLootInfo> lootInfo = new ArrayList<LabeledLootInfo>();
        Map<String, ChallengeAction<?>> raidValues = ((RaidActionsConfigAccessor)ModConfigs.RAID_ACTIONS).getValues();
        for (Map.Entry<String, ChallengeAction<?>> rv : raidValues.entrySet()) {
            String lootTableName = rv.getKey();
            ChallengeAction.Config config = rv.getValue().getConfig();
            if (!(config instanceof PoolChallengeAction.Config)) continue;
            PoolChallengeActionConfigAccessor poolConfig = (PoolChallengeActionConfigAccessor)config;
            LevelEntryList pools = poolConfig.getPools();
            for (LevelEntryList.ILevelEntry levelPool : pools) {
                List<ItemStack> rewardItems = JEIRecipeProvider.getFromChallengeActionPool(((LevelPoolAccessor)levelPool).getPool());
                lootInfo.add(LabeledLootInfo.of(rewardItems, (Component)new TextComponent(lootTableName + " Level: " + levelPool.getLevel() + "+"), null));
            }
        }
        return lootInfo;
    }

    protected static List<ItemStack> getFromChallengeActionPool(WeightedList<ChallengeAction<?>> pool) {
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        double total = pool.getTotalWeight();
        pool.forEach((action, weight) -> loot.add(JEIRecipeProvider.createChallengeActionStack(action, weight, total)));
        return loot;
    }

    protected static ItemStack createChallengeActionStack(ChallengeAction<?> challengeAction, double weight, double totalWeight) {
        ChallengeAction.Config config = challengeAction.getConfig();
        if (config instanceof ReferenceChallengeAction.Config) {
            ReferenceChallengeActionConfigAccessor refConfig = (ReferenceChallengeActionConfigAccessor)config;
            ChallengeAction<?> derefConfig = ((RaidActionsConfigAccessor)ModConfigs.RAID_ACTIONS).getValues().get(refConfig.getPath());
            return JEIRecipeProvider.createChallengeActionStack(derefConfig, weight, totalWeight);
        }
        if (config instanceof FloatingItemRewardChallengeAction.Config) {
            FloatingItemRewardChallengeActionConfigAccessor floatConfig = (FloatingItemRewardChallengeActionConfigAccessor)config;
            ItemStack is = JEIRecipeProvider.formatItemStack(floatConfig.getItem(), floatConfig.getItem().m_41613_(), floatConfig.getItem().m_41613_(), weight, totalWeight);
            is.m_41714_((Component)new TextComponent(floatConfig.getName()));
            return is;
        }
        if (config instanceof TileRewardChallengeAction.Config) {
            TileRewardChallengeConfigAccessor tileConfig = (TileRewardChallengeConfigAccessor)config;
            Block block = Blocks.f_50375_;
            BlockState state = tileConfig.getTile().getState().asWhole().orElse(null);
            if (state != null && (block = state.m_60734_()) == ModBlocks.PLACEHOLDER) {
                PlaceholderBlock.Type type = (PlaceholderBlock.Type)state.m_61143_((Property)PlaceholderBlock.TYPE);
                switch (type) {
                    case LIVING_CHEST: 
                    case LIVING_CHEST_GUARANTEED: 
                    case LIVING_CHEST_WATERLOGGED: {
                        block = ModBlocks.LIVING_CHEST;
                        break;
                    }
                    case ORNATE_CHEST: 
                    case ORNATE_CHEST_GUARANTEED: 
                    case ORNATE_CHEST_WATERLOGGED: {
                        block = ModBlocks.ORNATE_CHEST;
                        break;
                    }
                    case GILDED_CHEST: 
                    case GILDED_CHEST_GUARANTEED: 
                    case GILDED_CHEST_WATERLOGGED: {
                        block = ModBlocks.GILDED_CHEST;
                        break;
                    }
                    case WOODEN_CHEST: 
                    case WOODEN_CHEST_GUARANTEED: 
                    case WOODEN_CHEST_WATERLOGGED: {
                        block = ModBlocks.WOODEN_CHEST;
                        break;
                    }
                    case COIN_STACKS: 
                    case COIN_STACKS_GUARANTEED: 
                    case COIN_STACKS_WATERLOGGED: {
                        block = ModBlocks.COIN_PILE;
                        break;
                    }
                    case ORE: {
                        block = ModBlocks.LARIMAR_ORE;
                        break;
                    }
                }
            }
            ItemStack is = JEIRecipeProvider.formatItemStack(block.m_5456_().m_7968_(), tileConfig.getCount(), tileConfig.getCount(), weight, totalWeight);
            is.m_41714_((Component)new TextComponent(tileConfig.getName()));
            return is;
        }
        if (config instanceof VanillaAttributeChallengeAction.Config) {
            VanillaAttributeChallengeActionConfigAccessor vanillaAttrConfig = (VanillaAttributeChallengeActionConfigAccessor)config;
            AttributeModifier.Operation operation = vanillaAttrConfig.getOperation();
            double amount = vanillaAttrConfig.getAmount().get(0).getMin();
            String name = vanillaAttrConfig.getName();
            Attribute attribute = vanillaAttrConfig.getAttribute();
            int textColor = ((ChallengeActionConfigAccessor)config).getTextColor();
            TextComponent prefix = new TextComponent((String)(switch (operation) {
                default -> throw new IncompatibleClassChangeError();
                case AttributeModifier.Operation.ADDITION -> String.format("%+.0f", amount);
                case AttributeModifier.Operation.MULTIPLY_BASE -> String.format("%+.0f%%", amount * 100.0);
                case AttributeModifier.Operation.MULTIPLY_TOTAL -> "\u00d7" + (1.0 + amount);
            }));
            MutableComponent text = new TextComponent("").m_7220_((Component)prefix);
            if (name == null) {
                TranslatableComponent suffix = new TranslatableComponent(attribute.m_22087_());
                text = text.m_130946_(config instanceof VanillaAttributeChallengeAction.Config ? " Mob " : " Player ").m_7220_((Component)suffix);
            } else {
                text = text.m_130946_(" ").m_7220_((Component)new TextComponent(name));
            }
            MutableComponent hover = text.m_6270_(Style.f_131099_.m_178520_(textColor));
            ItemStack is = JEIRecipeProvider.formatItemStack(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43598_), 1, 1, weight, totalWeight);
            is.m_41714_((Component)hover);
            return is;
        }
        ItemStack is = JEIRecipeProvider.formatItemStack(Blocks.f_50375_.m_5456_().m_7968_(), 1, 1, weight, totalWeight);
        is.m_41714_((Component)new TextComponent("ERR - UNSUPPORTED"));
        return is;
    }

    public static <T extends AbstractStatueLootConfig> List<LabeledLootInfo> getStatueLoot(T lootConfig) {
        ArrayList<LabeledLootInfo> toReturn = new ArrayList<LabeledLootInfo>();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int interval = lootConfig.getInterval();
        int minCount = lootConfig.getRollRange().getMin();
        int maxCount = lootConfig.getRollRange().getMax();
        int totalWeight = lootConfig.getDrops().getTotalWeight();
        lootConfig.getDrops().forEach((product, weight) -> items.add(JEIRecipeProvider.formatItemStack(product.generateItemStack(), product.amountMin, product.amountMax, weight.intValue(), totalWeight)));
        toReturn.add(LabeledLootInfo.of(items, (Component)new TextComponent("Interval: " + interval), (Component)new TextComponent("Count: " + minCount + " - " + maxCount)));
        return toReturn;
    }

    private static ItemStack formatItemStack(ItemStack item, int amountMin, int amountMax, double weight, double totalWeight, @Nullable Integer amount) {
        ItemStack result = item.m_41777_();
        result.m_41764_(amount == null ? amountMax : amount);
        double chance = weight / totalWeight * 100.0;
        CompoundTag nbt = result.m_41698_("display");
        ListTag list = nbt.m_128437_("Lore", 8);
        TextComponent chanceLabel = new TextComponent("Chance: ");
        chanceLabel.m_130946_(String.format("%.2f", chance));
        chanceLabel.m_130946_("%");
        list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)chanceLabel.m_130940_(ChatFormatting.YELLOW))));
        if (amountMin != amountMax) {
            TextComponent countLabel = new TextComponent(amount == null ? "Count: " : "Cost: ");
            countLabel.m_130946_(amountMin + " - " + amountMax);
            list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)countLabel)));
        }
        nbt.m_128365_("Lore", (Tag)list);
        return result;
    }

    private static ItemStack formatItemStack(ItemStack item, int amountMin, int amountMax, double weight, double totalWeight) {
        return JEIRecipeProvider.formatItemStack(item, amountMin, amountMax, weight, totalWeight, null);
    }
}

