/*
 * Decompiled with CFR 0.152.
 */
package dev.attackeight.just_enough_vh.jei.category;

import dev.attackeight.just_enough_vh.JustEnoughVH;
import dev.attackeight.just_enough_vh.jei.ForgeItem;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ForgeItemRecipeCategory
implements IRecipeCategory<ForgeItem> {
    private static final ResourceLocation TEXTURE = JustEnoughVH.rl("textures/gui/forge_table_base.png");
    private final RecipeType<ForgeItem> recipeType;
    private final IDrawable background;
    private final Component titleComponent;
    private final IDrawable icon;

    public ForgeItemRecipeCategory(IGuiHelper guiHelper, RecipeType<ForgeItem> recipeType, ItemStack icon) {
        this.recipeType = recipeType;
        this.titleComponent = icon.m_41720_().m_7626_(icon);
        this.background = guiHelper.createDrawable(TEXTURE, 46, 15, 100, 55);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)icon);
    }

    @Nonnull
    public Component getTitle() {
        return this.titleComponent;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    @ParametersAreNonnullByDefault
    public void setRecipe(IRecipeLayoutBuilder builder, ForgeItem recipe, IFocusGroup focuses) {
        for (int x = 0; x < recipe.ingredients().size(); ++x) {
            builder.addSlot(RecipeIngredientRole.INPUT, ForgeItemRecipeCategory.getX(x), ForgeItemRecipeCategory.getY(x)).addIngredients(Ingredient.m_43927_((ItemStack[])new ItemStack[]{recipe.ingredients().get(x)}));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 78, 20).addIngredients(Ingredient.m_43927_((ItemStack[])new ItemStack[]{recipe.output()}));
    }

    @Nonnull
    public RecipeType<ForgeItem> getRecipeType() {
        return this.recipeType;
    }

    @Nonnull
    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    @Nonnull
    public Class<? extends ForgeItem> getRecipeClass() {
        return this.getRecipeType().getRecipeClass();
    }

    public static int getX(int index) {
        return switch (index) {
            case 3, 4, 5 -> 20;
            case 6, 7, 8 -> 38;
            default -> 2;
        };
    }

    public static int getY(int index) {
        return switch (index) {
            case 1, 4, 7 -> 20;
            case 2, 5, 8 -> 38;
            default -> 2;
        };
    }
}

