/*
 * Decompiled with CFR 0.152.
 */
package us.potatoboy.petowner.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import eu.midnightdust.lib.config.MidnightConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_10583;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1321;
import net.minecraft.class_1496;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_4019;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import us.potatoboy.petowner.client.config.PetOwnerConfig;
import us.potatoboy.petowner.mixin.FoxTrustedInvoker;

public class PetOwnerClient
implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"PetOwner");
    public static boolean enabled = true;
    public static class_304 keyBinding;
    private static final LoadingCache<UUID, Optional<String>> usernameCache;

    public void onInitializeClient() {
        MidnightConfig.init((String)"petowner", PetOwnerConfig.class);
        keyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.petowner.hide", class_3675.field_16237.method_1444(), "category.petowner.title"));
        class_5250 enabledText = class_2561.method_43471((String)"text.petowner.message.enabled").method_27695(new class_124[]{class_124.field_1067, class_124.field_1060});
        class_5250 disabledText = class_2561.method_43471((String)"text.petowner.message.disabled").method_27695(new class_124[]{class_124.field_1067, class_124.field_1061});
        ClientTickEvents.END_CLIENT_TICK.register(minecraftClient -> {
            if (keyBinding.method_1415()) {
                return;
            }
            if (PetOwnerConfig.keybindMode == PetOwnerConfig.KeybindMode.HOLD) {
                enabled = keyBinding.method_1434();
                if ((keyBinding.method_1434() || keyBinding.method_1436()) && minecraftClient.field_1724 != null && PetOwnerConfig.showKeybindMessage) {
                    minecraftClient.field_1724.method_7353((class_2561)(enabled ? enabledText : disabledText), true);
                }
            } else {
                while (keyBinding.method_1436()) {
                    boolean bl = enabled = !enabled;
                    if (minecraftClient.field_1724 == null || !PetOwnerConfig.showKeybindMessage) continue;
                    minecraftClient.field_1724.method_7353((class_2561)(enabled ? enabledText : disabledText), true);
                }
            }
        });
    }

    public static Optional<String> getNameFromId(UUID uuid) {
        return (Optional)usernameCache.getUnchecked((Object)uuid);
    }

    public static List<UUID> getOwnerIds(class_1297 entity) {
        class_1496 horseBaseEntity;
        class_1321 tameableEntity;
        if (entity instanceof class_1321 && (tameableEntity = (class_1321)entity).method_6181() && tameableEntity.method_66287() != null) {
            return Collections.singletonList(tameableEntity.method_66287().method_66263());
        }
        if (entity instanceof class_1496 && (horseBaseEntity = (class_1496)entity).method_6727() && horseBaseEntity.method_66287() != null) {
            return Collections.singletonList(horseBaseEntity.method_66287().method_66263());
        }
        if (entity instanceof class_4019) {
            class_4019 foxEntity = (class_4019)entity;
            return ((FoxTrustedInvoker)foxEntity).invokeGetTrustedEntities().map(class_10583::method_66263).toList();
        }
        return new ArrayList<UUID>();
    }

    static {
        usernameCache = CacheBuilder.newBuilder().expireAfterWrite(6L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<UUID, Optional<String>>(){

            @NotNull
            public Optional<String> load(@NotNull UUID key) {
                CompletableFuture.runAsync(() -> {
                    try {
                        GameProfile playerProfile = Objects.requireNonNull(class_310.method_1551().method_1495().fetchProfile(key, false)).profile();
                        usernameCache.put((Object)key, Optional.ofNullable(playerProfile.getName()));
                    }
                    catch (NullPointerException e) {
                        usernameCache.put((Object)key, Optional.empty());
                    }
                });
                return Optional.of("Waiting...");
            }
        });
    }
}

