/*
 * Decompiled with CFR 0.152.
 */
package com.jeamcube.abfurnace.procedures;

import com.jeamcube.abfurnace.init.AbfurnaceModItems;
import com.jeamcube.abfurnace.util.CapabilityHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class NewFurnaceOnTickUpdateProcedure {
    private static final int[] MATERIAL_INPUT_SLOTS = new int[]{0, 1, 2, 3, 4, 5};
    private static final int[] ENERGY_INPUT_SLOTS = new int[]{6, 7, 8, 9, 10, 11};
    private static final int[] MATERIAL_OUTPUT_SLOTS = new int[]{12, 13, 14, 15, 16, 17};
    private static final int MAX_STACK_SIZE = 64;
    private static final int ENERGY_PER_SMELT = 2;

    public static void execute(LevelAccessor world, double x, double y, double z) {
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        if (level.m_5776_()) {
            return;
        }
        NewFurnaceOnTickUpdateProcedure.processFuelToEnergy(level, pos);
        NewFurnaceOnTickUpdateProcedure.processSmeltingWithRecipes(level, pos);
    }

    private static void processFuelToEnergy(Level level, BlockPos pos) {
        int targetOutputSlot = -1;
        for (int slot : ENERGY_INPUT_SLOTS) {
            ItemStack stack = CapabilityHelper.getItemStack((LevelAccessor)level, pos, slot);
            if (stack.m_41720_() == AbfurnaceModItems.ABSOLUTE_ENERGY.get() && stack.m_41613_() < 64) {
                targetOutputSlot = slot;
                break;
            }
            if (!stack.m_41619_()) continue;
            targetOutputSlot = slot;
            break;
        }
        if (targetOutputSlot == -1) {
            return;
        }
        for (int fuelSlot : ENERGY_INPUT_SLOTS) {
            ItemStack fuelStack = CapabilityHelper.getItemStack((LevelAccessor)level, pos, fuelSlot);
            if (fuelStack.m_41619_() || fuelStack.m_41720_() == AbfurnaceModItems.ABSOLUTE_ENERGY.get() || fuelStack.getBurnTime(RecipeType.f_44108_) <= 0) continue;
            CapabilityHelper.shrinkItem((LevelAccessor)level, pos, fuelSlot, 1);
            ItemStack energyItem = new ItemStack((ItemLike)AbfurnaceModItems.ABSOLUTE_ENERGY.get());
            CapabilityHelper.addOrSetItem((LevelAccessor)level, pos, targetOutputSlot, energyItem, 1);
            return;
        }
    }

    private static void processSmeltingWithRecipes(Level level, BlockPos pos) {
        int fuelSlotToUse = -1;
        for (int fuelSlot : ENERGY_INPUT_SLOTS) {
            ItemStack fuelStack = CapabilityHelper.getItemStack((LevelAccessor)level, pos, fuelSlot);
            if (fuelStack.m_41720_() != AbfurnaceModItems.ABSOLUTE_ENERGY.get() || fuelStack.m_41613_() < 2) continue;
            fuelSlotToUse = fuelSlot;
            break;
        }
        if (fuelSlotToUse == -1) {
            return;
        }
        for (int inputSlot : MATERIAL_INPUT_SLOTS) {
            ItemStack result;
            int targetOutputSlot;
            ItemStack inputStack = CapabilityHelper.getItemStack((LevelAccessor)level, pos, inputSlot);
            if (inputStack.m_41619_()) continue;
            SimpleContainer container = new SimpleContainer(new ItemStack[]{inputStack});
            Optional recipe = level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)container, level);
            if (!recipe.isPresent() || (targetOutputSlot = NewFurnaceOnTickUpdateProcedure.findOutputSlot(level, pos, result = ((SmeltingRecipe)recipe.get()).m_8043_(level.m_9598_()).m_41777_())) == -1) continue;
            CapabilityHelper.shrinkItem((LevelAccessor)level, pos, fuelSlotToUse, 2);
            CapabilityHelper.shrinkItem((LevelAccessor)level, pos, inputSlot, 1);
            CapabilityHelper.addOrSetItem((LevelAccessor)level, pos, targetOutputSlot, result, 1);
            return;
        }
    }

    private static int findOutputSlot(Level level, BlockPos pos, ItemStack result) {
        ItemStack outputStack;
        for (int slot : MATERIAL_OUTPUT_SLOTS) {
            outputStack = CapabilityHelper.getItemStack((LevelAccessor)level, pos, slot);
            if (outputStack.m_41619_() || outputStack.m_41720_() != result.m_41720_() || outputStack.m_41613_() >= 64) continue;
            return slot;
        }
        for (int slot : MATERIAL_OUTPUT_SLOTS) {
            outputStack = CapabilityHelper.getItemStack((LevelAccessor)level, pos, slot);
            if (!outputStack.m_41619_()) continue;
            return slot;
        }
        return -1;
    }
}

