/*
 * Decompiled with CFR 0.152.
 */
package com.jeamcube.abfurnace.util;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CapabilityHelper {
    public static ItemStack getItemStack(LevelAccessor world, BlockPos pos, int slot) {
        AtomicReference<ItemStack> result = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null) {
            blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> result.set(capability.getStackInSlot(slot).m_41777_()));
        }
        return result.get();
    }

    public static int getItemCount(LevelAccessor world, BlockPos pos, int slot) {
        AtomicInteger result = new AtomicInteger(0);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null) {
            blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> result.set(capability.getStackInSlot(slot).m_41613_()));
        }
        return result.get();
    }

    public static void setItemStack(LevelAccessor world, BlockPos pos, int slot, ItemStack stack) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null) {
            blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> {
                if (capability instanceof IItemHandlerModifiable) {
                    IItemHandlerModifiable modifiable = (IItemHandlerModifiable)capability;
                    modifiable.setStackInSlot(slot, stack);
                }
            });
        }
    }

    public static void shrinkItem(LevelAccessor world, BlockPos pos, int slot, int amount) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null) {
            blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> {
                if (capability instanceof IItemHandlerModifiable) {
                    IItemHandlerModifiable modifiable = (IItemHandlerModifiable)capability;
                    ItemStack stack = capability.getStackInSlot(slot).m_41777_();
                    stack.m_41774_(amount);
                    modifiable.setStackInSlot(slot, stack);
                }
            });
        }
    }

    public static void addOrSetItem(LevelAccessor world, BlockPos pos, int slot, ItemStack stack, int amount) {
        ItemStack currentStack = CapabilityHelper.getItemStack(world, pos, slot);
        ItemStack newStack = stack.m_41777_();
        if (currentStack.m_41619_() || currentStack.m_41720_() == stack.m_41720_()) {
            int currentCount = CapabilityHelper.getItemCount(world, pos, slot);
            newStack.m_41764_(currentCount + amount);
            CapabilityHelper.setItemStack(world, pos, slot, newStack);
        }
    }
}

