/*
 * Decompiled with CFR 0.152.
 */
package com.jeamcube.abfurnace.util;

import com.jeamcube.abfurnace.util.CapabilityHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class FurnaceRecipeHelper {
    private static final int MAX_STACK_SIZE = 64;

    public static boolean canSmelt(ItemStack inputStack, ItemStack outputStack) {
        if (inputStack.m_41619_()) {
            return false;
        }
        if (outputStack.m_41619_() || outputStack.m_41720_() == Blocks.f_50016_.m_5456_()) {
            return true;
        }
        return outputStack.m_41720_() == inputStack.m_41720_();
    }

    public static boolean smeltItem(LevelAccessor world, BlockPos pos, int inputSlot, int outputSlot) {
        ItemStack inputStack = CapabilityHelper.getItemStack(world, pos, inputSlot);
        ItemStack outputStack = CapabilityHelper.getItemStack(world, pos, outputSlot);
        int outputCount = CapabilityHelper.getItemCount(world, pos, outputSlot);
        if (outputCount >= 64) {
            return false;
        }
        if (!FurnaceRecipeHelper.canSmelt(inputStack, outputStack)) {
            return false;
        }
        CapabilityHelper.addOrSetItem(world, pos, outputSlot, inputStack, 1);
        CapabilityHelper.shrinkItem(world, pos, inputSlot, 1);
        return true;
    }

    public static boolean consumeFuel(LevelAccessor world, BlockPos pos, int fuelSlot, int energySlot, ItemStack energyItem) {
        int fuelCount = CapabilityHelper.getItemCount(world, pos, fuelSlot);
        int energyCount = CapabilityHelper.getItemCount(world, pos, energySlot);
        if (fuelCount < 1 || energyCount >= 64) {
            return false;
        }
        CapabilityHelper.shrinkItem(world, pos, fuelSlot, 1);
        CapabilityHelper.addOrSetItem(world, pos, energySlot, energyItem, 1);
        return true;
    }
}

