package dev.doublekekse.spring_boots.client;

import dev.doublekekse.spring_boots.registry.SpringBootsItems;
import dev.doublekekse.spring_boots.registry.SpringBootsSoundEvents;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4943;
import net.minecraft.class_7225;
import java.util.concurrent.CompletableFuture;

public class SpringBootsDataGenerator implements DataGeneratorEntrypoint {

    @Override
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ModelProvider::new);
        pack.addProvider(EnglishLangProvider::new);
    }

    private static class EnglishLangProvider extends FabricLanguageProvider {
        protected EnglishLangProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        @Override
        public void generateTranslations(class_7225.class_7874 registryLookup, TranslationBuilder translationBuilder) {
            translationBuilder.add(SpringBootsItems.SPRING_BOOTS, "Spring Boots");
            translationBuilder.add(SpringBootsSoundEvents.SPRING_BOOTS_JUMP, "Boing");
        }
    }

    private static class ModelProvider extends FabricModelProvider {
        public ModelProvider(FabricDataOutput output) {
            super(output);
        }

        @Override
        public void generateBlockStateModels(class_4910 blockModelGenerators) {

        }

        @Override
        public void generateItemModels(class_4915 itemModelGenerators) {
            itemModelGenerators.method_65442(SpringBootsItems.SPRING_BOOTS, class_4943.field_22938);
        }
    }
}
