package dev.doublekekse.spring_boots.mixin;

import com.mojang.authlib.GameProfile;
import dev.doublekekse.spring_boots.registry.SpringBootsComponents;
import dev.doublekekse.spring_boots.registry.SpringBootsSoundEvents;
import net.minecraft.class_1304;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_746.class)
public abstract class LocalPlayerMixin extends class_742 {
    @Shadow
    public abstract boolean method_5715();

    @Unique
    private int ticksSinceJump;
    @Unique
    private boolean wasJumping;

    public LocalPlayerMixin(class_638 clientLevel, GameProfile gameProfile) {
        super(clientLevel, gameProfile);
    }

    @Inject(method = "aiStep", at = @At("HEAD"))
    void move(CallbackInfo ci) {
        var boots = method_6118(class_1304.field_6166);

        if (!boots.method_57826(SpringBootsComponents.SPRING_BOOTS)) {
            return;
        }

        ticksSinceJump++;

        if (method_70673() && !wasJumping) {
            ticksSinceJump = 0;
            wasJumping = true;
        } else if (!method_70673() && wasJumping) {
            wasJumping = false;
        }

        var delta = method_18798();

        var collision = ((EntityInvoker) this).invokeCollide(delta);

        if (delta.field_1351 != collision.field_1351) {
            var apply = new class_243(0, -2 * delta.field_1351 * multiplier(-delta.field_1351), 0);

            if (apply.field_1351 > 0.2 || wasJumping) {
                method_45319(apply);
                method_5783(SpringBootsSoundEvents.SPRING_BOOTS_JUMP, (float) Math.min(apply.field_1351 * .2f, 2), (float) (1 + ((apply.field_1351 - .2) * 0.01)));
            }
        }
    }

    @Unique
    private double multiplier(double speed) {
        if (wasJumping) {
            return class_3532.method_32854(Math.abs(ticksSinceJump - 2), 0, 40, 1.3, .8);
        }

        if (method_5715()) {
            return speed < .5 ? .2 : 0.75;
        }


        if(speed > 1) {
            return .95;
        }

        return speed < .5 ? .8 : .9;
    }
}
