/*
 * Decompiled with CFR 0.152.
 */
package invoker54.invocore.client;

import com.mojang.math.Vector3d;
import invoker54.invocore.client.ClientUtil;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="invocore")
public class InvoSound
extends AbstractSoundInstance {
    private static final Logger LOGGER = LogManager.getLogger();
    private long startTick = -1L;
    private int invoDelay = 0;
    private boolean delayedStart = false;
    private IModifySound preModifySound;
    private final SoundEvent mySoundEvent;
    private final SoundSource mySoundCategory;
    private static SoundManager soundManager;
    private Level savedWorld = null;

    public InvoSound(SoundEvent soundIn, SoundSource categoryIn) {
        super(soundIn, categoryIn);
        this.mySoundEvent = soundIn;
        this.mySoundCategory = categoryIn;
    }

    public static SoundManager getSoundHandler() {
        if (soundManager == null) {
            soundManager = ClientUtil.mC.m_91106_();
        }
        return soundManager;
    }

    public boolean isDonePlaying() {
        return !InvoSound.getSoundHandler().m_120403_((SoundInstance)this);
    }

    public InvoSound duplicate() {
        return new InvoSound(this.mySoundEvent, this.mySoundCategory).setPreModifySound(this.preModifySound).setVolume(this.f_119573_).setPitch(this.f_119574_).setPos(new Vector3d(this.f_119575_, this.f_119576_, this.f_119577_)).setRepeatDelay(this.invoDelay, this.delayedStart).setAttenuation(this.f_119580_).setGlobal(this.f_119582_);
    }

    public InvoSound setPreModifySound(IModifySound newModifier) {
        this.preModifySound = newModifier;
        return this;
    }

    public InvoSound setVolume(float volume) {
        this.f_119573_ = volume;
        return this;
    }

    public InvoSound setPitch(float pitch) {
        this.f_119574_ = pitch;
        return this;
    }

    public InvoSound setPos(Vector3d pos) {
        this.f_119575_ = pos.f_86214_;
        this.f_119576_ = pos.f_86215_;
        this.f_119577_ = pos.f_86216_;
        return this;
    }

    public InvoSound setRepeatDelay(int delayInTicks, boolean delayedStart) {
        this.invoDelay = delayInTicks;
        this.delayedStart = delayedStart;
        return this;
    }

    public InvoSound setAttenuation(SoundInstance.Attenuation type) {
        this.f_119580_ = type;
        return this;
    }

    public InvoSound setGlobal(boolean relative) {
        this.f_119582_ = relative;
        return this;
    }

    public void playWhenStopped() {
        if (this.isDonePlaying()) {
            this.play();
        }
    }

    public void play() {
        if (this.startTick == 0L) {
            this.startTick = this.currentTime();
        }
        if (this.startTick > -1L && this.currentTime() < this.startTick + (long)this.invoDelay) {
            return;
        }
        this.stopIt();
        this.startTick = 0L;
        if (this.preModifySound != null) {
            this.preModifySound.modify(this);
        }
        InvoSound.getSoundHandler().m_120367_((SoundInstance)this);
    }

    private long currentTime() {
        if (this.savedWorld != ClientUtil.getWorld()) {
            this.savedWorld = ClientUtil.getWorld();
            this.stopIt();
        }
        return this.savedWorld.m_46467_();
    }

    public void stopIt() {
        InvoSound.getSoundHandler().m_120399_((SoundInstance)this);
        this.startTick = this.delayedStart ? 0L : -1L;
    }

    @FunctionalInterface
    public static interface IModifySound {
        public void modify(InvoSound var1);
    }
}

