/*
 * Decompiled with CFR 0.152.
 */
package invoker54.invocore.client;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Matrix4f;
import invoker54.invocore.client.ClientUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextUtil {
    private static int black = new Color(0, 0, 0, 255).getRGB();
    private static final Logger LOGGER = LogManager.getLogger();

    public static void renderText(PoseStack stack, MutableComponent text, boolean shadow, float x0, float maxWidth, float y0, float maxHeight, int padding, txtAlignment align) {
        TextUtil.renderText(stack, text, 0, shadow, x0, maxWidth, y0, maxHeight, padding, align);
    }

    public static void renderText(PoseStack stack, MutableComponent text, int maxSplits, boolean shadow, float x0, float maxWidth, float y0, float maxHeight, int padding, txtAlignment align) {
        ArrayList<FormattedText> list = new ArrayList<FormattedText>();
        if ((float)ClientUtil.mC.f_91062_.m_92852_((FormattedText)text) > maxWidth) {
            double spaceRatio = maxWidth / maxHeight;
            double textArea = 9 * ClientUtil.mC.f_91062_.m_92852_((FormattedText)text);
            double multiplier = textArea / ((spaceRatio *= 9.0) * 9.0);
            multiplier = Math.sqrt(multiplier);
            int cutoffPoint = (int)Math.round(multiplier * spaceRatio);
            list.addAll(ClientUtil.mC.f_91062_.m_92865_().m_92414_((FormattedText)text, cutoffPoint, Style.f_131099_));
            if (maxSplits != 0 && list.size() > maxSplits) {
                list.clear();
                list.addAll(ClientUtil.mC.f_91062_.m_92865_().m_92414_((FormattedText)text, (int)Math.ceil((double)ClientUtil.mC.f_91062_.m_92852_((FormattedText)text) / (double)maxSplits), Style.f_131099_));
                if (list.size() > maxSplits) {
                    FormattedText part1 = (FormattedText)list.get(list.size() - 2);
                    FormattedText part2 = (FormattedText)list.get(list.size() - 1);
                    list.remove(part1);
                    list.remove(part2);
                    list.add(FormattedText.m_130773_((FormattedText[])new FormattedText[]{part1, FormattedText.m_130775_((String)" "), part2}));
                }
            }
        } else {
            list.add((FormattedText)text);
        }
        TextUtil.renderText(stack, list, shadow, x0, maxWidth, y0, maxHeight, padding, align);
    }

    public static void renderText(PoseStack stack, List<FormattedText> textLines, boolean shadow, float x0, float maxWidth, float y0, float maxHeight, int padding, txtAlignment align) {
        Font font = ClientUtil.mC.f_91062_;
        stack.m_85836_();
        float maxTxtHeight = textLines.size() * 8;
        maxTxtHeight += (float)(-2 + textLines.size());
        float maxTxtWidth = 0.0f;
        FormattedText largestComponent = textLines.get(0);
        for (FormattedText textComponent : textLines) {
            int currentWidth = font.m_92852_(textComponent);
            if (!((float)currentWidth > maxTxtWidth)) continue;
            maxTxtWidth = currentWidth;
            largestComponent = textComponent;
        }
        maxTxtWidth -= 1.0f;
        float shadowOffset = 0.0f;
        if (shadow) {
            shadowOffset = 1.0f;
            maxTxtHeight += shadowOffset;
            maxTxtWidth += shadowOffset;
        }
        float heightFillAmount = maxHeight / maxTxtHeight;
        float widthFillAmount = maxWidth / maxTxtWidth;
        float scaleFactor = 0.0f;
        if (heightFillAmount < widthFillAmount || heightFillAmount == widthFillAmount) {
            scaleFactor = (maxHeight - (float)(align == txtAlignment.MIDDLE ? padding * 2 : padding)) / maxTxtHeight;
        } else if (heightFillAmount > widthFillAmount) {
            scaleFactor = (maxWidth - (float)(align == txtAlignment.MIDDLE ? padding * 2 : padding)) / maxTxtWidth;
        }
        stack.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        for (int a = 0; a < textLines.size(); ++a) {
            FormattedText currText = textLines.get(a);
            float y = y0 / scaleFactor;
            float f = (maxHeight - maxTxtHeight * scaleFactor) / 2.0f;
            Objects.requireNonNull(font);
            y += (f + (float)(a * 9) * scaleFactor) / scaleFactor;
            float x = x0;
            switch (align) {
                case LEFT: {
                    x /= scaleFactor;
                    break;
                }
                case MIDDLE: {
                    x = (x + (maxWidth - ((float)font.m_92852_(currText) - (1.0f - shadowOffset)) * scaleFactor) / 2.0f) / scaleFactor;
                    break;
                }
                case RIGHT: {
                    x = (x + maxWidth) / scaleFactor - ((float)padding + ((float)font.m_92852_(currText) - (1.0f - shadowOffset)) * scaleFactor) / scaleFactor;
                }
            }
            TextUtil.renderText(currText, stack, x, y, shadow);
        }
        stack.m_85849_();
    }

    public static void renderText(FormattedText text, PoseStack stack, float x, float y, boolean shadow) {
        MultiBufferSource.BufferSource irendertypebuffer$impl = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        int i = "deadmau5".equals(text.getString()) ? -10 : 0;
        Matrix4f matrix4f = stack.m_85850_().m_85861_();
        int lightCoords = 0xF000F0;
        boolean j = false;
        Font fontrenderer = ClientUtil.mC.f_91062_;
        fontrenderer.m_92733_(Language.m_128107_().m_5536_(text), x, y, -1, shadow, matrix4f, (MultiBufferSource)irendertypebuffer$impl, true, 0, lightCoords);
        irendertypebuffer$impl.m_109911_();
    }

    public static enum txtAlignment {
        LEFT,
        MIDDLE,
        RIGHT;

    }
}

