/*
 * Decompiled with CFR 0.152.
 */
package invoker54.invocore.common.timer;

import invoker54.invocore.common.timer.MiniTicker;
import invoker54.invocore.common.timer.ModTimer;
import java.util.ArrayList;
import java.util.List;

public class ModStopWatch
extends ModTimer {
    private double bestTime = 0.0;
    private final Time time;
    private final List<Double> times;

    public static ModStopWatch getTimer(String modID, String name, Time time) {
        String fullName = modID + name + "watch";
        if (!timerMap.containsKey(fullName)) {
            timerMap.put(fullName, new ModStopWatch(time));
        }
        return (ModStopWatch)timerMap.get(fullName);
    }

    protected ModStopWatch(Time time) {
        this.time = time;
        this.times = new ArrayList<Double>();
    }

    @Override
    public String record(MiniTicker<?> ticker, String whatItsFor) {
        double timeElapsed = ticker.getElapsedTime().longValue();
        if (this.time == Time.LONGEST && timeElapsed > this.bestTime) {
            super.record(ticker, whatItsFor);
            this.bestTime = timeElapsed;
            this.times.add(timeElapsed);
        } else if (this.time == Time.SHORTEST && timeElapsed < this.bestTime) {
            super.record(ticker, whatItsFor);
            this.bestTime = timeElapsed;
            this.times.add(timeElapsed);
        } else if (this.time == Time.ACCUMULATE) {
            super.record(ticker, whatItsFor);
            this.times.add(timeElapsed);
        }
        return "";
    }

    public String bestTime() {
        if (this.allTimes.isEmpty()) {
            return "";
        }
        return (String)this.allTimes.get(this.allTimes.size() - 1);
    }

    public String compileTime(String whatItsFor, boolean average, boolean clear) {
        long sum = 0L;
        for (Double number : this.times) {
            sum = (long)((double)sum + number);
        }
        if (average) {
            sum /= (long)this.times.size();
        }
        String timeElapsed = "" + (double)sum / 1.0E9;
        String timeString = "It took " + timeElapsed + " seconds: " + whatItsFor;
        if (clear) {
            this.times.clear();
        }
        return timeString;
    }

    public static enum Time {
        SHORTEST,
        LONGEST,
        ACCUMULATE;

    }
}

