/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.nolittering;

import java.util.Optional;
import net.blay09.mods.balm.api.config.BalmConfig;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.module.BalmModule;
import net.blay09.mods.nolittering.NoLitteringConfig;
import net.blay09.mods.nolittering.mixin.ServerPlayerGameModeAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeafLitterBlock;
import net.minecraft.world.level.block.SegmentableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;

public class NoLittering
implements BalmModule {
    public static final String MOD_ID = "nolittering";
    private static final RandomSource random = RandomSource.create();

    private static void trySpawnLitterAround(ServerLevel level, BlockPos pos) {
        int range = 2;
        int offsetX = random.nextInt(5) - 2;
        int offsetZ = random.nextInt(5) - 2;
        BlockPos offsetPos = pos.offset(offsetX, 0, offsetZ);
        NoLittering.findLocalGroundForLitter((Level)level, offsetPos).ifPresent(groundPos -> NoLittering.getRandomLeafLitter((Level)level, groundPos).ifPresent(leafLitter -> {
            level.sendParticles((ParticleOptions)ParticleTypes.POOF, (double)((float)groundPos.getX() + 0.5f), (double)((float)groundPos.getY() + 0.5f), (double)((float)groundPos.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
            level.setBlockAndUpdate(groundPos, leafLitter);
        }));
    }

    private static Optional<BlockState> getRandomLeafLitter(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.is(Blocks.LEAF_LITTER)) {
            int count = (Integer)state.getValue((Property)SegmentableBlock.AMOUNT);
            if (count < 4) {
                return Optional.of((BlockState)state.setValue((Property)SegmentableBlock.AMOUNT, (Comparable)Integer.valueOf(count + 1)));
            }
            return Optional.empty();
        }
        if (state.isAir()) {
            Direction facing = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            return Optional.of((BlockState)Blocks.LEAF_LITTER.defaultBlockState().setValue((Property)LeafLitterBlock.FACING, (Comparable)facing));
        }
        return Optional.empty();
    }

    private static Optional<BlockPos> findLocalGroundForLitter(Level level, BlockPos pos) {
        BlockPos heightmapPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos);
        int verticalRange = 5;
        if (Math.abs(heightmapPos.getY() - pos.getY()) < 5) {
            return Optional.of(heightmapPos);
        }
        BlockPos.MutableBlockPos currentPos = pos.mutable();
        BlockState currentState = level.getBlockState((BlockPos)currentPos);
        if (currentState.is(Blocks.LEAF_LITTER)) {
            return Optional.of(currentPos);
        }
        BlockPos.MutableBlockPos belowPos = currentPos.mutable().setY(currentPos.getY() - 1);
        BlockState belowState = level.getBlockState((BlockPos)belowPos);
        if (currentState.isAir()) {
            if (belowState.isFaceSturdy((BlockGetter)level, (BlockPos)belowPos, Direction.UP)) {
                return Optional.of(currentPos);
            }
            for (int i = 0; i < 5; ++i) {
                currentPos.setY(currentPos.getY() - 1);
                currentState = level.getBlockState((BlockPos)currentPos);
                if (currentState.is(Blocks.LEAF_LITTER)) {
                    return Optional.of(currentPos);
                }
                if (!currentState.isAir()) {
                    return Optional.empty();
                }
                belowPos.setY(currentPos.getY() - 1);
                belowState = level.getBlockState((BlockPos)belowPos);
                if (!belowState.isFaceSturdy((BlockGetter)level, (BlockPos)belowPos, Direction.UP)) continue;
                return Optional.of(currentPos);
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                currentPos.setY(currentPos.getY() + 1);
                currentState = level.getBlockState((BlockPos)currentPos);
                if (currentState.is(Blocks.LEAF_LITTER)) {
                    return Optional.of(currentPos);
                }
                if (!currentState.isAir()) continue;
                belowPos.setY(currentPos.getY() - 1);
                belowState = level.getBlockState((BlockPos)belowPos);
                if (belowState.isFaceSturdy((BlockGetter)level, (BlockPos)belowPos, Direction.UP)) {
                    return Optional.of(currentPos);
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private static boolean isTree(Level level, BlockPos pos) {
        BlockState rootState = level.getBlockState(pos);
        if (!rootState.is(BlockTags.LOGS)) {
            return false;
        }
        BlockPos current = pos.above();
        while (level.isInsideBuildHeight(current.getY())) {
            BlockState state = level.getBlockState(current);
            if (state.is(BlockTags.LEAVES)) {
                return true;
            }
            if (!state.is(BlockTags.LOGS)) {
                return false;
            }
            current = current.above();
        }
        return false;
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"common");
    }

    public void registerConfig(BalmConfig config) {
        config.registerConfig(NoLitteringConfig.class);
    }

    public void registerEvents(BalmEvents events) {
        events.onTickEvent(TickType.ServerPlayer, TickPhase.Start, player -> {
            ServerPlayerGameModeAccessor accessor;
            ServerPlayerGameMode patt0$temp;
            if (NoLitteringConfig.getActive().punchingTreesCreatesLitter && (patt0$temp = player.gameMode) instanceof ServerPlayerGameModeAccessor && (accessor = (ServerPlayerGameModeAccessor)patt0$temp).getIsDestroyingBlock()) {
                ServerLevel level = player.level();
                BlockPos pos = accessor.getDestroyPos();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = level;
                    if (NoLittering.isTree((Level)level, pos)) {
                        float chancePerSecond = NoLitteringConfig.getActive().punchingLitterChance;
                        float chancePerTick = chancePerSecond / 20.0f;
                        if (random.nextFloat() < chancePerTick) {
                            NoLittering.trySpawnLitterAround(serverLevel, pos);
                        }
                    }
                }
            }
        });
    }
}

