/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.nolittering.mixin;

import java.util.List;
import net.blay09.mods.nolittering.NoLitteringConfig;
import net.blay09.mods.nolittering.mixin.WeightedStateProviderAccessor;
import net.minecraft.util.random.Weighted;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.PlaceOnGroundDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlaceOnGroundDecorator.class})
public class PlaceOnGroundDecoratorMixin {
    @Shadow
    @Final
    private BlockStateProvider blockStateProvider;

    @Inject(method={"place"}, at={@At(value="HEAD")}, cancellable=true)
    public void place(TreeDecorator.Context context, CallbackInfo ci) {
        if (!NoLitteringConfig.getActive().disableLitterInWorldGeneration) {
            return;
        }
        BlockStateProvider blockStateProvider = this.blockStateProvider;
        if (blockStateProvider instanceof WeightedStateProviderAccessor) {
            WeightedStateProviderAccessor weightedStateProvider = (WeightedStateProviderAccessor)blockStateProvider;
            List weightedStates = weightedStateProvider.getWeightedList().unwrap();
            for (Weighted weightedState : weightedStates) {
                if (!((BlockState)weightedState.value()).is(Blocks.LEAF_LITTER)) continue;
                ci.cancel();
                return;
            }
        }
    }
}

