/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.nolittering.mixin;

import java.util.List;
import net.blay09.mods.nolittering.NoLitteringConfig;
import net.blay09.mods.nolittering.mixin.WeightedStateProviderAccessor;
import net.minecraft.util.random.Weighted;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.RandomPatchFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RandomPatchFeature.class})
public class RandomPatchFeatureMixin {
    @Inject(method={"place(Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void place(FeaturePlaceContext<RandomPatchConfiguration> context, CallbackInfoReturnable<Boolean> cir) {
        SimpleBlockConfiguration simpleBlockConfig;
        BlockStateProvider blockStateProvider;
        if (!NoLitteringConfig.getActive().disableLitterInWorldGeneration) {
            return;
        }
        PlacedFeature randomPatchFeature = (PlacedFeature)((RandomPatchConfiguration)context.config()).feature().value();
        ConfiguredFeature innerFeature = (ConfiguredFeature)randomPatchFeature.feature().value();
        FeatureConfiguration innerFeatureConfig = innerFeature.config();
        if (innerFeatureConfig instanceof SimpleBlockConfiguration && (blockStateProvider = (simpleBlockConfig = (SimpleBlockConfiguration)innerFeatureConfig).toPlace()) instanceof WeightedStateProviderAccessor) {
            WeightedStateProviderAccessor weightedStateProvider = (WeightedStateProviderAccessor)blockStateProvider;
            List weightedStates = weightedStateProvider.getWeightedList().unwrap();
            for (Weighted weightedState : weightedStates) {
                if (!((BlockState)weightedState.value()).is(Blocks.LEAF_LITTER)) continue;
                cir.setReturnValue((Object)false);
                return;
            }
        }
    }
}

