/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.nolittering;

import java.util.Optional;
import net.blay09.mods.balm.api.config.BalmConfig;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.module.BalmModule;
import net.blay09.mods.nolittering.NoLitteringConfig;
import net.blay09.mods.nolittering.mixin.ServerPlayerGameModeAccessor;
import net.minecraft.class_10595;
import net.minecraft.class_10596;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3225;
import net.minecraft.class_3481;
import net.minecraft.class_5819;

public class NoLittering
implements BalmModule {
    public static final String MOD_ID = "nolittering";
    private static final class_5819 random = class_5819.method_43047();

    private static void trySpawnLitterAround(class_3218 level, class_2338 pos) {
        int range = 2;
        int offsetX = random.method_43048(5) - 2;
        int offsetZ = random.method_43048(5) - 2;
        class_2338 offsetPos = pos.method_10069(offsetX, 0, offsetZ);
        NoLittering.findLocalGroundForLitter((class_1937)level, offsetPos).ifPresent(groundPos -> NoLittering.getRandomLeafLitter((class_1937)level, groundPos).ifPresent(leafLitter -> {
            level.method_65096((class_2394)class_2398.field_11203, (double)((float)groundPos.method_10263() + 0.5f), (double)((float)groundPos.method_10264() + 0.5f), (double)((float)groundPos.method_10260() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
            level.method_8501(groundPos, leafLitter);
        }));
    }

    private static Optional<class_2680> getRandomLeafLitter(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        if (state.method_27852(class_2246.field_55742)) {
            int count = (Integer)state.method_11654((class_2769)class_10596.field_55791);
            if (count < 4) {
                return Optional.of((class_2680)state.method_11657((class_2769)class_10596.field_55791, (Comparable)Integer.valueOf(count + 1)));
            }
            return Optional.empty();
        }
        if (state.method_26215()) {
            class_2350 facing = class_2350.class_2353.field_11062.method_10183(random);
            return Optional.of((class_2680)class_2246.field_55742.method_9564().method_11657((class_2769)class_10595.field_55770, (Comparable)facing));
        }
        return Optional.empty();
    }

    private static Optional<class_2338> findLocalGroundForLitter(class_1937 level, class_2338 pos) {
        class_2338 heightmapPos = level.method_8598(class_2902.class_2903.field_13203, pos);
        int verticalRange = 5;
        if (Math.abs(heightmapPos.method_10264() - pos.method_10264()) < 5) {
            return Optional.of(heightmapPos);
        }
        class_2338.class_2339 currentPos = pos.method_25503();
        class_2680 currentState = level.method_8320((class_2338)currentPos);
        if (currentState.method_27852(class_2246.field_55742)) {
            return Optional.of(currentPos);
        }
        class_2338.class_2339 belowPos = currentPos.method_25503().method_33098(currentPos.method_10264() - 1);
        class_2680 belowState = level.method_8320((class_2338)belowPos);
        if (currentState.method_26215()) {
            if (belowState.method_26206((class_1922)level, (class_2338)belowPos, class_2350.field_11036)) {
                return Optional.of(currentPos);
            }
            for (int i = 0; i < 5; ++i) {
                currentPos.method_33098(currentPos.method_10264() - 1);
                currentState = level.method_8320((class_2338)currentPos);
                if (currentState.method_27852(class_2246.field_55742)) {
                    return Optional.of(currentPos);
                }
                if (!currentState.method_26215()) {
                    return Optional.empty();
                }
                belowPos.method_33098(currentPos.method_10264() - 1);
                belowState = level.method_8320((class_2338)belowPos);
                if (!belowState.method_26206((class_1922)level, (class_2338)belowPos, class_2350.field_11036)) continue;
                return Optional.of(currentPos);
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                currentPos.method_33098(currentPos.method_10264() + 1);
                currentState = level.method_8320((class_2338)currentPos);
                if (currentState.method_27852(class_2246.field_55742)) {
                    return Optional.of(currentPos);
                }
                if (!currentState.method_26215()) continue;
                belowPos.method_33098(currentPos.method_10264() - 1);
                belowState = level.method_8320((class_2338)belowPos);
                if (belowState.method_26206((class_1922)level, (class_2338)belowPos, class_2350.field_11036)) {
                    return Optional.of(currentPos);
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private static boolean isTree(class_1937 level, class_2338 pos) {
        class_2680 rootState = level.method_8320(pos);
        if (!rootState.method_26164(class_3481.field_15475)) {
            return false;
        }
        class_2338 current = pos.method_10084();
        while (level.method_62871(current.method_10264())) {
            class_2680 state = level.method_8320(current);
            if (state.method_26164(class_3481.field_15503)) {
                return true;
            }
            if (!state.method_26164(class_3481.field_15475)) {
                return false;
            }
            current = current.method_10084();
        }
        return false;
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public class_2960 getId() {
        return class_2960.method_60655((String)MOD_ID, (String)"common");
    }

    public void registerConfig(BalmConfig config) {
        config.registerConfig(NoLitteringConfig.class);
    }

    public void registerEvents(BalmEvents events) {
        events.onTickEvent(TickType.ServerPlayer, TickPhase.Start, player -> {
            ServerPlayerGameModeAccessor accessor;
            class_3225 patt0$temp;
            if (NoLitteringConfig.getActive().punchingTreesCreatesLitter && (patt0$temp = player.field_13974) instanceof ServerPlayerGameModeAccessor && (accessor = (ServerPlayerGameModeAccessor)patt0$temp).getIsDestroyingBlock()) {
                class_3218 level = player.method_51469();
                class_2338 pos = accessor.getDestroyPos();
                if (level instanceof class_3218) {
                    class_3218 serverLevel = level;
                    if (NoLittering.isTree((class_1937)level, pos)) {
                        float chancePerSecond = NoLitteringConfig.getActive().punchingLitterChance;
                        float chancePerTick = chancePerSecond / 20.0f;
                        if (random.method_43057() < chancePerTick) {
                            NoLittering.trySpawnLitterAround(serverLevel, pos);
                        }
                    }
                }
            }
        });
    }
}

