/*
 * Decompiled with CFR 0.152.
 */
package me.seyviyer.xphearts.listeners;

import me.seyviyer.xphearts.XPHearts;
import org.bukkit.ChatColor;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class XPHLevel
implements Listener {
    private XPHearts plugin;

    public XPHLevel(XPHearts plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerXPLevelChange(PlayerExpChangeEvent event) {
        this.updatePlayerMaxHealth(event.getPlayer());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.updatePlayerMaxHealth(event.getPlayer());
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        this.updatePlayerMaxHealth(event.getPlayer());
    }

    public void updatePlayerMaxHealth(final Player player) {
        if (player.hasPermission("xphearts.use") || player.hasPermission("xpheart.use") || player.hasPermission("xh.use") || player.hasPermission("xph.use")) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    int playerLevel = player.getLevel();
                    double maxHealth = player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue();
                    for (int i = playerLevel; i >= 0; --i) {
                        if (!XPHLevel.this.plugin.getConfigManager().getPlayerMaxHealthMap().containsKey(playerLevel)) continue;
                        double newMaxHealth = (Double)XPHLevel.this.plugin.getConfigManager().getPlayerMaxHealthMap().get(i);
                        if (newMaxHealth == maxHealth) break;
                        player.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(newMaxHealth);
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)XPHLevel.this.plugin.getConfigManager().getUpdateHealthMessage()));
                        if (!XPHLevel.this.plugin.getConfigManager().healPlayerOnHealthUpdate()) break;
                        player.setHealth(newMaxHealth);
                        break;
                    }
                }
            }, 2L);
        }
    }
}

