/*
 * Decompiled with CFR 0.152.
 */
package me.seyviyer.xphearts.managers;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import me.seyviyer.xphearts.XPHearts;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class XPHConfigManager {
    private XPHearts plugin;
    private HashMap<Integer, Double> playerMaxHealthMap = new HashMap();
    private File configFile;
    private FileConfiguration configuration;

    public XPHConfigManager(XPHearts plugin) {
        this.plugin = plugin;
    }

    public HashMap getPlayerMaxHealthMap() {
        return this.playerMaxHealthMap;
    }

    public void loadConfiguration() {
        File resourceFile;
        File folder = this.plugin.getDataFolder();
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!(resourceFile = new File(folder, "config.yml")).exists()) {
            try {
                resourceFile.createNewFile();
                try (InputStream input = this.plugin.getResource("config.yml");){
                    FileOutputStream output = new FileOutputStream(resourceFile);
                    ByteStreams.copy((InputStream)input, (OutputStream)output);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.plugin.getServer().getLogger().severe("There is something wrong when making the configuration file!");
            }
        }
        this.configFile = resourceFile;
        this.configuration = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public FileConfiguration getConfiguration() {
        return this.configuration;
    }

    public void reloadConfiguration() {
        this.loadConfiguration();
        YamlConfiguration.loadConfiguration((File)this.configFile);
        this.playerMaxHealthMap.clear();
        try {
            for (String key : this.getConfiguration().getConfigurationSection("max-health-on-level").getKeys(false)) {
                this.getPlayerMaxHealthMap().put(Integer.parseInt(key), this.getConfiguration().getDouble("max-health-on-level." + key));
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            this.plugin.getServer().getLogger().severe("[XPHearts] There is a problem with your configuration file! You can revert back to the original configuration and try to modify it again.");
        }
    }

    public String getUpdateHealthMessage() {
        return this.getConfiguration().getString("max-health-update-message");
    }

    public boolean healPlayerOnHealthUpdate() {
        return this.getConfiguration().getBoolean("heal-on-health-update");
    }
}

