/*
 * Decompiled with CFR 0.152.
 */
package de.duckyruby.smanager;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Difficulty;
import org.bukkit.GameRule;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ServerManagerPlugin
extends JavaPlugin
implements Listener {
    private final Map<UUID, String> awaitingInput = new HashMap<UUID, String>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("ServerManager aktiviert!");
    }

    public void onDisable() {
        this.getLogger().info("ServerManager deaktiviert!");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cNur Spieler k\u00f6nnen diesen Befehl ausf\u00fchren.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("manager.admin")) {
            player.sendMessage("\u00a7cDazu hast du keine Berechtigung.");
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("smanager")) {
            this.openMainGUI(player);
            return true;
        }
        return false;
    }

    private void openMainGUI(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)9, (String)"\u00a76Server Manager");
        ItemStack pluginItem = this.getItemFromConfig("plugin_menu_item", "ENDER_EYE", "\u00a7bPlugins");
        ItemStack worldItem = this.getItemFromConfig("world_menu_item", "GRASS_BLOCK", "\u00a76Welten Manager");
        inv.setItem(3, pluginItem);
        inv.setItem(5, worldItem);
        player.openInventory(inv);
    }

    private void openPluginGUI(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)9, (String)"\u00a7bPlugin Verwaltung");
        ItemStack deleteItem = this.getItemFromConfig("plugin_delete_item", "GRASS_BLOCK", "\u00a7cPlugin L\u00f6schen");
        ItemStack reloadItem = this.getItemFromConfig("plugin_reload_item", "GRASS_BLOCK", "\u00a7aPlugins Reloaden");
        ItemStack toggleItem = this.getItemFromConfig("plugin_toggle_item", "NETHER_BRICKS", "\u00a7aPlugin Aktivieren/\u00a74Deaktivieren");
        inv.setItem(2, deleteItem);
        inv.setItem(4, reloadItem);
        inv.setItem(6, toggleItem);
        player.openInventory(inv);
    }

    private void openWorldGUI(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)"\u00a76Welten Manager");
        inv.setItem(10, this.createItem(Material.CLOCK, "\u00a7eTag"));
        inv.setItem(11, this.createItem(Material.CLOCK, "\u00a71Nacht"));
        inv.setItem(13, this.createItem(Material.LAVA_BUCKET, "\u00a7cWelt L\u00f6schen"));
        inv.setItem(14, this.createItem(Material.WATER_BUCKET, "\u00a7aWelt Reloaden"));
        inv.setItem(15, this.createItem(Material.GRASS_BLOCK, "\u00a7aWelt Erstellen"));
        inv.setItem(16, this.createItem(Material.GRASS_BLOCK, "\u00a7eWelten ansehen"));
        inv.setItem(17, this.createItem(Material.GRASS_BLOCK, "\u00a7dWelten Config"));
        player.openInventory(inv);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        Inventory inv = e.getInventory();
        String title = e.getView().getTitle();
        e.setCancelled(true);
        if (title.equals("\u00a76Server Manager")) {
            if (e.getCurrentItem() == null) {
                return;
            }
            String name = ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName());
            if (name.equalsIgnoreCase("Plugins")) {
                this.openPluginGUI(player);
            } else if (name.equalsIgnoreCase("Welten Manager")) {
                this.openWorldGUI(player);
            }
        } else if (title.equals("\u00a7bPlugin Verwaltung")) {
            if (e.getCurrentItem() == null) {
                return;
            }
            String name = ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName());
            if (name.equalsIgnoreCase("Plugin L\u00f6schen")) {
                player.closeInventory();
                this.awaitingInput.put(player.getUniqueId(), "delete_plugin");
                player.sendMessage("\u00a77Gib den Namen des Plugins ein, das du l\u00f6schen m\u00f6chtest:");
            } else if (name.equalsIgnoreCase("Plugins Reloaden")) {
                for (Plugin p : Bukkit.getPluginManager().getPlugins()) {
                    if (p.equals((Object)this)) continue;
                    Bukkit.getPluginManager().disablePlugin(p);
                    Bukkit.getPluginManager().enablePlugin(p);
                }
                player.sendMessage("\u00a7aAlle Plugins wurden neu geladen!");
            } else if (name.equalsIgnoreCase("Plugin Aktivieren/Deaktivieren")) {
                player.closeInventory();
                this.awaitingInput.put(player.getUniqueId(), "toggle_plugin");
                player.sendMessage("\u00a77Gib den Namen des Plugins ein, das du aktivieren/deaktivieren m\u00f6chtest:");
            }
        } else if (title.equals("\u00a76Welten Manager")) {
            if (e.getCurrentItem() == null) {
                return;
            }
            String name = ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName());
            switch (name.toLowerCase()) {
                case "tag": {
                    player.getWorld().setTime(1000L);
                    player.sendMessage("\u00a7eEs ist jetzt Tag in dieser Welt.");
                    break;
                }
                case "nacht": {
                    player.getWorld().setTime(18000L);
                    player.sendMessage("\u00a71Es ist jetzt Nacht in dieser Welt.");
                    break;
                }
                case "welt l\u00f6schen": {
                    player.closeInventory();
                    this.awaitingInput.put(player.getUniqueId(), "delete_world");
                    player.sendMessage("\u00a77Gib den Namen der Welt ein, die du l\u00f6schen m\u00f6chtest:");
                    break;
                }
                case "welt reloaden": {
                    player.getWorld().save();
                    player.sendMessage("\u00a7aDie aktuelle Welt wurde neu geladen.");
                    break;
                }
                case "welt erstellen": {
                    player.closeInventory();
                    this.awaitingInput.put(player.getUniqueId(), "create_world");
                    player.sendMessage("\u00a77Gib den Namen und die Schwierigkeit der Welt ein (z. B. Welt1 Normal):");
                    break;
                }
                case "welten ansehen": {
                    player.closeInventory();
                    player.sendMessage("\u00a7eWelten:");
                    for (World w : Bukkit.getWorlds()) {
                        player.sendMessage("\u00a77- " + w.getName());
                    }
                    break;
                }
                case "welten config": {
                    player.closeInventory();
                    this.awaitingInput.put(player.getUniqueId(), "config_world");
                    player.sendMessage("\u00a77Gib den Namen der Welt ein, die du konfigurieren m\u00f6chtest:");
                }
            }
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent e) {
        Player player = e.getPlayer();
        if (!this.awaitingInput.containsKey(player.getUniqueId())) {
            return;
        }
        e.setCancelled(true);
        String action = this.awaitingInput.remove(player.getUniqueId());
        String msg = e.getMessage();
        switch (action) {
            case "delete_plugin": {
                File pluginFile = new File("plugins", msg + ".jar");
                if (pluginFile.exists() && pluginFile.delete()) {
                    player.sendMessage("\u00a7cPlugin " + msg + " wurde gel\u00f6scht. Server wird neu gestartet...");
                    Bukkit.getScheduler().runTask((Plugin)this, Bukkit::shutdown);
                    break;
                }
                player.sendMessage("\u00a7cPlugin nicht gefunden!");
                break;
            }
            case "toggle_plugin": {
                Plugin target = Bukkit.getPluginManager().getPlugin(msg);
                if (target != null) {
                    if (target.isEnabled()) {
                        Bukkit.getPluginManager().disablePlugin(target);
                        player.sendMessage("\u00a74Plugin " + msg + " deaktiviert.");
                        break;
                    }
                    Bukkit.getPluginManager().enablePlugin(target);
                    player.sendMessage("\u00a7aPlugin " + msg + " aktiviert.");
                    break;
                }
                player.sendMessage("\u00a7cPlugin nicht gefunden!");
                break;
            }
            case "delete_world": {
                World world = Bukkit.getWorld((String)msg);
                if (world != null) {
                    Bukkit.unloadWorld((World)world, (boolean)false);
                    this.deleteWorldFolder(world.getWorldFolder());
                    player.sendMessage("\u00a7cWelt " + msg + " gel\u00f6scht!");
                    break;
                }
                player.sendMessage("\u00a7cWelt nicht gefunden!");
                break;
            }
            case "create_world": {
                String[] parts = msg.split(" ");
                if (parts.length < 2) {
                    player.sendMessage("\u00a7cBenutze: <Weltname> <Einfach|Normal|Schwer>");
                    return;
                }
                String name = parts[0];
                String diff = parts[1].toLowerCase();
                WorldCreator wc = new WorldCreator(name);
                World newWorld = wc.createWorld();
                switch (diff) {
                    case "einfach": {
                        newWorld.setDifficulty(Difficulty.EASY);
                        break;
                    }
                    case "normal": {
                        newWorld.setDifficulty(Difficulty.NORMAL);
                        break;
                    }
                    case "schwer": {
                        newWorld.setDifficulty(Difficulty.HARD);
                    }
                }
                player.sendMessage("\u00a7aWelt " + name + " erstellt mit Schwierigkeit " + diff + ".");
                break;
            }
            case "config_world": {
                World world = Bukkit.getWorld((String)msg);
                if (world == null) {
                    player.sendMessage("\u00a7cWelt nicht gefunden!");
                    return;
                }
                this.awaitingInput.put(player.getUniqueId(), "config_world_difficulty_" + msg);
                player.sendMessage("\u00a77Welche Schwierigkeit soll " + msg + " haben? (Einfach/Normal/Schwer)");
                break;
            }
            default: {
                if (action.startsWith("config_world_difficulty_")) {
                    Difficulty diff;
                    String worldName = action.replace("config_world_difficulty_", "");
                    World world = Bukkit.getWorld((String)worldName);
                    if (world == null) {
                        return;
                    }
                    switch (msg.toLowerCase()) {
                        case "einfach": {
                            Difficulty difficulty = Difficulty.EASY;
                            break;
                        }
                        case "normal": {
                            Difficulty difficulty = Difficulty.NORMAL;
                            break;
                        }
                        case "schwer": {
                            Difficulty difficulty = Difficulty.HARD;
                            break;
                        }
                        default: {
                            Difficulty difficulty = diff = null;
                        }
                    }
                    if (diff == null) {
                        player.sendMessage("\u00a7cUng\u00fcltige Schwierigkeit!");
                        return;
                    }
                    world.setDifficulty(diff);
                    player.sendMessage("\u00a7aSchwierigkeit f\u00fcr " + worldName + " gesetzt auf " + diff.name());
                    this.awaitingInput.put(player.getUniqueId(), "config_world_mobs_" + worldName);
                    player.sendMessage("\u00a77Sollen Mobs spawnen? (ja/nein)");
                    break;
                }
                if (!action.startsWith("config_world_mobs_")) break;
                String worldName = action.replace("config_world_mobs_", "");
                World world = Bukkit.getWorld((String)worldName);
                if (world == null) {
                    return;
                }
                boolean mobs = msg.equalsIgnoreCase("ja");
                world.setGameRule(GameRule.DO_MOB_SPAWNING, (Object)mobs);
                player.sendMessage("\u00a7aMob-Spawning f\u00fcr " + worldName + ": " + (mobs ? "aktiviert" : "deaktiviert"));
            }
        }
    }

    private void deleteWorldFolder(File file) {
        if (file.isDirectory()) {
            for (File f : Objects.requireNonNull(file.listFiles())) {
                this.deleteWorldFolder(f);
            }
        }
        file.delete();
    }

    private ItemStack createItem(Material mat, String name) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack getItemFromConfig(String path, String fallbackMaterial, String fallbackName) {
        String matName = this.getConfig().getString(path + ".material", fallbackMaterial);
        String display = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString(path + ".name", fallbackName));
        Material mat = Material.matchMaterial((String)matName.toUpperCase(Locale.ROOT));
        if (mat == null) {
            mat = Material.valueOf((String)fallbackMaterial);
        }
        return this.createItem(mat, display);
    }
}

