/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.fuelinfo.hook;

import java.util.ArrayList;
import java.util.List;
import me.luligabi.fuelinfo.FuelInfo;
import me.luligabi.fuelinfo.mixin.AbstractContainerScreenAccessor;
import me.luligabi.fuelinfo.mixin.AbstractFurnaceMenuAccessor;
import me.luligabi.fuelinfo.util.TimerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractFurnaceScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.AbstractFurnaceMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;

public class AbstractFurnaceMenuHook {
    private static final List<Component> COMPONENTS = new ArrayList<Component>();

    public static void render(AbstractFurnaceScreen<AbstractFurnaceMenu> screen, GuiGraphics gui, int mouseX, int mouseY) {
        AbstractFurnaceMenu menu = (AbstractFurnaceMenu)screen.getMenu();
        ContainerData data = ((AbstractFurnaceMenuAccessor)menu).getData();
        int x = ((AbstractContainerScreenAccessor)screen).getX();
        int y = ((AbstractContainerScreenAccessor)screen).getY();
        if (mouseX >= x + 56 && mouseX <= x + 72 && mouseY >= y + 35 && mouseY <= y + 50) {
            AbstractFurnaceMenuHook.addFuelData(menu, data, FuelInfo.CONFIG.furnace.flame.showFuelData);
            AbstractFurnaceMenuHook.addTimer(menu, data, FuelInfo.CONFIG.furnace.flame.showTimer);
            if (!COMPONENTS.isEmpty()) {
                gui.setComponentTooltipForNextFrame(Minecraft.getInstance().font, COMPONENTS, mouseX, mouseY);
                COMPONENTS.clear();
            }
        }
        if (mouseX >= x + 80 && mouseX <= x + 102 && mouseY >= y + 35 && mouseY <= y + 50) {
            AbstractFurnaceMenuHook.addFuelData(menu, data, FuelInfo.CONFIG.furnace.progressArrow.showFuelData);
            AbstractFurnaceMenuHook.addTimer(menu, data, FuelInfo.CONFIG.furnace.progressArrow.showTimer);
            if (!COMPONENTS.isEmpty()) {
                gui.setComponentTooltipForNextFrame(Minecraft.getInstance().font, COMPONENTS, mouseX, mouseY);
                COMPONENTS.clear();
            }
        }
    }

    private static void addFuelData(AbstractFurnaceMenu menu, ContainerData data, boolean canAdd) {
        MutableComponent fuelText;
        if (!canAdd) {
            return;
        }
        int consumedFuelTicks = data.get(0);
        if (menu.isLit()) {
            consumedFuelTicks += AbstractFurnaceMenuHook.isSpecialFurnace(menu) ? 100 : 200;
        }
        int toBeConsumedFuelTicks = 0;
        ItemStack fuelStack = menu.getSlot(1).getItem();
        consumedFuelTicks = AbstractFurnaceMenuHook.isSpecialFurnace(menu) ? (consumedFuelTicks /= 100) : (consumedFuelTicks /= 200);
        int i = consumedFuelTicks + (toBeConsumedFuelTicks += Minecraft.getInstance().level.fuelValues().burnDuration(fuelStack) * fuelStack.getCount()) / 200;
        if (i <= 0) {
            return;
        }
        if (!Minecraft.getInstance().hasShiftDown()) {
            int stacks = i / 64;
            int items = i % 64;
            fuelText = stacks > 0 ? (items > 0 ? Component.translatable((String)"message.fuelinfo.furnace.both", (Object[])new Object[]{stacks, items}) : Component.translatable((String)"message.fuelinfo.furnace.stacks", (Object[])new Object[]{stacks})) : Component.translatable((String)"message.fuelinfo.furnace.items", (Object[])new Object[]{items});
        } else {
            fuelText = Component.translatable((String)"message.fuelinfo.furnace.items", (Object[])new Object[]{i});
        }
        COMPONENTS.add((Component)fuelText);
    }

    private static void addTimer(AbstractFurnaceMenu menu, ContainerData data, boolean canAdd) {
        if (!canAdd) {
            return;
        }
        ItemStack inputStack = menu.getSlot(0).getItem();
        if (inputStack.isEmpty()) {
            return;
        }
        float tickrate = ((AbstractFurnaceMenuAccessor)menu).getLevel().tickRateManager().tickrate();
        float currentStackTime = data.get(3) - data.get(2);
        float remainingStacksTime = data.get(3) * (inputStack.getCount() - 1);
        int time = Math.round((currentStackTime + remainingStacksTime) / tickrate);
        boolean isIndividualTime = Minecraft.getInstance().hasShiftDown();
        Tuple<String, String> timePair = TimerUtil.getTime(isIndividualTime ? Math.round(currentStackTime / tickrate) : time);
        MutableComponent timeText = Component.translatable((String)("message.fuelinfo.timer" + (isIndividualTime ? ".current" : "")), (Object[])new Object[]{timePair.getA(), timePair.getB()});
        COMPONENTS.add((Component)timeText);
    }

    private static boolean isSpecialFurnace(AbstractFurnaceMenu menu) {
        return ((AbstractFurnaceMenuAccessor)menu).getRecipeType() != RecipeType.SMELTING;
    }
}

