/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.fuelinfo.hook;

import java.util.ArrayList;
import java.util.List;
import me.luligabi.fuelinfo.FuelInfo;
import me.luligabi.fuelinfo.mixin.AbstractContainerScreenAccessor;
import me.luligabi.fuelinfo.util.TimerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.level.Level;

public class BrewingStandScreenHook {
    private static final List<Component> COMPONENTS = new ArrayList<Component>();

    public static void render(BrewingStandScreen screen, GuiGraphics gui, int mouseX, int mouseY, Level level) {
        BrewingStandMenu menu = (BrewingStandMenu)screen.getMenu();
        int x = ((AbstractContainerScreenAccessor)screen).getX();
        int y = ((AbstractContainerScreenAccessor)screen).getY();
        if (mouseX >= x + 58 && mouseX <= x + 78 && mouseY >= y + 42 && mouseY <= y + 48) {
            BrewingStandScreenHook.addFuelData(menu, FuelInfo.CONFIG.brewingStand.gauge.showFuelData);
            BrewingStandScreenHook.addTimer(menu, level, FuelInfo.CONFIG.brewingStand.gauge.showTimer);
            if (!COMPONENTS.isEmpty()) {
                gui.setComponentTooltipForNextFrame(Minecraft.getInstance().font, COMPONENTS, mouseX, mouseY);
                COMPONENTS.clear();
            }
        }
        if (mouseX >= x + 98 && mouseX <= x + 104 && mouseY >= y + 17 && mouseY <= y + 42) {
            BrewingStandScreenHook.addFuelData(menu, FuelInfo.CONFIG.brewingStand.progressArrow.showFuelData);
            BrewingStandScreenHook.addTimer(menu, level, FuelInfo.CONFIG.brewingStand.progressArrow.showTimer);
            if (!COMPONENTS.isEmpty()) {
                gui.setComponentTooltipForNextFrame(Minecraft.getInstance().font, COMPONENTS, mouseX, mouseY);
                COMPONENTS.clear();
            }
        }
    }

    private static void addFuelData(BrewingStandMenu menu, boolean canAdd) {
        if (!canAdd) {
            return;
        }
        int potionCount = menu.getFuel() * 3 + menu.getSlot(4).getItem().getCount() * 20 * 3;
        if (potionCount <= 0) {
            return;
        }
        MutableComponent countText = Minecraft.getInstance().hasShiftDown() ? Component.translatable((String)"message.fuelinfo.brewing_stand.set", (Object[])new Object[]{potionCount / 3}) : Component.translatable((String)"message.fuelinfo.brewing_stand", (Object[])new Object[]{potionCount});
        COMPONENTS.add((Component)countText);
    }

    private static void addTimer(BrewingStandMenu menu, Level level, boolean canAdd) {
        if (!canAdd) {
            return;
        }
        int time = Math.round((float)menu.getBrewingTicks() / level.tickRateManager().tickrate());
        if (time <= 0) {
            return;
        }
        MutableComponent timeText = Component.translatable((String)"message.fuelinfo.timer", (Object[])new Object[]{"00", TimerUtil.format(time)});
        COMPONENTS.add((Component)timeText);
    }
}

