/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.scpslmod.item;

import net.mcreator.scpslmod.procedures.MicroHIDItemInInventoryTickProcedure;
import net.mcreator.scpslmod.procedures.MicroHIDItemIsDroppedByPlayerProcedure;
import net.mcreator.scpslmod.procedures.MicroHIDOnPlayerStoppedUsingProcedure;
import net.mcreator.scpslmod.procedures.MicroHIDPlayerFinishesUsingItemProcedure;
import net.mcreator.scpslmod.procedures.MicroHIDRightclickedProcedure;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class MicroHIDItem
extends Item {
    public MicroHIDItem() {
        super(new Item.Properties().durability(200).rarity(Rarity.EPIC));
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 120;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        MicroHIDRightclickedProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, (ItemStack)ar.getObject());
        return ar;
    }

    public ItemStack finishUsingItem(ItemStack itemstack, Level world, LivingEntity entity) {
        ItemStack retval = super.finishUsingItem(itemstack, world, entity);
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        MicroHIDPlayerFinishesUsingItemProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, itemstack);
        return retval;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            MicroHIDItemInInventoryTickProcedure.execute((LevelAccessor)world, entity, itemstack);
        }
        MicroHIDItemInInventoryTickProcedure.execute((LevelAccessor)world, entity, itemstack);
    }

    public boolean onDroppedByPlayer(ItemStack itemstack, Player entity) {
        MicroHIDItemIsDroppedByPlayerProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ());
        return true;
    }

    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        MicroHIDOnPlayerStoppedUsingProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, itemstack);
    }
}

