/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat;

import io.itamio.antiweakchat.config.ConfigManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="antiweakchat")
public class AntiWeakChatMod {
    public static final String MODID = "antiweakchat";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"antiweakchat");

    public AntiWeakChatMod() {
        LOGGER.info("AntiWeakChat mod constructed");
        this.printLaunchBanner();
        ConfigManager.loadConfig();
    }

    private void printLaunchBanner() {
        String title = "AntiWeakChat";
        String author = "Author: itamio";
        int innerWidth = Math.max(title.length(), author.length());
        String border = "+" + "-".repeat(innerWidth + 2) + "+";
        String line1 = "| " + AntiWeakChatMod.padRight(title, innerWidth) + " |";
        String line2 = "| " + AntiWeakChatMod.padRight(author, innerWidth) + " |";
        LOGGER.info(border);
        LOGGER.info(line1);
        LOGGER.info(line2);
        LOGGER.info(border);
    }

    private static String padRight(String s, int n) {
        if (s == null) {
            s = "";
        }
        if (s.length() >= n) {
            return s;
        }
        return s + " ".repeat(n - s.length());
    }

    @Mod.EventBusSubscriber(modid="antiweakchat", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLCommonSetupEvent event) {
            LOGGER.info("AntiWeakChat client initialized");
        }
    }
}

