/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Config {
    public String playerNameDetectionMethod = "PLAYERNAME";
    public boolean selfColourEnabled = true;
    public int selfColour = 0xFF00FF;
    public boolean friendColourEnabled = true;
    public Map<String, FriendConfig> friends = new HashMap<String, FriendConfig>();
    public boolean baseColourEnabled = false;
    public int baseColour = 0xFFFFFF;
    public int openKey = 344;
    public boolean ignoreEnabled = true;
    public String ignoreMode = "whitelist";
    public List<String> ignoreList = new ArrayList<String>();
    public boolean ignoreExceptionsEnabled = true;
    public boolean ignoreSelfFrontCheck = true;
    public boolean ignoreFriendsFrontCheck = true;
    public boolean selfEncryptionEnabled = false;
    public int lastConfigScroll = 0;
    public String selfSecret = "itamioisbest123";
    public boolean selfDecryptionEnabled = true;
    public boolean friendDecryptionEnabled = true;
    public Map<String, String> friendSecrets = new HashMap<String, String>();

    public void addFriend(String name, int colour) {
        this.friends.put(name, new FriendConfig(name, colour));
    }

    public void removeFriend(String name) {
        this.friends.remove(name);
    }

    public void updateFriend(String oldName, String newName, int colour) {
        if (!oldName.equals(newName)) {
            this.friends.remove(oldName);
        }
        this.friends.put(newName, new FriendConfig(newName, colour));
    }

    public void addFriendSecret(String name, String secret) {
        if (name == null) {
            return;
        }
        String t = name.trim();
        if (t.isEmpty()) {
            return;
        }
        this.friendSecrets.put(t, secret == null ? "" : secret);
    }

    public void removeFriendSecret(String name) {
        if (name == null) {
            return;
        }
        this.friendSecrets.remove(name);
    }

    public void updateFriendSecret(String oldName, String newName, String secret) {
        if (oldName == null || newName == null) {
            return;
        }
        if (!oldName.equals(newName)) {
            this.friendSecrets.remove(oldName);
        }
        this.friendSecrets.put(newName, secret == null ? "" : secret);
    }

    public void addIgnore(String name) {
        if (name == null) {
            return;
        }
        String t = name.trim();
        if (t.isEmpty()) {
            return;
        }
        if (!this.ignoreList.contains(t)) {
            this.ignoreList.add(t);
        }
    }

    public void removeIgnore(String name) {
        if (name == null) {
            return;
        }
        this.ignoreList.remove(name);
    }

    public void updateIgnore(String oldName, String newName) {
        if (oldName == null || newName == null) {
            return;
        }
        int idx = this.ignoreList.indexOf(oldName);
        if (idx >= 0) {
            this.ignoreList.set(idx, newName);
        } else {
            this.addIgnore(newName);
        }
    }

    public static class FriendConfig {
        public String name;
        public int colour;

        public FriendConfig(String name, int colour) {
            this.name = name;
            this.colour = colour;
        }
    }
}

