/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.itamio.antiweakchat.config.Config;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"antiweakchat");
    private static final String CONFIG_DIR = "config/antiweakchat";
    private static final String CONFIG_FILE = "config/antiweakchat/config.json";
    private static Config currentConfig;
    private static final Gson GSON;

    public static void loadConfig() {
        try {
            File configFile;
            File configDir = new File(CONFIG_DIR);
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            if ((configFile = new File(CONFIG_FILE)).exists()) {
                FileReader reader = new FileReader(configFile);
                currentConfig = (Config)GSON.fromJson((Reader)reader, Config.class);
                reader.close();
                LOGGER.info("AntiWeakChat config loaded successfully");
            } else {
                currentConfig = new Config();
                ConfigManager.saveConfig();
                LOGGER.info("AntiWeakChat config created with defaults");
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load AntiWeakChat config", (Throwable)e);
            currentConfig = new Config();
        }
    }

    public static void saveConfig() {
        try {
            File configDir = new File(CONFIG_DIR);
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            File configFile = new File(CONFIG_FILE);
            FileWriter writer = new FileWriter(configFile);
            GSON.toJson((Object)currentConfig, (Appendable)writer);
            writer.close();
            LOGGER.info("AntiWeakChat config saved successfully");
        }
        catch (IOException e) {
            LOGGER.error("Failed to save AntiWeakChat config", (Throwable)e);
        }
    }

    public static Config getConfig() {
        if (currentConfig == null) {
            ConfigManager.loadConfig();
        }
        return currentConfig;
    }

    public static void setConfig(Config config) {
        currentConfig = config;
        ConfigManager.saveConfig();
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

