/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.encryption;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"antiweakchat");
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final BigInteger BASE = BigInteger.valueOf("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length());
    private static final Map<Character, Integer> INDEX_MAP = new HashMap<Character, Integer>();
    private static final Map<String, String> SELF_CACHE;

    public static String encryptForSending(String plainText, String secret) {
        if (plainText == null) {
            return null;
        }
        if (secret == null) {
            secret = "";
        }
        try {
            byte[] plainBytes = plainText.getBytes(StandardCharsets.UTF_8);
            if (plainBytes.length > 65535) {
                LOGGER.warn("EncryptionManager: message too long to encrypt (length {})", (Object)plainBytes.length);
                return null;
            }
            byte[] key = EncryptionManager.sha256(secret);
            byte[] enc = new byte[plainBytes.length];
            for (int i = 0; i < plainBytes.length; ++i) {
                enc[i] = (byte)(plainBytes[i] ^ key[i % key.length] ^ i * 90 & 0xFF);
            }
            byte[] data = new byte[2 + enc.length];
            data[0] = (byte)(enc.length >>> 8 & 0xFF);
            data[1] = (byte)(enc.length & 0xFF);
            System.arraycopy(enc, 0, data, 2, enc.length);
            String payload = EncryptionManager.base62Encode(data);
            return payload;
        }
        catch (Throwable t) {
            LOGGER.debug("EncryptionManager: encrypt failed", t);
            return null;
        }
    }

    public static String decrypt(String payloadBase62, String secret) {
        if (payloadBase62 == null) {
            return null;
        }
        if (secret == null) {
            secret = "";
        }
        try {
            byte[] data = EncryptionManager.base62Decode(payloadBase62);
            if (data == null || data.length < 2) {
                return null;
            }
            int len = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
            if (data.length < 2 + len) {
                LOGGER.debug("EncryptionManager: decoded data too short (have {}, need {})", (Object)data.length, (Object)(2 + len));
                return null;
            }
            byte[] enc = new byte[len];
            System.arraycopy(data, 2, enc, 0, len);
            byte[] key = EncryptionManager.sha256(secret);
            byte[] plain = new byte[len];
            for (int i = 0; i < len; ++i) {
                plain[i] = (byte)(enc[i] ^ key[i % key.length] ^ i * 90 & 0xFF);
            }
            return new String(plain, StandardCharsets.UTF_8);
        }
        catch (Throwable t) {
            LOGGER.debug("EncryptionManager: decrypt failed", t);
            return null;
        }
    }

    public static String wrapPayload(String payloadBase62) {
        return "E[" + payloadBase62 + "]";
    }

    public static void storeSelfMapping(String payloadBase62, String originalPlaintext) {
        if (payloadBase62 == null || originalPlaintext == null) {
            return;
        }
        SELF_CACHE.put(payloadBase62, originalPlaintext);
    }

    public static String getSelfOriginal(String payloadBase62) {
        if (payloadBase62 == null) {
            return null;
        }
        return SELF_CACHE.get(payloadBase62);
    }

    private static String base62Encode(byte[] input) {
        int leadingZeros;
        if (input == null) {
            return null;
        }
        if (input.length == 0) {
            return String.valueOf(ALPHABET.charAt(0));
        }
        for (leadingZeros = 0; leadingZeros < input.length && input[leadingZeros] == 0; ++leadingZeros) {
        }
        BigInteger value = new BigInteger(1, input);
        StringBuilder sb = new StringBuilder();
        while (value.compareTo(BigInteger.ZERO) > 0) {
            BigInteger[] dr = value.divideAndRemainder(BASE);
            value = dr[0];
            int idx = dr[1].intValue();
            sb.append(ALPHABET.charAt(idx));
        }
        for (int i = 0; i < leadingZeros; ++i) {
            sb.append(ALPHABET.charAt(0));
        }
        return sb.length() == 0 ? String.valueOf(ALPHABET.charAt(0)) : sb.reverse().toString();
    }

    private static byte[] base62Decode(String s) {
        byte[] raw;
        int leadingZeroChars;
        if (s == null || s.isEmpty()) {
            return new byte[0];
        }
        for (leadingZeroChars = 0; leadingZeroChars < s.length() && s.charAt(leadingZeroChars) == ALPHABET.charAt(0); ++leadingZeroChars) {
        }
        BigInteger value = BigInteger.ZERO;
        for (int i = leadingZeroChars; i < s.length(); ++i) {
            char c = s.charAt(i);
            Integer idx = INDEX_MAP.get(Character.valueOf(c));
            if (idx == null) {
                return null;
            }
            value = value.multiply(BASE).add(BigInteger.valueOf(idx.intValue()));
        }
        byte[] byArray = raw = value.equals(BigInteger.ZERO) ? new byte[]{} : value.toByteArray();
        if (raw.length > 0 && raw[0] == 0) {
            byte[] tmp = new byte[raw.length - 1];
            System.arraycopy(raw, 1, tmp, 0, tmp.length);
            raw = tmp;
        }
        byte[] out = new byte[leadingZeroChars + raw.length];
        for (int i = 0; i < leadingZeroChars; ++i) {
            out[i] = 0;
        }
        System.arraycopy(raw, 0, out, leadingZeroChars, raw.length);
        return out;
    }

    private static byte[] sha256(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return md.digest((s == null ? "" : s).getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            return (s == null ? "" : s).getBytes(StandardCharsets.UTF_8);
        }
    }

    static {
        for (int i = 0; i < ALPHABET.length(); ++i) {
            INDEX_MAP.put(Character.valueOf(ALPHABET.charAt(i)), i);
        }
        SELF_CACHE = new ConcurrentHashMap<String, String>();
    }
}

