/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.event;

import io.itamio.antiweakchat.config.Config;
import io.itamio.antiweakchat.config.ConfigManager;
import io.itamio.antiweakchat.encryption.EncryptionManager;
import io.itamio.antiweakchat.event.ConfigGuiOpener;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="antiweakchat", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ChatEventHandler {
    private static final String CONFIG_COMMAND = ".config-antiweakchat";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"antiweakchat");

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientChat(ClientChatEvent event) {
        String message = event.getMessage();
        if (message == null) {
            return;
        }
        String trimmed = message.trim();
        if (trimmed.equals(CONFIG_COMMAND)) {
            LOGGER.info("AntiWeakChat: Intercepted config command, requesting config GUI open");
            event.setCanceled(true);
            ConfigGuiOpener.requestOpen();
            return;
        }
        try {
            Config cfg = ConfigManager.getConfig();
            if (cfg != null && cfg.selfEncryptionEnabled) {
                if (message.startsWith("/") || message.startsWith(".")) {
                    return;
                }
                String secret = cfg.selfSecret != null ? cfg.selfSecret : "";
                String payload = EncryptionManager.encryptForSending(message, secret);
                if (payload != null) {
                    EncryptionManager.storeSelfMapping(payload, message);
                    String wrapped = EncryptionManager.wrapPayload(payload);
                    event.setCanceled(true);
                    Minecraft mc = Minecraft.m_91087_();
                    if (mc != null && mc.f_91074_ != null) {
                        try {
                            Method m = mc.f_91074_.getClass().getDeclaredMethod("sendChat", String.class, Component.class);
                            m.setAccessible(true);
                            m.invoke((Object)mc.f_91074_, wrapped, Component.m_237113_((String)wrapped));
                            LOGGER.info("AntiWeakChat: Sent encrypted chat via reflected LocalPlayer.sendChat");
                        }
                        catch (Throwable t) {
                            LOGGER.error("AntiWeakChat: Failed to invoke LocalPlayer.sendChat reflectively", t);
                        }
                    } else {
                        LOGGER.warn("AntiWeakChat: No local player available to send encrypted chat");
                    }
                } else {
                    LOGGER.warn("AntiWeakChat: Failed to encrypt outgoing message; sending original");
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("AntiWeakChat: outgoing encryption failed", (Throwable)e);
        }
    }
}

