/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.event;

import io.itamio.antiweakchat.event.MessageTransformer;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="antiweakchat", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ChatHistory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"antiweakchat");
    private static final List<Component> HISTORY = Collections.synchronizedList(new ArrayList());
    private static volatile boolean refreshRequested = false;
    private static volatile boolean renderRefreshPending = false;
    private static final int MAX_HISTORY = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRaw(Component original) {
        if (original == null) {
            return;
        }
        List<Component> list = HISTORY;
        synchronized (list) {
            if (HISTORY.size() >= 1000) {
                HISTORY.remove(0);
            }
            HISTORY.add((Component)original.m_6881_());
        }
    }

    public static void requestRefresh() {
        refreshRequested = true;
        renderRefreshPending = true;
    }

    public static void handleRenderEvent() {
        if (!renderRefreshPending) {
            return;
        }
        renderRefreshPending = false;
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91065_ == null) {
            return;
        }
        try {
            ChatHistory.rebuildChat(mc);
        }
        catch (Exception e) {
            LOGGER.error("ChatHistory: rebuild on render failed", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!refreshRequested) {
            return;
        }
        refreshRequested = false;
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91065_ == null) {
            return;
        }
        mc.execute(() -> ChatHistory.rebuildChat(mc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rebuildChat(Minecraft mc) {
        try {
            ChatComponent chat = mc.f_91065_.m_93076_();
            if (chat == null) {
                return;
            }
            boolean cleared = ChatHistory.clearChatComponent(chat);
            if (!cleared) {
                LOGGER.debug("ChatHistory: couldn't find a clear method/field on ChatComponent; rebuild may duplicate messages.");
            } else {
                LOGGER.debug("ChatHistory: cleared chat component successfully");
            }
            Method addMethod = ChatHistory.findAddMessageMethod(chat.getClass());
            if (addMethod == null) {
                LOGGER.warn("ChatHistory: could not find addMessage(Component) on ChatComponent - cannot rebuild chat.");
                return;
            }
            addMethod.setAccessible(true);
            List<Component> list = HISTORY;
            synchronized (list) {
                for (Component raw : HISTORY) {
                    try {
                        Component transformed;
                        String text = raw.getString();
                        String sender = MessageTransformer.extractSenderName(text);
                        LOGGER.info("ChatHistory: Re-adding message: '{}'", (Object)text);
                        LOGGER.debug("ChatHistory: extracted sender -> {}", (Object)sender);
                        boolean shouldIgnore = false;
                        try {
                            shouldIgnore = MessageTransformer.shouldIgnoreMessage(text, sender);
                        }
                        catch (Exception e) {
                            LOGGER.debug("ChatHistory: Error while evaluating ignore rules for '{}'", (Object)text, (Object)e);
                        }
                        if (shouldIgnore) {
                            LOGGER.info("ChatHistory: Skipping message due to current ignore rules: '{}'", (Object)text);
                            continue;
                        }
                        Component dec = MessageTransformer.applyDecryptionIfNeeded(raw, sender);
                        if (dec == null) {
                            dec = raw;
                        }
                        if ((transformed = MessageTransformer.transformMessage(dec, sender)) == null) continue;
                        ChatHistory.invokeAddMethod(addMethod, chat, transformed);
                    }
                    catch (Exception e) {
                        LOGGER.error("ChatHistory: Failed to re-add message", (Throwable)e);
                    }
                }
            }
            LOGGER.info("ChatHistory: chat rebuilt with {} messages", (Object)HISTORY.size());
        }
        catch (Exception e) {
            LOGGER.error("ChatHistory: rebuild failed", (Throwable)e);
        }
    }

    private static boolean clearChatComponent(Object target) {
        String[] candidateFieldNames;
        String[] candidateMethodNames;
        if (target == null) {
            return false;
        }
        boolean didClear = false;
        for (String name : candidateMethodNames = new String[]{"clearMessages", "clear", "reset", "clearChat", "resetChat", "removeAll", "removeMessages", "clearLines"}) {
            Method m = ChatHistory.findMethod(target.getClass(), name, new Class[0]);
            if (m == null) continue;
            try {
                m.setAccessible(true);
                if (m.getParameterCount() == 0) {
                    m.invoke(target, new Object[0]);
                } else {
                    Object[] args = new Object[m.getParameterCount()];
                    for (int i = 0; i < args.length; ++i) {
                        Class<?> p = m.getParameterTypes()[i];
                        args[i] = p == Boolean.TYPE || p == Boolean.class ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)(p == Integer.TYPE || p == Integer.class ? Integer.valueOf(0) : null);
                    }
                    m.invoke(target, args);
                }
                didClear = true;
            }
            catch (Throwable args) {
                // empty catch block
            }
        }
        for (String fn : candidateFieldNames = new String[]{"messages", "visibleMessages", "chatLines", "messagesList", "messageList", "allMessages", "queuedMessages", "messageQueue", "sentMessages", "visibleMessagesQueue"}) {
            Field f = ChatHistory.findField(target.getClass(), fn);
            if (f == null) continue;
            try {
                Class<?> ft;
                f.setAccessible(true);
                Object val = f.get(target);
                if (val instanceof Collection) {
                    ((Collection)val).clear();
                    didClear = true;
                    continue;
                }
                if (val instanceof Map) {
                    ((Map)val).clear();
                    didClear = true;
                    continue;
                }
                if (val != null || !List.class.isAssignableFrom(ft = f.getType())) continue;
                try {
                    f.set(target, new ArrayList());
                    didClear = true;
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable val) {
                // empty catch block
            }
        }
        for (Class<?> cls = target.getClass(); cls != null; cls = cls.getSuperclass()) {
            try {
                Field[] fields;
                for (Field f : fields = cls.getDeclaredFields()) {
                    try {
                        f.setAccessible(true);
                        Object val = f.get(target);
                        if (val instanceof Collection) {
                            ((Collection)val).clear();
                            didClear = true;
                            continue;
                        }
                        if (!(val instanceof Map)) continue;
                        ((Map)val).clear();
                        didClear = true;
                    }
                    catch (Throwable val) {
                        // empty catch block
                    }
                }
                continue;
            }
            catch (Throwable fields) {
                // empty catch block
            }
        }
        try {
            Method[] methods;
            for (Method m : methods = target.getClass().getMethods()) {
                try {
                    Object val;
                    Class<?> rt;
                    if (m.getParameterCount() != 0 || !Collection.class.isAssignableFrom(rt = m.getReturnType()) || !((val = m.invoke(target, new Object[0])) instanceof Collection)) continue;
                    ((Collection)val).clear();
                    didClear = true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return didClear;
    }

    private static Method findAddMessageMethod(Class<?> cls) {
        List<Method> methods = ChatHistory.getAllMethods(cls);
        Method fallback = null;
        for (Method m : methods) {
            Class<?>[] params = m.getParameterTypes();
            boolean hasComponentParam = false;
            for (Class<?> p : params) {
                if (!Component.class.isAssignableFrom(p)) continue;
                hasComponentParam = true;
                break;
            }
            if (!hasComponentParam) continue;
            String name = m.getName().toLowerCase();
            if (name.contains("add") && name.contains("message")) {
                return m;
            }
            if (name.contains("add") || name.contains("message")) {
                if (fallback != null) continue;
                fallback = m;
                continue;
            }
            if (fallback != null) continue;
            fallback = m;
        }
        return fallback;
    }

    private static void invokeAddMethod(Method method, Object target, Component component) throws Exception {
        int pc = method.getParameterCount();
        Object[] args = new Object[pc];
        int compIndex = -1;
        for (int i = 0; i < pc; ++i) {
            Class<?> p = method.getParameterTypes()[i];
            if (compIndex < 0 && Component.class.isAssignableFrom(p)) {
                compIndex = i;
                args[i] = component;
                continue;
            }
            args[i] = p == Integer.TYPE || p == Integer.class ? (Constable)Integer.valueOf(0) : (Constable)(p == Boolean.TYPE || p == Boolean.class ? Boolean.valueOf(false) : null);
        }
        if (compIndex < 0) {
            throw new NoSuchMethodException("No Component param in method " + method.getName());
        }
        method.setAccessible(true);
        method.invoke(target, args);
    }

    private static List<Method> getAllMethods(Class<?> cls) {
        ArrayList<Method> out = new ArrayList<Method>();
        for (Class<?> current = cls; current != null; current = current.getSuperclass()) {
            try {
                Method[] declared;
                for (Method m : declared = current.getDeclaredMethods()) {
                    out.add(m);
                }
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return out;
    }

    private static Method findMethod(Class<?> cls, String name, Class<?> ... params) {
        try {
            return cls.getMethod(name, params);
        }
        catch (NoSuchMethodException e) {
            try {
                return cls.getDeclaredMethod(name, params);
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }
    }

    private static Field findField(Class<?> cls, String name) {
        try {
            return cls.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            for (Class<?> parent = cls.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
                try {
                    Field f = parent.getDeclaredField(name);
                    return f;
                }
                catch (NoSuchFieldException ex) {
                    continue;
                }
            }
            return null;
        }
    }
}

