/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.event;

import io.itamio.antiweakchat.config.Config;
import io.itamio.antiweakchat.config.ConfigManager;
import io.itamio.antiweakchat.event.ChatHistory;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="antiweakchat", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ChatRenderHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"antiweakchat");

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onChatRender(RenderGuiOverlayEvent event) {
        ChatHistory.handleRenderEvent();
        Config config = ConfigManager.getConfig();
        if (!(config.selfColourEnabled || config.friendColourEnabled || config.baseColourEnabled)) {
            return;
        }
    }

    public static Component applyColouring(Component component, String senderName) {
        boolean matched;
        String detectionMethod;
        Config config = ConfigManager.getConfig();
        String messageText = component.getString();
        LOGGER.info("[ChatRenderHandler] applyColouring - message='{}', senderParam='{}'", (Object)messageText, (Object)senderName);
        String string = detectionMethod = config.playerNameDetectionMethod == null || config.playerNameDetectionMethod.isEmpty() ? "PLAYERNAME" : config.playerNameDetectionMethod;
        if (config.selfColourEnabled) {
            if (senderName != null) {
                boolean isSelf = ChatRenderHandler.isSelfMessage(senderName);
                LOGGER.info("[ChatRenderHandler] Sender-based self check: senderName='{}' -> isSelf={}", (Object)senderName, (Object)isSelf);
                if (isSelf) {
                    LOGGER.info("[ChatRenderHandler] Applying self colour (0x{})", (Object)Integer.toHexString(config.selfColour));
                    return ChatRenderHandler.createColouredComponent(component, config.selfColour);
                }
            } else {
                String local = null;
                Minecraft mc = Minecraft.m_91087_();
                if (mc != null && mc.f_91074_ != null) {
                    local = mc.f_91074_.m_36316_().getName();
                }
                if (local != null) {
                    String patternStr = detectionMethod.replace("PLAYERNAME", Pattern.quote(local));
                    Pattern p = Pattern.compile(".*" + patternStr + ".*", 2);
                    matched = p.matcher(messageText).matches();
                    LOGGER.info("[ChatRenderHandler] Detection-based self check: pattern='{}' -> matched={}", (Object)patternStr, (Object)matched);
                    if (matched) {
                        LOGGER.info("[ChatRenderHandler] Applying self colour (0x{})", (Object)Integer.toHexString(config.selfColour));
                        return ChatRenderHandler.createColouredComponent(component, config.selfColour);
                    }
                } else {
                    LOGGER.debug("[ChatRenderHandler] Local player name unknown; skipping detection-based self check");
                }
            }
        }
        if (config.friendColourEnabled && config.friends != null) {
            for (Map.Entry<String, Config.FriendConfig> e : config.friends.entrySet()) {
                String friendName = e.getKey();
                int friendColour = e.getValue().colour;
                matched = ChatRenderHandler.matchesPlayerName(friendName, messageText, detectionMethod);
                LOGGER.info("[ChatRenderHandler] Friend check: friend='{}' -> matched={}", (Object)friendName, (Object)matched);
                if (!matched) continue;
                LOGGER.info("[ChatRenderHandler] Applying friend colour (0x{}) for '{}'", (Object)Integer.toHexString(friendColour), (Object)friendName);
                return ChatRenderHandler.createColouredComponent(component, friendColour);
            }
        }
        if (config.baseColourEnabled) {
            LOGGER.info("[ChatRenderHandler] Applying base colour fallback (0x{})", (Object)Integer.toHexString(config.baseColour));
            return ChatRenderHandler.createColouredComponent(component, config.baseColour);
        }
        LOGGER.debug("[ChatRenderHandler] No colouring rule matched; returning original component");
        return component;
    }

    private static boolean isSelfMessage(String senderName) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null) {
            return minecraft.f_91074_.m_36316_().getName().equals(senderName);
        }
        return false;
    }

    private static boolean matchesPlayerName(String playerName, String messageText, String detectionMethod) {
        String pattern = detectionMethod.replace("PLAYERNAME", Pattern.quote(playerName));
        Pattern namePattern = Pattern.compile(".*" + pattern + ".*", 2);
        return namePattern.matcher(messageText).matches();
    }

    private static Component createColouredComponent(Component original, int colour) {
        MutableComponent mutableComponent = original.m_6881_();
        int rgb = colour & 0xFFFFFF;
        mutableComponent.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgb)));
        LOGGER.debug("[ChatRenderHandler] createColouredComponent -> applied RGB 0x{}", (Object)Integer.toHexString(rgb));
        return mutableComponent;
    }
}

