/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.event;

import com.mojang.blaze3d.platform.InputConstants;
import io.itamio.antiweakchat.config.Config;
import io.itamio.antiweakchat.config.ConfigManager;
import io.itamio.antiweakchat.screen.ConfigScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="antiweakchat", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ConfigGuiOpener {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"antiweakchat");
    private static volatile boolean openRequested = false;
    private static boolean lastKeyDown = false;

    public static void requestOpen() {
        openRequested = true;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            LOGGER.warn("AntiWeakChat: Minecraft instance null when trying to open config screen");
            return;
        }
        try {
            Config cfg = ConfigManager.getConfig();
            int keyCode = cfg.openKey;
            boolean isDown = InputConstants.m_84830_((long)mc.m_91268_().m_85439_(), (int)keyCode);
            if (isDown && !lastKeyDown) {
                mc.execute(() -> {
                    if (mc.f_91080_ == null) {
                        LOGGER.info("AntiWeakChat: Keybind pressed - opening config screen");
                        mc.m_91152_((Screen)new ConfigScreen());
                    } else {
                        LOGGER.info("AntiWeakChat: Keybind pressed - closing current screen");
                        mc.m_91152_(null);
                    }
                });
            }
            lastKeyDown = isDown;
        }
        catch (Exception e) {
            LOGGER.debug("AntiWeakChat: keybind check failed", (Throwable)e);
        }
        if (!openRequested) {
            return;
        }
        openRequested = false;
        LOGGER.info("AntiWeakChat: Opening config screen from tick handler (requested)");
        mc.execute(() -> {
            try {
                mc.m_91152_((Screen)new ConfigScreen());
                LOGGER.info("AntiWeakChat: Config screen set");
            }
            catch (Exception e) {
                LOGGER.error("AntiWeakChat: Failed to open config screen", (Throwable)e);
            }
        });
    }
}

