/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.event;

import io.itamio.antiweakchat.config.Config;
import io.itamio.antiweakchat.config.ConfigManager;
import io.itamio.antiweakchat.encryption.EncryptionManager;
import io.itamio.antiweakchat.event.ChatHistory;
import io.itamio.antiweakchat.event.ChatRenderHandler;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="antiweakchat", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class MessageTransformer {
    private static final Minecraft CLIENT = Minecraft.m_91087_();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"antiweakchat");
    private static final Pattern ENC_PATTERN = Pattern.compile("E\\[([A-Za-z0-9]+)\\]");

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onChatRender(RenderGuiOverlayEvent event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientChatReceived(ClientChatReceivedEvent event) {
        Component original = event.getMessage();
        if (original == null) {
            return;
        }
        String rawText = original.getString();
        LOGGER.info("[MessageTransformer] onClientChatReceived - full message: '{}'", (Object)rawText);
        String senderName = MessageTransformer.extractSenderName(rawText);
        LOGGER.info("[MessageTransformer] extractSenderName -> {}", (Object)senderName);
        try {
            ChatHistory.addRaw(original);
        }
        catch (Exception e) {
            LOGGER.debug("[MessageTransformer] Failed to add raw message to history", (Throwable)e);
        }
        try {
            if (MessageTransformer.shouldIgnoreMessage(rawText, senderName)) {
                LOGGER.info("[MessageTransformer] Ignoring message due to ignore rules: '{}'", (Object)rawText);
                event.setCanceled(true);
                return;
            }
        }
        catch (Exception e) {
            LOGGER.debug("[MessageTransformer] Error while checking ignore rules", (Throwable)e);
        }
        try {
            Component dec = MessageTransformer.applyDecryptionIfNeeded(original, senderName);
            if (dec != null && dec != original) {
                original = dec;
                rawText = original.getString();
                LOGGER.info("[MessageTransformer] Decrypted message. New text: '{}'", (Object)rawText);
            }
        }
        catch (Exception e) {
            LOGGER.debug("[MessageTransformer] Error during decryption processing", (Throwable)e);
        }
        Component transformed = MessageTransformer.transformMessage(original, senderName);
        if (transformed == null) {
            LOGGER.info("[MessageTransformer] Message suppressed by transform (null returned)");
            event.setCanceled(true);
            return;
        }
        if (transformed != original) {
            LOGGER.info("[MessageTransformer] Message transformed - applying transformed component");
            event.setMessage(transformed);
        } else {
            LOGGER.info("[MessageTransformer] No transformation applied to message");
        }
    }

    public static String extractSenderName(String rawText) {
        if (rawText == null) {
            return null;
        }
        String s = rawText.trim();
        try {
            int idx;
            String candidate;
            int end;
            if (s.startsWith("<") && (end = s.indexOf(62)) > 1 && end <= 17 && (candidate = s.substring(1, end).trim()).matches("[A-Za-z0-9_]{1,16}")) {
                return candidate;
            }
            int colon = s.indexOf(58);
            if (colon > 0 && colon <= 16 && (candidate = s.substring(0, colon).trim()).matches("[A-Za-z0-9_]{1,16}")) {
                return candidate;
            }
            Config cfg = ConfigManager.getConfig();
            String method = cfg == null || cfg.playerNameDetectionMethod == null || cfg.playerNameDetectionMethod.isEmpty() ? "PLAYERNAME" : cfg.playerNameDetectionMethod;
            String local = null;
            Minecraft mc = Minecraft.m_91087_();
            if (mc != null && mc.f_91074_ != null) {
                local = mc.f_91074_.m_36316_().getName();
            }
            if (local != null && (idx = MessageTransformer.indexOfDetection(method.replace("PLAYERNAME", local), s)) >= 0) {
                return local;
            }
            if (cfg != null && cfg.friends != null) {
                for (Map.Entry<String, Config.FriendConfig> e : cfg.friends.entrySet()) {
                    int idx2;
                    String friend = e.getKey();
                    if (friend == null || (idx2 = MessageTransformer.indexOfDetection(method.replace("PLAYERNAME", friend), s)) < 0) continue;
                    return friend;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean shouldIgnoreMessage(String rawText, String senderName) {
        boolean decision;
        String method;
        Config cfg = ConfigManager.getConfig();
        if (cfg == null || !cfg.ignoreEnabled) {
            return false;
        }
        String text = rawText == null ? "" : rawText;
        String string = method = cfg.playerNameDetectionMethod == null || cfg.playerNameDetectionMethod.isEmpty() ? "PLAYERNAME" : cfg.playerNameDetectionMethod;
        if (cfg.ignoreExceptionsEnabled && (MessageTransformer.containsSelf(text, method) || MessageTransformer.containsAnyFriend(text, method))) {
            return false;
        }
        boolean isBlacklist = "blacklist".equalsIgnoreCase(cfg.ignoreMode);
        boolean isWhitelist = !isBlacklist;
        boolean senderInList = senderName != null && cfg.ignoreList.contains(senderName);
        boolean anyIgnoreNamePresent = false;
        String firstIgnoreFound = null;
        int firstIgnoreIndex = Integer.MAX_VALUE;
        for (String name : cfg.ignoreList) {
            int idx;
            if (name == null || (idx = MessageTransformer.indexOfDetection(method.replace("PLAYERNAME", name), text)) < 0) continue;
            anyIgnoreNamePresent = true;
            if (idx >= firstIgnoreIndex) continue;
            firstIgnoreIndex = idx;
            firstIgnoreFound = name;
        }
        if (isWhitelist) {
            decision = senderInList || anyIgnoreNamePresent;
        } else if (senderName != null) {
            decision = !senderInList;
        } else {
            boolean bl = decision = !anyIgnoreNamePresent;
        }
        if (decision) {
            try {
                if (cfg.ignoreSelfFrontCheck || cfg.ignoreFriendsFrontCheck) {
                    int ignoreIdx;
                    int selfIdx = cfg.ignoreSelfFrontCheck ? MessageTransformer.indexOfSelf(text, method) : -1;
                    int friendIdx = cfg.ignoreFriendsFrontCheck ? MessageTransformer.indexOfFirstFriend(text, method) : -1;
                    int n = ignoreIdx = firstIgnoreIndex == Integer.MAX_VALUE ? -1 : firstIgnoreIndex;
                    if (ignoreIdx >= 0) {
                        if (cfg.ignoreSelfFrontCheck && selfIdx >= 0 && selfIdx < ignoreIdx) {
                            decision = false;
                        } else if (cfg.ignoreFriendsFrontCheck && friendIdx >= 0 && friendIdx < ignoreIdx) {
                            decision = false;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return decision;
    }

    private static boolean containsSelf(String text, String method) {
        String local;
        Minecraft mc = Minecraft.m_91087_();
        if (mc != null && mc.f_91074_ != null && (local = mc.f_91074_.m_36316_().getName()) != null) {
            return MessageTransformer.indexOfDetection(method.replace("PLAYERNAME", local), text) >= 0;
        }
        return false;
    }

    private static int indexOfSelf(String text, String method) {
        String local;
        Minecraft mc = Minecraft.m_91087_();
        if (mc != null && mc.f_91074_ != null && (local = mc.f_91074_.m_36316_().getName()) != null) {
            return MessageTransformer.indexOfDetection(method.replace("PLAYERNAME", local), text);
        }
        return -1;
    }

    private static boolean containsAnyFriend(String text, String method) {
        Config cfg = ConfigManager.getConfig();
        if (cfg == null || cfg.friends == null) {
            return false;
        }
        for (Map.Entry<String, Config.FriendConfig> e : cfg.friends.entrySet()) {
            String name = e.getKey();
            if (name == null || MessageTransformer.indexOfDetection(method.replace("PLAYERNAME", name), text) < 0) continue;
            return true;
        }
        return false;
    }

    private static int indexOfFirstFriend(String text, String method) {
        Config cfg = ConfigManager.getConfig();
        if (cfg == null || cfg.friends == null) {
            return -1;
        }
        int best = Integer.MAX_VALUE;
        for (Map.Entry<String, Config.FriendConfig> e : cfg.friends.entrySet()) {
            int idx;
            String name = e.getKey();
            if (name == null || (idx = MessageTransformer.indexOfDetection(method.replace("PLAYERNAME", name), text)) < 0 || idx >= best) continue;
            best = idx;
        }
        return best == Integer.MAX_VALUE ? -1 : best;
    }

    private static int indexOfDetection(String literalPattern, String text) {
        if (literalPattern == null || text == null) {
            return -1;
        }
        String needle = literalPattern;
        String hay = text;
        int idx = hay.toLowerCase().indexOf(needle.toLowerCase());
        return idx;
    }

    private static boolean isSelfMessage(String senderName) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null && senderName != null) {
            return minecraft.f_91074_.m_36316_().getName().equals(senderName);
        }
        return false;
    }

    public static Component applyDecryptionIfNeeded(Component original, String senderName) {
        if (original == null) {
            return null;
        }
        String text = original.getString();
        try {
            Matcher encMatcher = ENC_PATTERN.matcher(text);
            if (!encMatcher.find()) {
                return original;
            }
            Config cfg = ConfigManager.getConfig();
            StringBuffer sb = new StringBuffer();
            boolean replaced = false;
            do {
                String dec;
                String secret;
                String orig;
                String payload = encMatcher.group(1);
                String replacement = null;
                if (senderName != null && cfg != null && cfg.selfDecryptionEnabled && MessageTransformer.isSelfMessage(senderName) && (orig = EncryptionManager.getSelfOriginal(payload)) != null) {
                    replacement = orig;
                }
                if (replacement == null && senderName != null && cfg != null && cfg.friendDecryptionEnabled && cfg.friendSecrets != null && (secret = cfg.friendSecrets.get(senderName)) != null && !secret.isEmpty() && (dec = EncryptionManager.decrypt(payload, secret)) != null) {
                    replacement = dec;
                }
                if (replacement == null) {
                    replacement = encMatcher.group(0);
                } else {
                    replaced = true;
                }
                encMatcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
            } while (encMatcher.find());
            encMatcher.appendTail(sb);
            if (!replaced) {
                return original;
            }
            MutableComponent newComponent = Component.m_237113_((String)sb.toString());
            newComponent.m_6270_(original.m_7383_());
            return newComponent;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Component transformMessage(Component original, String senderName) {
        return ChatRenderHandler.applyColouring(original, senderName);
    }
}

