/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;

public class ColourPickerPopupScreen
extends Screen {
    private final Screen parent;
    private final Consumer<Integer> callback;
    private int initialColorARGB;
    private int svBoxX;
    private int svBoxY;
    private int svBoxSize;
    private int hueX;
    private int hueY;
    private int hueW;
    private int hueH;
    private int alphaX;
    private int alphaY;
    private int alphaW;
    private int alphaH;
    private int previewX;
    private int previewY;
    private int previewW;
    private int previewH;
    private EditBox hexInput;
    private float hue = 0.0f;
    private float sat = 1.0f;
    private float val = 1.0f;
    private float alpha = 1.0f;
    private boolean draggingSV = false;
    private boolean draggingHue = false;
    private boolean draggingAlpha = false;

    public ColourPickerPopupScreen(Screen parent, int initialColorARGB, Consumer<Integer> callback) {
        super((Component)Component.m_237113_((String)"Colour Picker"));
        this.parent = parent;
        this.callback = callback;
        this.initialColorARGB = initialColorARGB;
        int a = initialColorARGB >> 24 & 0xFF;
        int r = initialColorARGB >> 16 & 0xFF;
        int g = initialColorARGB >> 8 & 0xFF;
        int b = initialColorARGB & 0xFF;
        float[] hsv = ColourPickerPopupScreen.rgbToHsv(r, g, b);
        this.hue = hsv[0];
        this.sat = hsv[1];
        this.val = hsv[2];
        this.alpha = (float)a / 255.0f;
    }

    protected void m_7856_() {
        super.m_7856_();
        int contentW = Math.min(360, this.f_96543_ - 40);
        int centerX = this.f_96543_ / 2;
        int startX = centerX - contentW / 2;
        this.svBoxSize = Math.min(180, this.f_96544_ / 3);
        this.svBoxX = startX + 12;
        this.svBoxY = 40;
        this.hueW = 16;
        this.hueH = this.svBoxSize;
        this.hueX = this.svBoxX + this.svBoxSize + 10;
        this.hueY = this.svBoxY;
        this.alphaW = this.svBoxSize;
        this.alphaH = 12;
        this.alphaX = this.svBoxX;
        this.alphaY = this.svBoxY + this.svBoxSize + 12;
        this.previewW = 48;
        this.previewH = 24;
        this.previewX = this.hueX + this.hueW + 14;
        this.previewY = this.svBoxY;
        int hexX = this.svBoxX;
        int hexY = this.alphaY + this.alphaH + 10;
        this.hexInput = new EditBox(this.f_96547_, hexX, hexY, this.svBoxSize, 20, (Component)Component.m_237113_((String)"Hex"));
        this.hexInput.m_94144_(ColourPickerPopupScreen.rgbToHex(this.getCurrentColorARGB(), true));
        this.m_142416_((GuiEventListener)this.hexInput);
        int btnY = hexY + 28;
        this.m_142416_((GuiEventListener)new Button(this.previewX, btnY, 60, 20, (Component)Component.m_237113_((String)"Confirm"), btn -> {
            int col = this.getCurrentColorARGB();
            if (this.callback != null) {
                this.callback.accept(col);
            }
            Minecraft.m_91087_().m_91152_(this.parent);
        }));
        this.m_142416_((GuiEventListener)new Button(this.previewX + 70, btnY, 60, 20, (Component)Component.m_237113_((String)"Cancel"), btn -> Minecraft.m_91087_().m_91152_(this.parent)));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        ColourPickerPopupScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)12, (int)0xFFFFFF);
        for (int x = 0; x < this.svBoxSize; ++x) {
            float s = (float)x / (float)Math.max(1, this.svBoxSize - 1);
            for (int y = 0; y < this.svBoxSize; ++y) {
                float v = 1.0f - (float)y / (float)Math.max(1, this.svBoxSize - 1);
                int col = ColourPickerPopupScreen.hsvToRgbInt(this.hue, s, v, 1.0f);
                GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.svBoxX + x), (int)(this.svBoxY + y), (int)(this.svBoxX + x + 1), (int)(this.svBoxY + y + 1), (int)col);
            }
        }
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.svBoxX - 1), (int)(this.svBoxY - 1), (int)(this.svBoxX + this.svBoxSize + 1), (int)this.svBoxY, (int)-16777216);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.svBoxX - 1), (int)(this.svBoxY - 1), (int)this.svBoxX, (int)(this.svBoxY + this.svBoxSize + 1), (int)-16777216);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.svBoxX + this.svBoxSize), (int)(this.svBoxY - 1), (int)(this.svBoxX + this.svBoxSize + 1), (int)(this.svBoxY + this.svBoxSize + 1), (int)-16777216);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.svBoxX - 1), (int)(this.svBoxY + this.svBoxSize), (int)(this.svBoxX + this.svBoxSize + 1), (int)(this.svBoxY + this.svBoxSize + 1), (int)-16777216);
        for (int y = 0; y < this.hueH; ++y) {
            float h = (float)y / (float)Math.max(1, this.hueH - 1);
            int col = ColourPickerPopupScreen.hsvToRgbInt(h, 1.0f, 1.0f, 1.0f);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)this.hueX, (int)(this.hueY + y), (int)(this.hueX + this.hueW), (int)(this.hueY + y + 1), (int)col);
        }
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.hueX - 1), (int)(this.hueY - 1), (int)this.hueX, (int)(this.hueY + this.hueH + 1), (int)-16777216);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.hueX + this.hueW), (int)(this.hueY - 1), (int)(this.hueX + this.hueW + 1), (int)(this.hueY + this.hueH + 1), (int)-16777216);
        int checker = 6;
        for (int xx = 0; xx < this.alphaW; xx += checker) {
            for (int yy = 0; yy < this.alphaH; yy += checker) {
                int px = this.alphaX + xx;
                int py = this.alphaY + yy;
                int color = (xx / checker + yy / checker) % 2 == 0 ? -3355444 : -7829368;
                GuiComponent.m_93172_((PoseStack)poseStack, (int)px, (int)py, (int)(px + Math.min(checker, this.alphaW - xx)), (int)(py + Math.min(checker, this.alphaH - yy)), (int)color);
            }
        }
        for (int x = 0; x < this.alphaW; ++x) {
            float aVal = (float)x / (float)Math.max(1, this.alphaW - 1);
            int overlay = ColourPickerPopupScreen.hsvToRgbInt(this.hue, this.sat, this.val, aVal);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.alphaX + x), (int)this.alphaY, (int)(this.alphaX + x + 1), (int)(this.alphaY + this.alphaH), (int)overlay);
        }
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.alphaX - 1), (int)(this.alphaY - 1), (int)(this.alphaX + this.alphaW + 1), (int)this.alphaY, (int)-16777216);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.alphaX - 1), (int)(this.alphaY - 1), (int)this.alphaX, (int)(this.alphaY + this.alphaH + 1), (int)-16777216);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.alphaX + this.alphaW), (int)(this.alphaY - 1), (int)(this.alphaX + this.alphaW + 1), (int)(this.alphaY + this.alphaH + 1), (int)-16777216);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.alphaX - 1), (int)(this.alphaY + this.alphaH), (int)(this.alphaX + this.alphaW + 1), (int)(this.alphaY + this.alphaH + 1), (int)-16777216);
        int previewCol = this.getCurrentColorARGB();
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.previewX - 1), (int)(this.previewY - 1), (int)(this.previewX + this.previewW + 1), (int)(this.previewY + this.previewH + 1), (int)-16777216);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)this.previewX, (int)this.previewY, (int)(this.previewX + this.previewW), (int)(this.previewY + this.previewH), (int)previewCol);
        int sx = this.svBoxX + Math.round(this.sat * (float)(this.svBoxSize - 1));
        int sy = this.svBoxY + Math.round((1.0f - this.val) * (float)(this.svBoxSize - 1));
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(sx - 3), (int)(sy - 3), (int)(sx + 4), (int)(sy + 4), (int)-16777216);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(sx - 2), (int)(sy - 2), (int)(sx + 3), (int)(sy + 3), (int)-1);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(sx - 1), (int)(sy - 1), (int)(sx + 2), (int)(sy + 2), (int)previewCol);
        int hy = this.hueY + Math.round(this.hue * (float)(this.hueH - 1));
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.hueX - 4), (int)(hy - 1), (int)(this.hueX + this.hueW + 4), (int)(hy + 2), (int)-16777216);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.hueX - 3), (int)hy, (int)(this.hueX + this.hueW + 3), (int)(hy + 1), (int)-1);
        int ax = this.alphaX + Math.round(this.alpha * (float)(this.alphaW - 1));
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(ax - 1), (int)(this.alphaY - 4), (int)(ax + 2), (int)(this.alphaY + this.alphaH + 4), (int)-16777216);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)ax, (int)(this.alphaY - 3), (int)(ax + 1), (int)(this.alphaY + this.alphaH + 3), (int)-1);
        ColourPickerPopupScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)("HEX: " + ColourPickerPopupScreen.rgbToHex(previewCol, true)), (int)this.previewX, (int)(this.previewY + this.previewH + 6), (int)0xFFFFFF);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (ColourPickerPopupScreen.isWithin(mouseX, mouseY, this.svBoxX, this.svBoxY, this.svBoxSize, this.svBoxSize)) {
            this.updateSVFromMouse(mouseX, mouseY);
            this.draggingSV = true;
            return true;
        }
        if (ColourPickerPopupScreen.isWithin(mouseX, mouseY, this.hueX, this.hueY, this.hueW, this.hueH)) {
            this.updateHueFromMouse(mouseX, mouseY);
            this.draggingHue = true;
            return true;
        }
        if (ColourPickerPopupScreen.isWithin(mouseX, mouseY, this.alphaX, this.alphaY, this.alphaW, this.alphaH)) {
            this.updateAlphaFromMouse(mouseX, mouseY);
            this.draggingAlpha = true;
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingSV) {
            this.updateSVFromMouse(mouseX, mouseY);
            return true;
        }
        if (this.draggingHue) {
            this.updateHueFromMouse(mouseX, mouseY);
            return true;
        }
        if (this.draggingAlpha) {
            this.updateAlphaFromMouse(mouseX, mouseY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.draggingAlpha = false;
        this.draggingHue = false;
        this.draggingSV = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void updateSVFromMouse(double mx, double my) {
        int rx = ColourPickerPopupScreen.clamp((int)Math.round(mx) - this.svBoxX, 0, this.svBoxSize - 1);
        int ry = ColourPickerPopupScreen.clamp((int)Math.round(my) - this.svBoxY, 0, this.svBoxSize - 1);
        this.sat = (float)rx / (float)Math.max(1, this.svBoxSize - 1);
        this.val = 1.0f - (float)ry / (float)Math.max(1, this.svBoxSize - 1);
        if (this.hexInput != null) {
            this.hexInput.m_94144_(ColourPickerPopupScreen.rgbToHex(this.getCurrentColorARGB(), true));
        }
    }

    private void updateHueFromMouse(double mx, double my) {
        int ry = ColourPickerPopupScreen.clamp((int)Math.round(my) - this.hueY, 0, this.hueH - 1);
        this.hue = (float)ry / (float)Math.max(1, this.hueH - 1);
        if (this.hexInput != null) {
            this.hexInput.m_94144_(ColourPickerPopupScreen.rgbToHex(this.getCurrentColorARGB(), true));
        }
    }

    private void updateAlphaFromMouse(double mx, double my) {
        int rx = ColourPickerPopupScreen.clamp((int)Math.round(mx) - this.alphaX, 0, this.alphaW - 1);
        this.alpha = (float)rx / (float)Math.max(1, this.alphaW - 1);
        if (this.hexInput != null) {
            this.hexInput.m_94144_(ColourPickerPopupScreen.rgbToHex(this.getCurrentColorARGB(), true));
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == Dist.CLIENT.hashCode()) {
            // empty if block
        }
        if (keyCode == 256) {
            Minecraft.m_91087_().m_91152_(this.parent);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private int getCurrentColorARGB() {
        return ColourPickerPopupScreen.hsvToRgbInt(this.hue, this.sat, this.val, this.alpha);
    }

    private static int hsvToRgbInt(float h01, float s, float v, float a) {
        h01 -= (float)Math.floor(h01);
        float h = h01 * 6.0f;
        int i = (int)Math.floor(h);
        float f = h - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - f * s);
        float t = v * (1.0f - (1.0f - f) * s);
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        switch (i % 6) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            case 5: {
                r = v;
                g = p;
                b = q;
            }
        }
        int ia = ColourPickerPopupScreen.clamp(Math.round(a * 255.0f), 0, 255);
        int ir = ColourPickerPopupScreen.clamp(Math.round(r * 255.0f), 0, 255);
        int ig = ColourPickerPopupScreen.clamp(Math.round(g * 255.0f), 0, 255);
        int ib = ColourPickerPopupScreen.clamp(Math.round(b * 255.0f), 0, 255);
        return ia << 24 | ir << 16 | ig << 8 | ib;
    }

    private static float[] rgbToHsv(int r, int g, int b) {
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float min = Math.min(rf, Math.min(gf, bf));
        float d = max - min;
        float h = 0.0f;
        h = d == 0.0f ? 0.0f : (max == rf ? (gf - bf) / d % 6.0f : (max == gf ? (bf - rf) / d + 2.0f : (rf - gf) / d + 4.0f));
        if ((h /= 6.0f) < 0.0f) {
            h += 1.0f;
        }
        float s = max == 0.0f ? 0.0f : d / max;
        float v = max;
        return new float[]{h, s, v};
    }

    private static int clamp(int v, int a, int b) {
        if (v < a) {
            return a;
        }
        if (v > b) {
            return b;
        }
        return v;
    }

    private static String rgbToHex(int argb, boolean includeAlpha) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        if (includeAlpha) {
            return String.format("#%02X%02X%02X%02X", a, r, g, b);
        }
        return String.format("#%02X%02X%02X", r, g, b);
    }

    private static boolean isWithin(double mx, double my, int x, int y, int w, int h) {
        return mx >= (double)x && mx <= (double)(x + w) && my >= (double)y && my <= (double)(y + h);
    }
}

