/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import io.itamio.antiweakchat.config.Config;
import io.itamio.antiweakchat.config.ConfigManager;
import io.itamio.antiweakchat.event.ChatHistory;
import io.itamio.antiweakchat.screen.ColourPickerPopupScreen;
import io.itamio.antiweakchat.screen.KeyBindPopupScreen;
import io.itamio.antiweakchat.screen.NameEditPopupScreen;
import io.itamio.antiweakchat.util.KeybindUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntUnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ConfigScreen
extends Screen {
    private Config config;
    private int scrollOffset = 0;
    private int contentHeight = 0;
    private int maxScroll = 0;
    private static final int CONTENT_WIDTH = 380;
    private static final int PADDING = 10;
    private static final int LINE_HEIGHT = 20;
    private static final int LABEL_HEIGHT = 12;
    private static final int SECTION_SPACING = 10;
    private static final int PREVIEW_SIZE = 18;
    private static final int SECTION_GAP = 16;
    private static final int TITLE_BAR_HEIGHT = 30;
    private static final int CONTENT_START_Y = 70;
    private final Map<Widget, WidgetPos> contentWidgets = new LinkedHashMap<Widget, WidgetPos>();
    private final List<Band> occupiedBands = new ArrayList<Band>();
    private EditBox playerNameDetectionInput;
    private EditBox friendNameInput;
    private int newFriendColour = -1;
    private final List<FriendListItem> friendListItems = new ArrayList<FriendListItem>();
    private final List<FriendListItem> ignoreListItems = new ArrayList<FriendListItem>();
    private EditBox ignoreNameInput;
    private Button addIgnoreButton;
    private Button addFriendButton;
    private int selfToggleRelX;
    private int selfToggleRelY;
    private int selfPreviewRelX;
    private int selfPreviewRelY;
    private int baseToggleRelX;
    private int baseToggleRelY;
    private int basePreviewRelX;
    private int basePreviewRelY;
    private int relNewFriendPreviewX;
    private int friendToggleRelX;
    private int friendToggleRelY;
    private int friendAddRelY;
    private int ignoreToggleRelX;
    private int ignoreToggleRelY;
    private int ignoreModeRelX;
    private int ignoreModeRelY;
    private int ignoreListStartRelY;
    private int exc1ToggleRelX;
    private int exc1ToggleRelY;
    private int exc2ToggleRelX;
    private int exc2ToggleRelY;
    private int exc3ToggleRelX;
    private int exc3ToggleRelY;
    private int colourSectionTopRel = 0;
    private int colourSectionBottomRel = 0;
    private int ignoreSectionTopRel = 0;
    private int ignoreSectionBottomRel = 0;
    private int contentX = 0;
    private String lastPersistedDetection = null;
    private int encryptionSectionTopRel = 0;
    private int encryptionSectionBottomRel = 0;
    private int encSelfToggleRelX;
    private int encSelfToggleRelY;
    private EditBox selfSecretInput;
    private int encSelfDecryptToggleRelX;
    private int encSelfDecryptToggleRelY;
    private int encFriendDecryptToggleRelX;
    private int encFriendDecryptToggleRelY;
    private int encFriendDecryptLabelRelY;
    private EditBox friendDecryptNameInput;
    private EditBox friendDecryptSecretInput;
    private Button addFriendDecryptButton;
    private final List<FriendSecretItem> friendDecryptItems = new ArrayList<FriendSecretItem>();
    private int friendDecryptAddRelY;

    public ConfigScreen() {
        super((Component)Component.m_237113_((String)"AntiWeakChat Config"));
        this.config = ConfigManager.getConfig();
        this.lastPersistedDetection = this.config.playerNameDetectionMethod;
    }

    protected void m_7856_() {
        int friendDecTogRowY;
        int friendDecLabelY;
        int selfDecRowY;
        int encSelfRowY;
        int exc3RowY;
        int exc2RowY;
        int exc1RowY;
        int toggleXRight;
        int ignoreControlsY;
        int dY;
        int friendsToggleYRel;
        super.m_7856_();
        this.m_169413_();
        this.contentWidgets.clear();
        this.friendListItems.clear();
        this.ignoreListItems.clear();
        this.friendDecryptItems.clear();
        this.occupiedBands.clear();
        this.contentX = (this.f_96543_ - 380) / 2;
        int yRel = 0;
        if (this.config != null) {
            this.scrollOffset = Math.max(0, this.config.lastConfigScroll);
        }
        Button closeBtn = (Button)this.m_142416_((GuiEventListener)new Button(this.contentX + 10, 70 + yRel, 80, 20, (Component)Component.m_237113_((String)"Close"), btn -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(null);
            }
        }));
        this.contentWidgets.put((Widget)closeBtn, new WidgetPos(10, yRel));
        this.occupyBand(yRel, 20);
        this.occupyBand(yRel, 30);
        yRel += 30;
        yRel = this.nextClearY(yRel, 12);
        this.addSectionLabel("Key Bind:", yRel);
        this.occupyBand(yRel, 12);
        int keyBtnRelX = 10;
        int keyBtnYRel = this.nextClearY(yRel += 16, 20);
        Button keyBindBtn = (Button)this.m_142416_((GuiEventListener)new Button(this.contentX + keyBtnRelX, 70 + keyBtnYRel, 80, 20, (Component)Component.m_237113_((String)KeybindUtil.getKeyName(this.config.openKey)), btn -> this.openKeyBindPopup()));
        this.contentWidgets.put((Widget)keyBindBtn, new WidgetPos(keyBtnRelX, keyBtnYRel));
        this.occupyBand(keyBtnYRel, 20);
        yRel = keyBtnYRel + 20 + 10;
        yRel = this.nextClearY(yRel, 12);
        this.addSectionLabel("Player Name Detection:", yRel);
        this.occupyBand(yRel, 12);
        int inputWidth = 180;
        int inputX = 10;
        int playerDetectYRel = this.nextClearY(yRel += 20, 20);
        this.playerNameDetectionInput = new EditBox(this.f_96547_, this.contentX + inputX, 70 + playerDetectYRel, inputWidth, 20, (Component)Component.m_237113_((String)"Detection Method"));
        this.playerNameDetectionInput.m_94144_(this.config.playerNameDetectionMethod != null ? this.config.playerNameDetectionMethod : "");
        this.bindSuggestion(this.playerNameDetectionInput, "playername here");
        this.m_142416_((GuiEventListener)this.playerNameDetectionInput);
        this.contentWidgets.put((Widget)this.playerNameDetectionInput, new WidgetPos(inputX, playerDetectYRel));
        this.occupyBand(playerDetectYRel, 20);
        yRel = playerDetectYRel + 20 + 10 + 6;
        yRel = this.nextClearY(yRel, 12);
        this.addSectionLabel("Colour:", yRel);
        this.colourSectionTopRel = yRel;
        this.occupyBand(yRel, 12);
        yRel += 16;
        yRel = this.nextClearY(yRel, 12);
        this.addSectionLabel("Self Colour:", yRel);
        this.occupyBand(yRel, 12);
        int controlsYRel = this.nextClearY(yRel += 16, 20);
        int pickSelfBtnRelX = 320;
        Button pickSelfBtn = (Button)this.m_142416_((GuiEventListener)new Button(this.contentX + pickSelfBtnRelX, 70 + controlsYRel, 50, 20, (Component)Component.m_237113_((String)"Pick"), btn -> this.openColourPickerForSelf()));
        this.contentWidgets.put((Widget)pickSelfBtn, new WidgetPos(pickSelfBtnRelX, controlsYRel));
        this.selfToggleRelX = 10;
        this.selfToggleRelY = controlsYRel;
        this.selfPreviewRelX = this.selfToggleRelX + 60;
        this.selfPreviewRelY = controlsYRel;
        this.occupyBand(controlsYRel, 20);
        yRel = controlsYRel + 20 + 10;
        yRel = this.nextClearY(yRel, 12);
        this.addSectionLabel("Friends:", yRel);
        this.occupyBand(yRel, 12);
        this.friendToggleRelX = 10;
        this.friendToggleRelY = friendsToggleYRel = this.nextClearY(yRel += 16, 20);
        this.occupyBand(friendsToggleYRel, 20);
        yRel = friendsToggleYRel + 20 + 6;
        this.friendAddRelY = this.nextClearY(yRel, 20);
        int friendInputWidth = 292;
        friendInputWidth = Math.max(friendInputWidth, 80);
        this.friendNameInput = new EditBox(this.f_96547_, this.contentX + 10, 70 + this.friendAddRelY, friendInputWidth, 20, (Component)Component.m_237113_((String)"Friend Name"));
        this.friendNameInput.m_94144_("");
        this.m_142416_((GuiEventListener)this.friendNameInput);
        this.contentWidgets.put((Widget)this.friendNameInput, new WidgetPos(10, this.friendAddRelY));
        this.relNewFriendPreviewX = 308;
        this.addFriendButton = (Button)this.m_142416_((GuiEventListener)new Button(this.contentX + 380 - 10 - 40, 70 + this.friendAddRelY, 40, 20, (Component)Component.m_237113_((String)"Add"), btn -> this.addFriendFromInput()));
        this.contentWidgets.put((Widget)this.addFriendButton, new WidgetPos(330, this.friendAddRelY));
        this.occupyBand(this.friendAddRelY, 20);
        int friendRowRelY = yRel = this.friendAddRelY + 20 + 10;
        Map<String, Config.FriendConfig> friendsMap = this.config.friends;
        if (friendsMap != null) {
            for (String friendName : friendsMap.keySet()) {
                Config.FriendConfig friendCfg = friendsMap.get(friendName);
                int rowY = this.nextClearY(friendRowRelY, 20);
                FriendListItem item = new FriendListItem(friendName, friendCfg.colour, 10, rowY, 360);
                this.friendListItems.add(item);
                this.occupyBand(rowY, 20);
                friendRowRelY = rowY + 20 + 6;
            }
        }
        yRel = friendRowRelY + 10;
        yRel = this.nextClearY(yRel, 12);
        this.addSectionLabel("Base Colour (Override):", yRel);
        this.occupyBand(yRel, 12);
        int pickBaseBtnRelX = 320;
        int baseControlsYRel = this.nextClearY(yRel += 16, 20);
        Button pickBaseBtn = (Button)this.m_142416_((GuiEventListener)new Button(this.contentX + pickBaseBtnRelX, 70 + baseControlsYRel, 50, 20, (Component)Component.m_237113_((String)"Pick"), btn -> this.openColourPickerForBase()));
        this.contentWidgets.put((Widget)pickBaseBtn, new WidgetPos(pickBaseBtnRelX, baseControlsYRel));
        this.baseToggleRelX = 10;
        this.baseToggleRelY = baseControlsYRel;
        this.basePreviewRelX = this.baseToggleRelX + 60;
        this.basePreviewRelY = baseControlsYRel;
        this.occupyBand(baseControlsYRel, 20);
        this.colourSectionBottomRel = yRel = baseControlsYRel + 20 + 10;
        this.ignoreSectionTopRel = yRel = this.colourSectionBottomRel + 16;
        this.addSectionLabel("Ignore:", yRel);
        this.occupyBand(yRel, 12);
        yRel += 16;
        int descChars = Math.max(10, 60);
        String desc1 = "Blacklist: ignore everyone except players in the list.";
        String desc2 = "Whitelist: only ignore players in the list.";
        for (String ln : this.wrapText(desc1, descChars)) {
            dY = this.nextClearY(yRel, 12);
            this.occupyBand(dY, 12);
            yRel = dY + 12 + 4;
        }
        for (String ln : this.wrapText(desc2, descChars)) {
            dY = this.nextClearY(yRel, 12);
            this.occupyBand(dY, 12);
            yRel = dY + 12 + 4;
        }
        this.ignoreToggleRelX = 10;
        this.ignoreToggleRelY = ignoreControlsY = this.nextClearY(yRel, 20);
        this.ignoreModeRelX = 260;
        this.ignoreModeRelY = ignoreControlsY;
        Button ignoreModeBtn = (Button)this.m_142416_((GuiEventListener)new Button(this.contentX + this.ignoreModeRelX, 70 + ignoreControlsY, 110, 20, (Component)Component.m_237113_((String)this.config.ignoreMode), btn -> {
            this.config.ignoreMode = "blacklist".equalsIgnoreCase(this.config.ignoreMode) ? "whitelist" : "blacklist";
            btn.m_93666_((Component)Component.m_237113_((String)this.config.ignoreMode));
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
        }));
        this.contentWidgets.put((Widget)ignoreModeBtn, new WidgetPos(this.ignoreModeRelX, this.ignoreModeRelY));
        this.occupyBand(ignoreControlsY, 20);
        yRel = ignoreControlsY + 20 + 10;
        int ignoreInputWidth = 292;
        ignoreInputWidth = Math.max(ignoreInputWidth, 80);
        int ignoreInputY = this.nextClearY(yRel, 20);
        this.ignoreNameInput = new EditBox(this.f_96547_, this.contentX + 10, 70 + ignoreInputY, ignoreInputWidth, 20, (Component)Component.m_237113_((String)"Player to ignore/add"));
        this.ignoreNameInput.m_94144_("");
        this.m_142416_((GuiEventListener)this.ignoreNameInput);
        this.contentWidgets.put((Widget)this.ignoreNameInput, new WidgetPos(10, ignoreInputY));
        this.addIgnoreButton = (Button)this.m_142416_((GuiEventListener)new Button(this.contentX + 380 - 10 - 40, 70 + ignoreInputY, 40, 20, (Component)Component.m_237113_((String)"Add"), btn -> this.addIgnoreFromInput()));
        this.contentWidgets.put((Widget)this.addIgnoreButton, new WidgetPos(330, ignoreInputY));
        this.occupyBand(ignoreInputY, 20);
        this.ignoreListStartRelY = yRel = ignoreInputY + 20 + 10;
        if (this.config.ignoreList != null) {
            for (String name : this.config.ignoreList) {
                int rowY = this.nextClearY(yRel, 20);
                FriendListItem item = new FriendListItem(name, -1, 10, rowY, 360);
                this.ignoreListItems.add(item);
                this.occupyBand(rowY, 20);
                yRel = rowY + 20 + 6;
            }
        }
        yRel += 10;
        yRel = this.nextClearY(yRel, 12);
        this.addSectionLabel("Ignore Exceptions/Rules:", yRel);
        this.occupyBand(yRel, 12);
        int excTextW = 240;
        int charsPerRow = Math.max(10, excTextW / 6);
        this.exc1ToggleRelX = toggleXRight = 322;
        this.exc1ToggleRelY = exc1RowY = this.nextClearY(yRel += 16, Math.max(20, this.wrapText("Never ignore me or friends", charsPerRow).size() * 16));
        this.occupyBand(exc1RowY, 20);
        int c1Lines = this.wrapText("Never ignore me or friends", charsPerRow).size();
        yRel = exc1RowY + Math.max(20, c1Lines * 16) + 6;
        this.exc2ToggleRelX = toggleXRight;
        this.exc2ToggleRelY = exc2RowY = this.nextClearY(yRel, Math.max(20, this.wrapText("If my name comes first, don't ignore", charsPerRow).size() * 16));
        this.occupyBand(exc2RowY, 20);
        int c2Lines = this.wrapText("If my name comes first, don't ignore", charsPerRow).size();
        yRel = exc2RowY + Math.max(20, c2Lines * 16) + 6;
        this.exc3ToggleRelX = toggleXRight;
        this.exc3ToggleRelY = exc3RowY = this.nextClearY(yRel, Math.max(20, this.wrapText("If a friend's name comes first, don't ignore", charsPerRow).size() * 16));
        this.occupyBand(exc3RowY, 20);
        int c3Lines = this.wrapText("If a friend's name comes first, don't ignore", charsPerRow).size();
        this.ignoreSectionBottomRel = yRel = exc3RowY + Math.max(20, c3Lines * 16) + 10;
        this.encryptionSectionTopRel = yRel = this.ignoreSectionBottomRel + 16;
        this.addSectionLabel("Encryption:", yRel);
        this.occupyBand(yRel, 12);
        this.encSelfToggleRelX = 10;
        this.encSelfToggleRelY = encSelfRowY = this.nextClearY((yRel += 22) + 12 + 10, 20);
        this.occupyBand(encSelfRowY, 20);
        yRel = encSelfRowY + 20 + 12 + 10;
        int secretInputWidth = 360;
        int secretInputX = 10;
        int secretRowY = this.nextClearY(yRel, 20);
        this.selfSecretInput = new EditBox(this.f_96547_, this.contentX + secretInputX, 70 + secretRowY, secretInputWidth, 20, (Component)Component.m_237113_((String)"Secret"));
        this.selfSecretInput.m_94144_(this.config.selfSecret != null ? this.config.selfSecret : "itamioisbest123");
        this.bindSuggestion(this.selfSecretInput, "player-secret-here");
        this.m_142416_((GuiEventListener)this.selfSecretInput);
        this.contentWidgets.put((Widget)this.selfSecretInput, new WidgetPos(secretInputX, secretRowY));
        this.occupyBand(secretRowY, 20);
        yRel = secretRowY + 20 + 10 + 12 + 4;
        this.encSelfDecryptToggleRelX = 10;
        this.encSelfDecryptToggleRelY = selfDecRowY = this.nextClearY(yRel, 20);
        this.occupyBand(selfDecRowY, 20);
        yRel = selfDecRowY + 20 + 10 + 4;
        this.encFriendDecryptToggleRelX = 10;
        this.encFriendDecryptLabelRelY = friendDecLabelY = this.nextClearY(yRel, 12);
        this.occupyBand(friendDecLabelY, 12);
        this.encFriendDecryptToggleRelY = friendDecTogRowY = this.nextClearY(friendDecLabelY + 12 + 6, 20);
        this.occupyBand(friendDecTogRowY, 20);
        this.friendDecryptAddRelY = this.nextClearY(friendDecTogRowY + 20 + 12 + 10, 20);
        int friendDecNameW = Math.max(80, 130);
        this.friendDecryptNameInput = new EditBox(this.f_96547_, this.contentX + 10, 70 + this.friendDecryptAddRelY, friendDecNameW, 20, (Component)Component.m_237113_((String)"Friend Name"));
        this.friendDecryptNameInput.m_94144_("");
        this.bindSuggestion(this.friendDecryptNameInput, "playername here");
        this.m_142416_((GuiEventListener)this.friendDecryptNameInput);
        this.contentWidgets.put((Widget)this.friendDecryptNameInput, new WidgetPos(10, this.friendDecryptAddRelY));
        this.friendDecryptSecretInput = new EditBox(this.f_96547_, this.contentX + 10 + friendDecNameW + 6, 70 + this.friendDecryptAddRelY, 90, 20, (Component)Component.m_237113_((String)"Secret"));
        this.friendDecryptSecretInput.m_94144_("");
        this.bindSuggestion(this.friendDecryptSecretInput, "player-secret-here");
        this.m_142416_((GuiEventListener)this.friendDecryptSecretInput);
        this.contentWidgets.put((Widget)this.friendDecryptSecretInput, new WidgetPos(10 + friendDecNameW + 6, this.friendDecryptAddRelY));
        this.addFriendDecryptButton = (Button)this.m_142416_((GuiEventListener)new Button(this.contentX + 380 - 10 - 40, 70 + this.friendDecryptAddRelY, 40, 20, (Component)Component.m_237113_((String)"Add"), btn -> this.addFriendDecryptFromInput()));
        this.contentWidgets.put((Widget)this.addFriendDecryptButton, new WidgetPos(330, this.friendDecryptAddRelY));
        this.occupyBand(this.friendDecryptAddRelY, 20);
        yRel = this.friendDecryptAddRelY + 20 + 10;
        if (this.config.friendSecrets != null) {
            for (Map.Entry<String, String> e : this.config.friendSecrets.entrySet()) {
                int rowY = this.nextClearY(yRel, 20);
                FriendSecretItem item = new FriendSecretItem(e.getKey(), e.getValue(), 10, rowY, 360);
                this.friendDecryptItems.add(item);
                this.occupyBand(rowY, 20);
                yRel = rowY + 20 + 6;
            }
        }
        this.encryptionSectionBottomRel = yRel += 10;
        this.contentHeight = (yRel += 10) + 10;
        this.maxScroll = Math.max(0, this.contentHeight - (this.f_96544_ - 90));
        this.scrollOffset = ConfigScreen.clamp(this.scrollOffset, 0, this.maxScroll);
        this.updateWidgetPositions();
        this.scrollOffset = ConfigScreen.clamp(this.scrollOffset, 0, this.maxScroll);
    }

    private void addSectionLabel(String label, int yRel) {
    }

    private void drawSectionNotePlaceholder() {
    }

    private void openColourPickerForSelf() {
        Minecraft.m_91087_().m_91152_((Screen)new ColourPickerPopupScreen(this, this.config.selfColour | 0xFF000000, col -> {
            this.config.selfColour = col | 0xFF000000;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
        }));
    }

    private void openColourPickerForBase() {
        Minecraft.m_91087_().m_91152_((Screen)new ColourPickerPopupScreen(this, this.config.baseColour | 0xFF000000, col -> {
            this.config.baseColour = col | 0xFF000000;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
        }));
    }

    private void openKeyBindPopup() {
        Minecraft.m_91087_().m_91152_((Screen)new KeyBindPopupScreen(this, this.config.openKey, newKey -> {
            this.config.openKey = newKey;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
        }));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        int excRowStartY;
        this.contentX = (this.f_96543_ - 380) / 2;
        this.updateWidgetPositions();
        this.m_7333_(poseStack);
        IntUnaryOperator absX = relX -> this.contentX + relX;
        IntUnaryOperator absY = relY -> 70 + relY - this.scrollOffset;
        ConfigScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)(absY.applyAsInt(0) + 4), (int)0xFFFFFF);
        if (this.playerNameDetectionInput != null) {
            String val = this.playerNameDetectionInput.m_94155_();
            if (val == null) {
                val = "";
            }
            if (!val.equals(this.config.playerNameDetectionMethod) && !val.equals(this.lastPersistedDetection)) {
                this.config.playerNameDetectionMethod = val;
                this.lastPersistedDetection = val;
                ConfigManager.setConfig(this.config);
                ChatHistory.requestRefresh();
            }
        }
        int yRel = 30;
        yRel = this.resolveLineY(yRel);
        ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Key Bind:", (int)absX.applyAsInt(10), (int)absY.applyAsInt(yRel), (int)0xAAAAAA);
        yRel += 16;
        yRel += 30;
        yRel = this.resolveLineY(yRel);
        ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Player Name Detection:", (int)absX.applyAsInt(10), (int)absY.applyAsInt(yRel), (int)0xAAAAAA);
        yRel += 20;
        yRel += 36;
        int colourLabelAbsY = absY.applyAsInt(this.colourSectionTopRel);
        this.drawBoldString(poseStack, "Colour:", absX.applyAsInt(10), colourLabelAbsY, 0xFFFFFF);
        yRel = this.colourSectionTopRel;
        int boxLeft = absX.applyAsInt(6);
        int boxTop = absY.applyAsInt(this.colourSectionTopRel) - 4;
        int boxRight = absX.applyAsInt(374);
        int boxBottom = absY.applyAsInt(this.colourSectionBottomRel + 2);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)boxLeft, (int)boxTop, (int)boxRight, (int)(boxTop + 1), (int)-1);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)boxLeft, (int)boxTop, (int)(boxLeft + 1), (int)boxBottom, (int)-1);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(boxRight - 1), (int)boxTop, (int)boxRight, (int)boxBottom, (int)-1);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)boxLeft, (int)(boxBottom - 1), (int)boxRight, (int)boxBottom, (int)-1);
        yRel += 16;
        yRel = this.resolveLineY(yRel);
        ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Self Colour:", (int)absX.applyAsInt(10), (int)absY.applyAsInt(yRel), (int)0xAAAAAA);
        yRel += 16;
        int toggleX = absX.applyAsInt(this.selfToggleRelX);
        int toggleY = absY.applyAsInt(this.selfToggleRelY);
        int toggleW = 48;
        boolean selfEnabled = this.config.selfColourEnabled;
        int toggleBg = selfEnabled ? -13710223 : -11184811;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)toggleX, (int)toggleY, (int)(toggleX + toggleW), (int)(toggleY + 20), (int)toggleBg);
        ConfigScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)(selfEnabled ? "ON" : "OFF"), (int)(toggleX + toggleW / 2), (int)(toggleY + 4), (int)0xFFFFFF);
        int previewX = absX.applyAsInt(this.selfPreviewRelX);
        int previewY = absY.applyAsInt(this.selfPreviewRelY) + 1;
        int selfColourRgb = this.config.selfColour != 0 ? this.config.selfColour | 0xFF000000 : -1;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(previewX - 1), (int)(previewY - 1), (int)(previewX + 18 + 1), (int)(previewY + 18 + 1), (int)-16777216);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)previewX, (int)previewY, (int)(previewX + 18), (int)(previewY + 18), (int)selfColourRgb);
        int sepLeft = absX.applyAsInt(10);
        int sepRight = absX.applyAsInt(370);
        int sepY = absY.applyAsInt(this.selfToggleRelY + 20 + 2);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)sepLeft, (int)sepY, (int)sepRight, (int)(sepY + 1), (int)-10066330);
        yRel += 30;
        yRel = this.resolveLineY(yRel);
        ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Friends:", (int)absX.applyAsInt(10), (int)absY.applyAsInt(yRel), (int)0xAAAAAA);
        yRel += 16;
        int fToggleX = absX.applyAsInt(this.friendToggleRelX);
        int fToggleY = absY.applyAsInt(this.friendToggleRelY);
        int fToggleW = 48;
        boolean friendsEnabled = this.config.friendColourEnabled;
        int fToggleBg = friendsEnabled ? -13710223 : -11184811;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)fToggleX, (int)fToggleY, (int)(fToggleX + fToggleW), (int)(fToggleY + 20), (int)fToggleBg);
        ConfigScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)(friendsEnabled ? "ON" : "OFF"), (int)(fToggleX + fToggleW / 2), (int)(fToggleY + 4), (int)0xFFFFFF);
        yRel += 26;
        int friendPreviewX = absX.applyAsInt(this.relNewFriendPreviewX);
        int friendPreviewY = absY.applyAsInt(this.friendAddRelY) + 1;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(friendPreviewX - 1), (int)(friendPreviewY - 1), (int)(friendPreviewX + 18 + 1), (int)(friendPreviewY + 18 + 1), (int)-16777216);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)friendPreviewX, (int)friendPreviewY, (int)(friendPreviewX + 18), (int)(friendPreviewY + 18), (int)(this.newFriendColour | 0xFF000000));
        int sep2Left = absX.applyAsInt(10);
        int sep2Right = absX.applyAsInt(370);
        int sep2Y = absY.applyAsInt(this.friendAddRelY + 20 + 2);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)sep2Left, (int)sep2Y, (int)sep2Right, (int)(sep2Y + 1), (int)-10066330);
        yRel += 30;
        for (FriendListItem item : this.friendListItems) {
            int rowX = absX.applyAsInt(item.relX);
            int rowYLocal = absY.applyAsInt(item.relY);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(rowX - 1), (int)(rowYLocal - 1), (int)(rowX + 18 + 1), (int)(rowYLocal + 18 + 1), (int)-16777216);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)rowX, (int)rowYLocal, (int)(rowX + 18), (int)(rowYLocal + 18), (int)(item.colour | 0xFF000000));
            ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)item.name, (int)(rowX + 18 + 6), (int)(rowYLocal + 4), (int)0xFFFFFF);
            int delX = rowX + item.width - 20;
            ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"-", (int)delX, (int)(rowYLocal + 4), (int)0xFF5555);
        }
        ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Base Colour (Override):", (int)absX.applyAsInt(10), (int)absY.applyAsInt(yRel += this.friendListItems.size() * 26 + 10), (int)0xAAAAAA);
        yRel += 16;
        int bToggleX = absX.applyAsInt(this.baseToggleRelX);
        int bToggleY = absY.applyAsInt(this.baseToggleRelY);
        int bToggleW = 48;
        boolean baseEnabled = this.config.baseColourEnabled;
        int baseBg = baseEnabled ? -13710223 : -11184811;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)bToggleX, (int)bToggleY, (int)(bToggleX + bToggleW), (int)(bToggleY + 20), (int)baseBg);
        ConfigScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)(baseEnabled ? "ON" : "OFF"), (int)(bToggleX + bToggleW / 2), (int)(bToggleY + 4), (int)0xFFFFFF);
        int basePreviewX = absX.applyAsInt(this.basePreviewRelX);
        int basePreviewY = absY.applyAsInt(this.basePreviewRelY) + 1;
        int baseColourRgb = this.config.baseColour != 0 ? this.config.baseColour | 0xFF000000 : -5592406;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(basePreviewX - 1), (int)(basePreviewY - 1), (int)(basePreviewX + 18 + 1), (int)(basePreviewY + 18 + 1), (int)-16777216);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)basePreviewX, (int)basePreviewY, (int)(basePreviewX + 18), (int)(basePreviewY + 18), (int)baseColourRgb);
        yRel += 30;
        int ignoreLabelAbsY = absY.applyAsInt(this.ignoreSectionTopRel);
        this.drawBoldString(poseStack, "Ignore:", absX.applyAsInt(10), ignoreLabelAbsY, 0xFFFFFF);
        yRel = this.ignoreSectionTopRel;
        if (this.ignoreSectionBottomRel > this.ignoreSectionTopRel) {
            int iboxLeft = absX.applyAsInt(6);
            int iboxTop = absY.applyAsInt(this.ignoreSectionTopRel) - 4;
            int iboxRight = absX.applyAsInt(374);
            int iboxBottom = absY.applyAsInt(this.ignoreSectionBottomRel + 2);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)iboxLeft, (int)iboxTop, (int)iboxRight, (int)(iboxTop + 1), (int)-1);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)iboxLeft, (int)iboxTop, (int)(iboxLeft + 1), (int)iboxBottom, (int)-1);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(iboxRight - 1), (int)iboxTop, (int)iboxRight, (int)iboxBottom, (int)-1);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)iboxLeft, (int)(iboxBottom - 1), (int)iboxRight, (int)iboxBottom, (int)-1);
        }
        yRel += 16;
        int descCharsRender = Math.max(10, 60);
        String descRender1 = "Blacklist: ignore everyone except players in the list.";
        String descRender2 = "Whitelist: only ignore players in the list.";
        for (String ln : this.wrapText(descRender1, descCharsRender)) {
            yRel = this.resolveLineY(yRel);
            ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)ln, (int)absX.applyAsInt(10), (int)absY.applyAsInt(yRel), (int)0xBBBBBB);
            yRel += 16;
        }
        for (String ln : this.wrapText(descRender2, descCharsRender)) {
            yRel = this.resolveLineY(yRel);
            ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)ln, (int)absX.applyAsInt(10), (int)absY.applyAsInt(yRel), (int)0xBBBBBB);
            yRel += 16;
        }
        int igTogX = absX.applyAsInt(this.ignoreToggleRelX);
        int igTogY = absY.applyAsInt(this.ignoreToggleRelY);
        int igTogW = 48;
        int igBg = this.config.ignoreEnabled ? -13710223 : -11184811;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)igTogX, (int)igTogY, (int)(igTogX + igTogW), (int)(igTogY + 20), (int)igBg);
        ConfigScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)(this.config.ignoreEnabled ? "ON" : "OFF"), (int)(igTogX + igTogW / 2), (int)(igTogY + 4), (int)0xFFFFFF);
        yRel += 30;
        yRel = this.resolveLineY(yRel);
        ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Ignore players list:", (int)absX.applyAsInt(10), (int)absY.applyAsInt(yRel), (int)0x888888);
        yRel += 16;
        for (FriendListItem item : this.ignoreListItems) {
            int rowX = absX.applyAsInt(item.relX);
            int rowYLocal = absY.applyAsInt(item.relY);
            ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)item.name, (int)(rowX + 6), (int)(rowYLocal + 4), (int)0xFFFFFF);
            int delX = rowX + item.width - 20;
            ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"-", (int)delX, (int)(rowYLocal + 4), (int)0xFF5555);
        }
        int excHeaderRelY = this.exc1ToggleRelY - 16;
        this.drawBoldString(poseStack, "Ignore Exceptions/Rules:", absX.applyAsInt(10), absY.applyAsInt(excHeaderRelY), 0xFFFFFF);
        int textW = 240;
        int charsPerRowRender = Math.max(10, textW / 6);
        int excRowY = excRowStartY = this.exc1ToggleRelY;
        int c1TextX = absX.applyAsInt(10);
        int c1TextY = absY.applyAsInt(this.exc1ToggleRelY + 4);
        ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Never ignore me or friends", (int)c1TextX, (int)c1TextY, (int)0xBBBBBB);
        int c1ToggleX = absX.applyAsInt(this.exc1ToggleRelX);
        int c1ToggleY = absY.applyAsInt(this.exc1ToggleRelY);
        int cToggleW = 48;
        int cToggleBg1 = this.config.ignoreExceptionsEnabled ? -13710223 : -11184811;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)c1ToggleX, (int)c1ToggleY, (int)(c1ToggleX + cToggleW), (int)(c1ToggleY + 20), (int)cToggleBg1);
        ConfigScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)(this.config.ignoreExceptionsEnabled ? "ON" : "OFF"), (int)(c1ToggleX + cToggleW / 2), (int)(c1ToggleY + 4), (int)0xFFFFFF);
        int c2TextX = absX.applyAsInt(10);
        int c2TextY = absY.applyAsInt(this.exc2ToggleRelY + 4);
        ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"If my name comes first, don't ignore", (int)c2TextX, (int)c2TextY, (int)0xBBBBBB);
        int c2ToggleX = absX.applyAsInt(this.exc2ToggleRelX);
        int c2ToggleY = absY.applyAsInt(this.exc2ToggleRelY);
        int cToggleBg2 = this.config.ignoreSelfFrontCheck ? -13710223 : -11184811;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)c2ToggleX, (int)c2ToggleY, (int)(c2ToggleX + cToggleW), (int)(c2ToggleY + 20), (int)cToggleBg2);
        ConfigScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)(this.config.ignoreSelfFrontCheck ? "ON" : "OFF"), (int)(c2ToggleX + cToggleW / 2), (int)(c2ToggleY + 4), (int)0xFFFFFF);
        int c3TextX = absX.applyAsInt(10);
        int c3TextY = absY.applyAsInt(this.exc3ToggleRelY + 4);
        ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"If a friend's name comes first, don't ignore", (int)c3TextX, (int)c3TextY, (int)0xBBBBBB);
        int c3ToggleX = absX.applyAsInt(this.exc3ToggleRelX);
        int c3ToggleY = absY.applyAsInt(this.exc3ToggleRelY);
        int cToggleBg3 = this.config.ignoreFriendsFrontCheck ? -13710223 : -11184811;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)c3ToggleX, (int)c3ToggleY, (int)(c3ToggleX + cToggleW), (int)(c3ToggleY + 20), (int)cToggleBg3);
        ConfigScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)(this.config.ignoreFriendsFrontCheck ? "ON" : "OFF"), (int)(c3ToggleX + cToggleW / 2), (int)(c3ToggleY + 4), (int)0xFFFFFF);
        int encTitleAbsY = absY.applyAsInt(this.encryptionSectionTopRel);
        this.drawBoldString(poseStack, "Encryption:", absX.applyAsInt(10), encTitleAbsY, 0xFFFFFF);
        if (this.encryptionSectionBottomRel > this.encryptionSectionTopRel) {
            int eboxLeft = absX.applyAsInt(6);
            int eboxTop = absY.applyAsInt(this.encryptionSectionTopRel) - 4;
            int eboxRight = absX.applyAsInt(374);
            int eboxBottom = absY.applyAsInt(this.encryptionSectionBottomRel + 2);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)eboxLeft, (int)eboxTop, (int)eboxRight, (int)(eboxTop + 1), (int)-1);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)eboxLeft, (int)eboxTop, (int)(eboxLeft + 1), (int)eboxBottom, (int)-1);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(eboxRight - 1), (int)eboxTop, (int)eboxRight, (int)eboxBottom, (int)-1);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)eboxLeft, (int)(eboxBottom - 1), (int)eboxRight, (int)eboxBottom, (int)-1);
        }
        int encLabelRelY = this.encSelfToggleRelY - 18;
        encLabelRelY = Math.max(encLabelRelY, this.encryptionSectionTopRel + 12 + 8);
        ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Self Message Encryption:", (int)absX.applyAsInt(10), (int)absY.applyAsInt(encLabelRelY), (int)0xAAAAAA);
        int encTogX = absX.applyAsInt(this.encSelfToggleRelX);
        int encTogY = absY.applyAsInt(this.encSelfToggleRelY);
        int encTogW = 48;
        int encBg = this.config.selfEncryptionEnabled ? -13710223 : -11184811;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)encTogX, (int)encTogY, (int)(encTogX + encTogW), (int)(encTogY + 20), (int)encBg);
        ConfigScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)(this.config.selfEncryptionEnabled ? "ON" : "OFF"), (int)(encTogX + encTogW / 2), (int)(encTogY + 4), (int)0xFFFFFF);
        int secretRowRelY = this.selfSecretInput != null && this.contentWidgets.containsKey(this.selfSecretInput) ? this.contentWidgets.get((Object)this.selfSecretInput).relY : this.encSelfToggleRelY + 20 + 12 + 10;
        int secretLabelRelY = secretRowRelY - 18;
        ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Secret:", (int)absX.applyAsInt(10), (int)absY.applyAsInt(secretLabelRelY), (int)0x888888);
        int decLabelRelY = this.encSelfDecryptToggleRelY - 18;
        ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Self Message Decryption:", (int)absX.applyAsInt(10), (int)absY.applyAsInt(decLabelRelY), (int)0xAAAAAA);
        int decTogX = absX.applyAsInt(this.encSelfDecryptToggleRelX);
        int decTogY = absY.applyAsInt(this.encSelfDecryptToggleRelY);
        int decTogW = 48;
        int decBg = this.config.selfDecryptionEnabled ? -13710223 : -11184811;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)decTogX, (int)decTogY, (int)(decTogX + decTogW), (int)(decTogY + 20), (int)decBg);
        ConfigScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)(this.config.selfDecryptionEnabled ? "ON" : "OFF"), (int)(decTogX + decTogW / 2), (int)(decTogY + 4), (int)0xFFFFFF);
        int fdecLabelRelY = this.encFriendDecryptLabelRelY;
        ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Friend Message Decryption:", (int)absX.applyAsInt(10), (int)absY.applyAsInt(fdecLabelRelY), (int)0xAAAAAA);
        int fdecTogX = absX.applyAsInt(this.encFriendDecryptToggleRelX);
        int fdecTogY = absY.applyAsInt(this.encFriendDecryptToggleRelY);
        int fdecTogW = 48;
        int fdecBg = this.config.friendDecryptionEnabled ? -13710223 : -11184811;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)fdecTogX, (int)fdecTogY, (int)(fdecTogX + fdecTogW), (int)(fdecTogY + 20), (int)fdecBg);
        ConfigScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)(this.config.friendDecryptionEnabled ? "ON" : "OFF"), (int)(fdecTogX + fdecTogW / 2), (int)(fdecTogY + 4), (int)0xFFFFFF);
        int friendDecLabelRelY = this.friendDecryptAddRelY - 20;
        ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Friend secrets (name -> secret):", (int)absX.applyAsInt(10), (int)absY.applyAsInt(friendDecLabelRelY), (int)0x888888);
        for (FriendSecretItem item : this.friendDecryptItems) {
            int rowX = absX.applyAsInt(item.relX);
            int rowYLocal = absY.applyAsInt(item.relY);
            ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)item.name, (int)(rowX + 6), (int)(rowYLocal + 4), (int)0xFFFFFF);
            ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)item.secret, (int)(rowX + 120), (int)(rowYLocal + 4), (int)0xBBBBBB);
            int delX = rowX + item.width - 20;
            ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"-", (int)delX, (int)(rowYLocal + 4), (int)0xFF5555);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private void updateWidgetPositions() {
        this.contentX = (this.f_96543_ - 380) / 2;
        for (Map.Entry<Widget, WidgetPos> e : this.contentWidgets.entrySet()) {
            Widget w = e.getKey();
            WidgetPos pos = e.getValue();
            int absX = this.contentX + pos.relX;
            int absY = 70 + pos.relY - this.scrollOffset;
            if (w instanceof Button) {
                Button b = (Button)w;
                b.f_93620_ = absX;
                b.f_93621_ = absY;
                continue;
            }
            if (!(w instanceof EditBox)) continue;
            EditBox ebox = (EditBox)w;
            ebox.f_93620_ = absX;
            ebox.f_93621_ = absY;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int fdecHitY;
        int decHitY;
        int encHitY;
        int c3ToggleY;
        int c2ToggleY;
        int c1ToggleY;
        int igTogY;
        int basePreviewY;
        int baseToggleY;
        int fToggleW;
        int fToggleY;
        int fPreviewY;
        int previewY;
        int toggleY;
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        this.contentX = (this.f_96543_ - 380) / 2;
        IntUnaryOperator absX = relX -> this.contentX + relX;
        IntUnaryOperator absY = relY -> 70 + relY - this.scrollOffset;
        int toggleX = absX.applyAsInt(this.selfToggleRelX);
        if (ConfigScreen.isWithin(mouseX, mouseY, toggleX, toggleY = absY.applyAsInt(this.selfToggleRelY), 48, 20)) {
            this.config.selfColourEnabled = !this.config.selfColourEnabled;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            this.m_7856_();
            return true;
        }
        int previewX = absX.applyAsInt(this.selfPreviewRelX);
        if (ConfigScreen.isWithin(mouseX, mouseY, previewX, previewY = absY.applyAsInt(this.selfPreviewRelY) + 1, 18, 18)) {
            Minecraft.m_91087_().m_91152_((Screen)new ColourPickerPopupScreen(this, this.config.selfColour | 0xFF000000, col -> {
                this.config.selfColour = col | 0xFF000000;
                ConfigManager.setConfig(this.config);
                ChatHistory.requestRefresh();
            }));
            return true;
        }
        int fPreviewX = absX.applyAsInt(this.relNewFriendPreviewX);
        if (ConfigScreen.isWithin(mouseX, mouseY, fPreviewX, (fPreviewY = absY.applyAsInt(this.friendAddRelY)) + 1, 18, 18)) {
            Minecraft.m_91087_().m_91152_((Screen)new ColourPickerPopupScreen(this, this.newFriendColour | 0xFF000000, col -> {
                this.newFriendColour = col | 0xFF000000;
            }));
            return true;
        }
        for (FriendListItem item : this.friendListItems) {
            int itemY;
            int itemX = absX.applyAsInt(item.relX);
            if (ConfigScreen.isWithin(mouseX, mouseY, itemX, itemY = absY.applyAsInt(item.relY), 18, 18)) {
                String fName = item.name;
                Minecraft.m_91087_().m_91152_((Screen)new ColourPickerPopupScreen(this, item.colour | 0xFF000000, col -> {
                    Config cfg = ConfigManager.getConfig();
                    if (cfg.friends.containsKey(fName)) {
                        cfg.friends.get((Object)fName).colour = col | 0xFF000000;
                        ConfigManager.setConfig(cfg);
                        ChatHistory.requestRefresh();
                    }
                }));
                return true;
            }
            int nameX = itemX + 18 + 6;
            int nameW = item.width - 18 - 30;
            if (ConfigScreen.isWithin(mouseX, mouseY, nameX, itemY, nameW, 20)) {
                String oldName = item.name;
                Minecraft.m_91087_().m_91152_((Screen)new NameEditPopupScreen(this, oldName, newName -> {
                    Config cfg = ConfigManager.getConfig();
                    if (cfg.friends.containsKey(oldName)) {
                        int col = cfg.friends.get((Object)oldName).colour;
                        cfg.updateFriend(oldName, (String)newName, col);
                        ConfigManager.setConfig(cfg);
                        ChatHistory.requestRefresh();
                    }
                    this.m_7856_();
                }));
                return true;
            }
            int delX = itemX + item.width - 20;
            if (!ConfigScreen.isWithin(mouseX, mouseY, delX, itemY, 16, 20)) continue;
            Config cfg = ConfigManager.getConfig();
            cfg.removeFriend(item.name);
            ConfigManager.setConfig(cfg);
            ChatHistory.requestRefresh();
            this.m_7856_();
            return true;
        }
        int fToggleX = absX.applyAsInt(this.friendToggleRelX);
        if (ConfigScreen.isWithin(mouseX, mouseY, fToggleX, fToggleY = absY.applyAsInt(this.friendToggleRelY), fToggleW = 48, 20)) {
            this.config.friendColourEnabled = !this.config.friendColourEnabled;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            this.m_7856_();
            return true;
        }
        int baseToggleX = absX.applyAsInt(this.baseToggleRelX);
        if (ConfigScreen.isWithin(mouseX, mouseY, baseToggleX, baseToggleY = absY.applyAsInt(this.baseToggleRelY), 48, 20)) {
            this.config.baseColourEnabled = !this.config.baseColourEnabled;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            this.m_7856_();
            return true;
        }
        int basePreviewX = absX.applyAsInt(this.basePreviewRelX);
        if (ConfigScreen.isWithin(mouseX, mouseY, basePreviewX, basePreviewY = absY.applyAsInt(this.basePreviewRelY) + 1, 18, 18)) {
            Minecraft.m_91087_().m_91152_((Screen)new ColourPickerPopupScreen(this, this.config.baseColour | 0xFF000000, col -> {
                this.config.baseColour = col | 0xFF000000;
                ConfigManager.setConfig(this.config);
                ChatHistory.requestRefresh();
            }));
            return true;
        }
        for (FriendListItem item : this.ignoreListItems) {
            int itemY;
            int itemX = absX.applyAsInt(item.relX);
            int delX = itemX + item.width - 20;
            if (!ConfigScreen.isWithin(mouseX, mouseY, delX, itemY = absY.applyAsInt(item.relY), 16, 20)) continue;
            Config cfg = ConfigManager.getConfig();
            cfg.removeIgnore(item.name);
            ConfigManager.setConfig(cfg);
            ChatHistory.requestRefresh();
            this.m_7856_();
            return true;
        }
        int igTogX = absX.applyAsInt(this.ignoreToggleRelX);
        if (ConfigScreen.isWithin(mouseX, mouseY, igTogX, igTogY = absY.applyAsInt(this.ignoreToggleRelY), 48, 20)) {
            this.config.ignoreEnabled = !this.config.ignoreEnabled;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            this.m_7856_();
            return true;
        }
        int c1ToggleX = absX.applyAsInt(this.exc1ToggleRelX);
        if (ConfigScreen.isWithin(mouseX, mouseY, c1ToggleX, c1ToggleY = absY.applyAsInt(this.exc1ToggleRelY), 48, 20)) {
            this.config.ignoreExceptionsEnabled = !this.config.ignoreExceptionsEnabled;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            this.m_7856_();
            return true;
        }
        int c2ToggleX = absX.applyAsInt(this.exc2ToggleRelX);
        if (ConfigScreen.isWithin(mouseX, mouseY, c2ToggleX, c2ToggleY = absY.applyAsInt(this.exc2ToggleRelY), 48, 20)) {
            this.config.ignoreSelfFrontCheck = !this.config.ignoreSelfFrontCheck;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            this.m_7856_();
            return true;
        }
        int c3ToggleX = absX.applyAsInt(this.exc3ToggleRelX);
        if (ConfigScreen.isWithin(mouseX, mouseY, c3ToggleX, c3ToggleY = absY.applyAsInt(this.exc3ToggleRelY), 48, 20)) {
            this.config.ignoreFriendsFrontCheck = !this.config.ignoreFriendsFrontCheck;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            this.m_7856_();
            return true;
        }
        int encHitX = absX.applyAsInt(this.encSelfToggleRelX);
        if (ConfigScreen.isWithin(mouseX, mouseY, encHitX, encHitY = absY.applyAsInt(this.encSelfToggleRelY), 48, 20)) {
            boolean bl = this.config.selfEncryptionEnabled = !this.config.selfEncryptionEnabled;
            if (this.selfSecretInput != null) {
                this.config.selfSecret = this.selfSecretInput.m_94155_();
            }
            ConfigManager.setConfig(this.config);
            return true;
        }
        int decHitX = absX.applyAsInt(this.encSelfDecryptToggleRelX);
        if (ConfigScreen.isWithin(mouseX, mouseY, decHitX, decHitY = absY.applyAsInt(this.encSelfDecryptToggleRelY), 48, 20)) {
            this.config.selfDecryptionEnabled = !this.config.selfDecryptionEnabled;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            return true;
        }
        int fdecHitX = absX.applyAsInt(this.encFriendDecryptToggleRelX);
        if (ConfigScreen.isWithin(mouseX, mouseY, fdecHitX, fdecHitY = absY.applyAsInt(this.encFriendDecryptToggleRelY), 48, 20)) {
            this.config.friendDecryptionEnabled = !this.config.friendDecryptionEnabled;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            return true;
        }
        for (FriendSecretItem item : this.friendDecryptItems) {
            int itemY;
            int itemX = absX.applyAsInt(item.relX);
            int delX = itemX + item.width - 20;
            if (!ConfigScreen.isWithin(mouseX, mouseY, delX, itemY = absY.applyAsInt(item.relY), 16, 20)) continue;
            Config cfg = ConfigManager.getConfig();
            cfg.removeFriendSecret(item.name);
            ConfigManager.setConfig(cfg);
            ChatHistory.requestRefresh();
            this.m_7856_();
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta == 0.0) {
            return false;
        }
        int step = (int)(delta * 20.0);
        this.scrollOffset = ConfigScreen.clamp(this.scrollOffset - step, 0, this.maxScroll);
        if (this.config != null) {
            this.config.lastConfigScroll = this.scrollOffset;
            ConfigManager.setConfig(this.config);
        }
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.persistScroll();
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(null);
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void addFriendFromInput() {
        if (this.friendNameInput != null && !this.friendNameInput.m_94155_().trim().isEmpty()) {
            String friendName = this.friendNameInput.m_94155_().trim();
            int colour = this.newFriendColour == 0 ? -1 : this.newFriendColour | 0xFF000000;
            this.config.addFriend(friendName, colour);
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            this.friendNameInput.m_94144_("");
            this.newFriendColour = -1;
            this.m_7856_();
        }
    }

    private void addIgnoreFromInput() {
        if (this.ignoreNameInput != null && !this.ignoreNameInput.m_94155_().trim().isEmpty()) {
            String name = this.ignoreNameInput.m_94155_().trim();
            this.config.addIgnore(name);
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            this.ignoreNameInput.m_94144_("");
            this.m_7856_();
        }
    }

    private void addFriendDecryptFromInput() {
        if (this.friendDecryptNameInput != null && !this.friendDecryptNameInput.m_94155_().trim().isEmpty()) {
            String name = this.friendDecryptNameInput.m_94155_().trim();
            String secret = "";
            if (this.friendDecryptSecretInput != null) {
                secret = this.friendDecryptSecretInput.m_94155_();
            }
            this.config.addFriendSecret(name, secret);
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            this.friendDecryptNameInput.m_94144_("");
            this.friendDecryptSecretInput.m_94144_("");
            this.bindSuggestion(this.friendDecryptNameInput, "playername here");
            this.bindSuggestion(this.friendDecryptSecretInput, "player-secret-here");
            this.m_7856_();
        }
    }

    private static boolean isWithin(double mx, double my, int x, int y, int w, int h) {
        return mx >= (double)x && mx <= (double)(x + w) && my >= (double)y && my <= (double)(y + h);
    }

    private void bindSuggestion(EditBox box, String placeholder) {
        if (box == null) {
            return;
        }
        box.m_94167_(box.m_94155_() == null || box.m_94155_().isEmpty() ? placeholder : null);
        box.m_94151_(val -> {
            if (val == null || val.isEmpty()) {
                box.m_94167_(placeholder);
            } else {
                box.m_94167_(null);
            }
        });
    }

    public void m_7379_() {
        this.persistScroll();
        super.m_7379_();
    }

    public void m_7861_() {
        this.persistScroll();
        super.m_7861_();
    }

    private void persistScroll() {
        if (this.config != null) {
            this.config.lastConfigScroll = ConfigScreen.clamp(this.scrollOffset, 0, this.maxScroll);
            ConfigManager.setConfig(this.config);
        }
    }

    private static int clamp(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    private List<String> wrapText(String text, int maxChars) {
        ArrayList<String> out = new ArrayList<String>();
        if (text == null || text.isEmpty()) {
            return out;
        }
        String[] parts = text.split("\\s+");
        StringBuilder curr = new StringBuilder();
        for (String p : parts) {
            if (curr.length() == 0) {
                curr.append(p);
                continue;
            }
            if (curr.length() + 1 + p.length() <= maxChars) {
                curr.append(" ").append(p);
                continue;
            }
            out.add(curr.toString());
            curr = new StringBuilder(p);
        }
        if (curr.length() > 0) {
            out.add(curr.toString());
        }
        return out;
    }

    private void drawBoldString(PoseStack poseStack, String text, int x, int y, int color) {
        ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)text, (int)x, (int)y, (int)color);
        ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)text, (int)(x + 1), (int)y, (int)color);
    }

    private int resolveLineY(int proposedRelY) {
        int n;
        if (this.f_96547_ != null) {
            Objects.requireNonNull(this.f_96547_);
            n = 9;
        } else {
            n = 12;
        }
        int h = Math.max(12, n);
        int y = proposedRelY;
        for (int guard = 0; guard < 50; ++guard) {
            boolean moved = false;
            for (Map.Entry<Widget, WidgetPos> e : this.contentWidgets.entrySet()) {
                WidgetPos pos = e.getValue();
                int wTop = pos.relY;
                int wBottom = pos.relY + 20;
                if (!ConfigScreen.rangesOverlap(y, y + h, wTop, wBottom)) continue;
                y = wBottom + 2;
                moved = true;
            }
            if (!moved) break;
        }
        return y;
    }

    private int nextClearY(int proposedRelY, int height) {
        int y = Math.max(0, proposedRelY);
        int h = Math.max(1, height);
        for (int guard = 0; guard < 100; ++guard) {
            boolean moved = false;
            for (Map.Entry<Widget, WidgetPos> e : this.contentWidgets.entrySet()) {
                WidgetPos pos = e.getValue();
                int wTop = pos.relY;
                int wBottom = pos.relY + 20;
                if (!ConfigScreen.rangesOverlap(y, y + h, wTop, wBottom)) continue;
                y = wBottom + 2;
                moved = true;
            }
            for (Band b : this.occupiedBands) {
                if (!ConfigScreen.rangesOverlap(y, y + h, b.top, b.bottom)) continue;
                y = b.bottom + 2;
                moved = true;
            }
            if (!moved) break;
        }
        return y;
    }

    private void occupyBand(int top, int height) {
        int h = Math.max(1, height);
        int t = Math.max(0, top);
        this.occupiedBands.add(new Band(t, t + h));
    }

    private static boolean rangesOverlap(int a1, int a2, int b1, int b2) {
        return Math.max(a1, b1) < Math.min(a2, b2);
    }

    private static class WidgetPos {
        public int relX;
        public int relY;

        public WidgetPos(int relX, int relY) {
            this.relX = relX;
            this.relY = relY;
        }
    }

    private static class FriendListItem {
        public String name;
        public int colour;
        public int relX;
        public int relY;
        public int width;

        public FriendListItem(String name, int colour, int relX, int relY, int width) {
            this.name = name;
            this.colour = colour;
            this.relX = relX;
            this.relY = relY;
            this.width = width;
        }
    }

    private static class FriendSecretItem {
        public String name;
        public String secret;
        public int relX;
        public int relY;
        public int width;

        public FriendSecretItem(String name, String secret, int relX, int relY, int width) {
            this.name = name;
            this.secret = secret;
            this.relX = relX;
            this.relY = relY;
            this.width = width;
        }
    }

    private static class Band {
        final int top;
        final int bottom;

        Band(int top, int bottom) {
            this.top = top;
            this.bottom = bottom;
        }
    }
}

