/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.util;

public class ColourUtil {
    public static int rgbToInt(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int getRed(int colour) {
        return colour >> 16 & 0xFF;
    }

    public static int getGreen(int colour) {
        return colour >> 8 & 0xFF;
    }

    public static int getBlue(int colour) {
        return colour & 0xFF;
    }

    public static String toHexString(int colour) {
        return String.format("%06X", colour & 0xFFFFFF);
    }

    public static int hexStringToInt(String hex) {
        try {
            return 0xFF000000 | Integer.parseInt(hex.replace("#", ""), 16);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static int fromHex(String hex) {
        try {
            String cleanHex = hex.replace("#", "").replace("0x", "");
            if (cleanHex.length() == 6) {
                return 0xFF000000 | Integer.parseInt(cleanHex, 16);
            }
            if (cleanHex.length() == 8) {
                return Integer.parseInt(cleanHex, 16);
            }
        }
        catch (NumberFormatException e) {
            return -1;
        }
        return -1;
    }

    public static float getBrightness(int colour) {
        int r = ColourUtil.getRed(colour);
        int g = ColourUtil.getGreen(colour);
        int b = ColourUtil.getBlue(colour);
        return ((float)r * 0.299f + (float)g * 0.587f + (float)b * 0.114f) / 255.0f;
    }

    public static int getContrastingColour(int colour) {
        return ColourUtil.getBrightness(colour) > 0.5f ? -16777216 : -1;
    }
}

