/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.EditBox;

public class ColourPickerWidget {
    private int x;
    private int y;
    private int width;
    private int height;
    private int currentColour;
    private EditBox hexInput;
    private Runnable onColourChanged;
    private float hue = 0.0f;
    private float saturation = 1.0f;
    private float brightness = 1.0f;
    private static final int PICKER_GRADIENT_WIDTH = 200;
    private static final int PICKER_GRADIENT_HEIGHT = 150;
    private static final int HUE_BAR_WIDTH = 20;
    private static final int PREVIEW_SIZE = 40;

    public ColourPickerWidget(int x, int y, int width, int height, int initialColour, Runnable onColourChanged) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.currentColour = initialColour;
        this.onColourChanged = onColourChanged;
        this.rgbToHsv(initialColour);
    }

    public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.drawColourGradient(poseStack, this.x, this.y, 200, 150);
        this.drawHueBar(poseStack, this.x + 200 + 10, this.y, 20, 150);
        ColourPickerWidget.fill(poseStack, this.x + 200 + 10 + 20 + 10, this.y, this.x + 200 + 10 + 20 + 10 + 40, this.y + 40, this.currentColour | 0xFF000000);
        ColourPickerWidget.fill(poseStack, this.x + 200 + 10 + 20 + 9, this.y - 1, this.x + 200 + 10 + 20 + 10 + 40 + 1, this.y + 40 + 1, -16777216);
    }

    private void drawColourGradient(PoseStack poseStack, int startX, int startY, int w, int h) {
        for (int px = 0; px < w; ++px) {
            float s = (float)px / (float)w;
            for (int py = 0; py < h; ++py) {
                float b = 1.0f - (float)py / (float)h;
                int colour = this.hsvToRgb(this.hue, s, b) | 0xFF000000;
                ColourPickerWidget.fill(poseStack, startX + px, startY + py, startX + px + 1, startY + py + 1, colour);
            }
        }
    }

    private void drawHueBar(PoseStack poseStack, int startX, int startY, int w, int h) {
        for (int py = 0; py < h; ++py) {
            float hueValue = (float)py / (float)h * 360.0f;
            int colour = this.hsvToRgb(hueValue, 1.0f, 1.0f) | 0xFF000000;
            ColourPickerWidget.fill(poseStack, startX, startY + py, startX + w, startY + py + 1, colour);
        }
    }

    private static void fill(PoseStack poseStack, int x1, int y1, int x2, int y2, int colour) {
        GuiComponent.m_93172_((PoseStack)poseStack, (int)x1, (int)y1, (int)x2, (int)y2, (int)colour);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (mouseX >= (double)this.x && mouseX <= (double)(this.x + 200) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 150)) {
                float s = (float)(mouseX - (double)this.x) / 200.0f;
                float b = 1.0f - (float)(mouseY - (double)this.y) / 150.0f;
                this.saturation = Math.max(0.0f, Math.min(1.0f, s));
                this.brightness = Math.max(0.0f, Math.min(1.0f, b));
                this.updateColour();
                return true;
            }
            if (mouseX >= (double)(this.x + 200 + 10) && mouseX <= (double)(this.x + 200 + 10 + 20) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 150)) {
                float hueValue;
                this.hue = hueValue = (float)(mouseY - (double)this.y) / 150.0f * 360.0f;
                this.updateColour();
                return true;
            }
        }
        return false;
    }

    private void updateColour() {
        this.currentColour = this.hsvToRgb(this.hue, this.saturation, this.brightness);
        if (this.onColourChanged != null) {
            this.onColourChanged.run();
        }
    }

    private void rgbToHsv(int colour) {
        float min;
        int r = colour >> 16 & 0xFF;
        float rf = (float)r / 255.0f;
        int g = colour >> 8 & 0xFF;
        float gf = (float)g / 255.0f;
        int b = colour & 0xFF;
        float bf = (float)b / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float delta = max - (min = Math.min(rf, Math.min(gf, bf)));
        this.hue = delta == 0.0f ? 0.0f : (max == rf ? (60.0f * ((gf - bf) / delta % 6.0f) + 360.0f) % 360.0f : (max == gf ? 60.0f * ((bf - rf) / delta + 2.0f) % 360.0f : 60.0f * ((rf - gf) / delta + 4.0f) % 360.0f));
        this.saturation = max == 0.0f ? 0.0f : delta / max;
        this.brightness = max;
    }

    private int hsvToRgb(float h, float s, float v) {
        float bf;
        float gf;
        float rf;
        float c = v * s;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        float m = v - c;
        if (h < 60.0f) {
            rf = c;
            gf = x;
            bf = 0.0f;
        } else if (h < 120.0f) {
            rf = x;
            gf = c;
            bf = 0.0f;
        } else if (h < 180.0f) {
            rf = 0.0f;
            gf = c;
            bf = x;
        } else if (h < 240.0f) {
            rf = 0.0f;
            gf = x;
            bf = c;
        } else if (h < 300.0f) {
            rf = x;
            gf = 0.0f;
            bf = c;
        } else {
            rf = c;
            gf = 0.0f;
            bf = x;
        }
        int r = Math.round((rf + m) * 255.0f);
        int g = Math.round((gf + m) * 255.0f);
        int b = Math.round((bf + m) * 255.0f);
        return r << 16 | g << 8 | b;
    }

    public int getColour() {
        return this.currentColour;
    }

    public void setColour(int colour) {
        this.currentColour = colour;
        this.rgbToHsv(colour);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }
}

