/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat;

import io.itamio.antiweakchat.config.ConfigManager;
import io.itamio.antiweakchat.event.ChatEventHandler;
import io.itamio.antiweakchat.event.ChatHistory;
import io.itamio.antiweakchat.event.ChatRenderHandler;
import io.itamio.antiweakchat.event.ConfigGuiOpener;
import io.itamio.antiweakchat.event.MessageTransformer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="antiweakchat", name="AntiWeakChat", version="1.0.0", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.8.9]")
public class AntiWeakChatMod {
    public static final String MODID = "antiweakchat";
    private static final Logger LOGGER = LogManager.getLogger((String)"antiweakchat");

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER.info("AntiWeakChat preInit");
        try {
            ConfigManager.loadConfig();
        }
        catch (Throwable t) {
            LOGGER.error("Failed to load config in preInit", t);
        }
        this.printLaunchBanner();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LOGGER.info("AntiWeakChat init");
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new ChatEventHandler());
            MinecraftForge.EVENT_BUS.register((Object)new MessageTransformer());
            MinecraftForge.EVENT_BUS.register((Object)new ChatHistory());
            MinecraftForge.EVENT_BUS.register((Object)new ConfigGuiOpener());
            MinecraftForge.EVENT_BUS.register((Object)new ChatRenderHandler());
        }
    }

    private void printLaunchBanner() {
        String title = "AntiWeakChat";
        String author = "Author: itamio";
        int innerWidth = Math.max(title.length(), author.length());
        String border = "+" + AntiWeakChatMod.repeat('-', innerWidth + 2) + "+";
        String line1 = "| " + AntiWeakChatMod.padRight(title, innerWidth) + " |";
        String line2 = "| " + AntiWeakChatMod.padRight(author, innerWidth) + " |";
        LOGGER.info(border);
        LOGGER.info(line1);
        LOGGER.info(line2);
        LOGGER.info(border);
    }

    private static String repeat(char c, int times) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    private static String padRight(String s, int n) {
        if (s == null) {
            s = "";
        }
        if (s.length() >= n) {
            return s;
        }
        StringBuilder b = new StringBuilder(s);
        while (b.length() < n) {
            b.append(' ');
        }
        return b.toString();
    }
}

