/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.itamio.antiweakchat.config.Config;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"antiweakchat");
    private static final String CONFIG_DIR = "config/antiweakchat";
    private static final String CONFIG_FILE = "config/antiweakchat/config.json";
    private static Config currentConfig;
    private static final Gson GSON;

    public static synchronized void loadConfig() {
        try {
            File f;
            File dir = new File(CONFIG_DIR);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if ((f = new File(CONFIG_FILE)).exists()) {
                FileReader fr = new FileReader(f);
                currentConfig = (Config)GSON.fromJson((Reader)fr, Config.class);
                fr.close();
                LOGGER.info("AntiWeakChat config loaded successfully");
            } else {
                currentConfig = new Config();
                ConfigManager.saveConfig();
                LOGGER.info("AntiWeakChat config created with defaults");
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load AntiWeakChat config", (Throwable)e);
            currentConfig = new Config();
        }
    }

    public static synchronized void saveConfig() {
        try {
            File dir = new File(CONFIG_DIR);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File f = new File(CONFIG_FILE);
            FileWriter writer = new FileWriter(f);
            GSON.toJson((Object)currentConfig, (Appendable)writer);
            writer.close();
            LOGGER.info("AntiWeakChat config saved successfully");
        }
        catch (IOException e) {
            LOGGER.error("Failed to save AntiWeakChat config", (Throwable)e);
        }
    }

    public static synchronized Config getConfig() {
        if (currentConfig == null) {
            ConfigManager.loadConfig();
        }
        return currentConfig;
    }

    public static synchronized void setConfig(Config cfg) {
        currentConfig = cfg;
        ConfigManager.saveConfig();
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

