/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.event;

import io.itamio.antiweakchat.config.Config;
import io.itamio.antiweakchat.config.ConfigManager;
import io.itamio.antiweakchat.crypto.EncryptionManager;
import io.itamio.antiweakchat.crypto.SelfEncryptionStore;
import io.itamio.antiweakchat.event.ConfigGuiOpener;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class ChatEventHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"antiweakchat");
    private static final String CONFIG_COMMAND = ".config-antiweakchat";

    @SubscribeEvent
    public void onGuiKeyboardPre(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        block16: {
            if (!(event.gui instanceof GuiChat)) {
                return;
            }
            if (!Keyboard.getEventKeyState()) {
                return;
            }
            int key = Keyboard.getEventKey();
            if (key != 28 && key != 156) {
                return;
            }
            String message = this.getGuiChatInput((GuiChat)event.gui);
            if (message == null) {
                return;
            }
            String trimmed = message.trim();
            if (CONFIG_COMMAND.equals(trimmed)) {
                try {
                    event.setCanceled(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ConfigGuiOpener.requestOpen();
                Minecraft mc = Minecraft.func_71410_x();
                if (mc != null) {
                    mc.func_147108_a(null);
                }
                LOGGER.info("AntiWeakChat: Intercepted config command; opening config GUI");
                return;
            }
            try {
                Config cfg = ConfigManager.getConfig();
                if (cfg == null || !cfg.selfEncryptionEnabled) break block16;
                if (message.startsWith("/") || message.startsWith(".")) {
                    return;
                }
                String secret = cfg.selfSecret != null ? cfg.selfSecret : "";
                String payload = EncryptionManager.encryptForSending(message, secret);
                if (payload != null) {
                    EncryptionManager.storeSelfMapping(payload, message);
                    SelfEncryptionStore.store(payload, message);
                    String wrapped = EncryptionManager.wrapPayload(payload);
                    try {
                        event.setCanceled(true);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Minecraft mc = Minecraft.func_71410_x();
                    if (mc != null && mc.field_71439_g != null) {
                        mc.field_71439_g.func_71165_d(wrapped);
                        mc.func_147108_a(null);
                        LOGGER.info("AntiWeakChat: Sent encrypted chat message");
                    } else {
                        LOGGER.warn("AntiWeakChat: No local player to send encrypted chat");
                    }
                    break block16;
                }
                LOGGER.warn("AntiWeakChat: Failed to encrypt outgoing message; letting vanilla send");
            }
            catch (Throwable t) {
                LOGGER.debug("AntiWeakChat: outgoing encryption failed", t);
            }
        }
    }

    private String getGuiChatInput(GuiChat chat) {
        try {
            Field[] fields;
            for (Field f : fields = chat.getClass().getDeclaredFields()) {
                try {
                    f.setAccessible(true);
                    Object val = f.get(chat);
                    if (!(val instanceof GuiTextField)) continue;
                    return ((GuiTextField)val).func_146179_b();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                Field f = chat.getClass().getDeclaredField("field_146415_a");
                f.setAccessible(true);
                Object val = f.get(chat);
                if (val instanceof GuiTextField) {
                    return ((GuiTextField)val).func_146179_b();
                }
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

