/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.event;

import io.itamio.antiweakchat.event.MessageTransformer;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class ChatHistory {
    private static final Logger LOGGER = LogManager.getLogger((String)"antiweakchat");
    private static final List<String> HISTORY = Collections.synchronizedList(new ArrayList());
    private static volatile boolean refreshRequested = false;
    private static volatile boolean renderRefreshPending = false;
    private static final int MAX_HISTORY = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRaw(IChatComponent original) {
        if (original == null) {
            return;
        }
        List<String> list = HISTORY;
        synchronized (list) {
            if (HISTORY.size() >= 1000) {
                HISTORY.remove(0);
            }
            try {
                HISTORY.add(original.func_150254_d());
            }
            catch (Throwable t) {
                HISTORY.add(original.func_150260_c());
            }
        }
    }

    public static void requestRefresh() {
        refreshRequested = true;
        renderRefreshPending = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getRecent(int max) {
        ArrayList<String> out = new ArrayList<String>();
        List<String> list = HISTORY;
        synchronized (list) {
            int from;
            int size = HISTORY.size();
            for (int i = from = Math.max(0, size - Math.max(1, max)); i < size; ++i) {
                out.add(HISTORY.get(i));
            }
        }
        return out;
    }

    public static void handleRenderEvent() {
        if (!renderRefreshPending) {
            return;
        }
        renderRefreshPending = false;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71456_v == null) {
            return;
        }
        try {
            ChatHistory.rebuildChat(mc);
        }
        catch (Exception e) {
            LOGGER.error("ChatHistory: rebuild on render failed", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!refreshRequested) {
            return;
        }
        refreshRequested = false;
        final Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71456_v == null) {
            return;
        }
        mc.func_152344_a(new Runnable(){

            @Override
            public void run() {
                ChatHistory.rebuildChat(mc);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rebuildChat(Minecraft mc) {
        try {
            GuiNewChat chatGUI = mc.field_71456_v.func_146158_b();
            if (chatGUI == null) {
                return;
            }
            boolean cleared = ChatHistory.clearChatComponent(chatGUI);
            if (!cleared) {
                LOGGER.debug("ChatHistory: couldn't clear chat; may duplicate messages on rebuild");
            } else {
                LOGGER.debug("ChatHistory: cleared chat component");
            }
            Method addMethod = ChatHistory.findAddMessageMethod(chatGUI.getClass());
            if (addMethod == null) {
                LOGGER.warn("ChatHistory: couldn't find method to add chat lines");
                return;
            }
            addMethod.setAccessible(true);
            List<String> list = HISTORY;
            synchronized (list) {
                for (String raw : HISTORY) {
                    try {
                        IChatComponent transformed;
                        String sender = MessageTransformer.extractSenderName(raw);
                        boolean shouldIgnore = false;
                        try {
                            shouldIgnore = MessageTransformer.shouldIgnoreMessage(raw, sender);
                        }
                        catch (Exception e) {
                            LOGGER.debug("ChatHistory: ignore check failed", (Throwable)e);
                        }
                        if (shouldIgnore) {
                            LOGGER.info("ChatHistory: skipping message due to ignore rules: '{}'", new Object[]{raw});
                            continue;
                        }
                        IChatComponent comp = MessageTransformer.applyDecryptionIfNeeded((IChatComponent)new ChatComponentText(raw), sender);
                        if (comp == null) {
                            comp = new ChatComponentText(raw);
                        }
                        if ((transformed = MessageTransformer.transformMessage(comp, sender)) == null) continue;
                        ChatHistory.invokeAddMethod(addMethod, chatGUI, transformed);
                    }
                    catch (Exception e) {
                        LOGGER.error("ChatHistory: failed to re-add message", (Throwable)e);
                    }
                }
            }
            LOGGER.info("ChatHistory: chat rebuilt with {} messages", new Object[]{HISTORY.size()});
        }
        catch (Exception e) {
            LOGGER.error("ChatHistory: rebuild failed", (Throwable)e);
        }
    }

    private static boolean clearChatComponent(Object chatGui) {
        if (chatGui == null) {
            return false;
        }
        boolean didClear = false;
        try {
            Method clear = null;
            try {
                clear = chatGui.getClass().getDeclaredMethod("clearChatMessages", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                try {
                    clear = chatGui.getClass().getDeclaredMethod("func_146237_a", new Class[0]);
                }
                catch (NoSuchMethodException ex2) {
                    clear = null;
                }
            }
            if (clear != null) {
                clear.setAccessible(true);
                clear.invoke(chatGui, new Object[0]);
                didClear = true;
            }
        }
        catch (Throwable clear) {
            // empty catch block
        }
        for (Class<?> cls = chatGui.getClass(); cls != null; cls = cls.getSuperclass()) {
            try {
                Field[] fields;
                for (Field f : fields = cls.getDeclaredFields()) {
                    f.setAccessible(true);
                    Object val = f.get(chatGui);
                    if (val instanceof Collection) {
                        ((Collection)val).clear();
                        didClear = true;
                        continue;
                    }
                    if (!(val instanceof Map)) continue;
                    ((Map)val).clear();
                    didClear = true;
                }
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return didClear;
    }

    private static Method findAddMessageMethod(Class<?> cls) {
        Class<?>[] params;
        for (Method m : cls.getMethods()) {
            String name;
            params = m.getParameterTypes();
            if (params.length != 1 || !IChatComponent.class.isAssignableFrom(params[0]) || !(name = m.getName().toLowerCase()).contains("print") && !name.contains("add") && !name.contains("chat")) continue;
            return m;
        }
        for (Method m : cls.getMethods()) {
            params = m.getParameterTypes();
            if (params.length < 1 || !IChatComponent.class.isAssignableFrom(params[0])) continue;
            return m;
        }
        return null;
    }

    private static void invokeAddMethod(Method method, Object target, IChatComponent component) throws Exception {
        int pc = method.getParameterCount();
        Object[] args = new Object[pc];
        boolean placed = false;
        for (int i = 0; i < pc; ++i) {
            Class<?> p = method.getParameterTypes()[i];
            if (!placed && IChatComponent.class.isAssignableFrom(p)) {
                args[i] = component;
                placed = true;
                continue;
            }
            args[i] = p == Integer.TYPE || p == Integer.class ? (Constable)Integer.valueOf(0) : (Constable)(p == Boolean.TYPE || p == Boolean.class ? Boolean.valueOf(false) : null);
        }
        method.setAccessible(true);
        method.invoke(target, args);
    }
}

