/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.event;

import io.itamio.antiweakchat.config.Config;
import io.itamio.antiweakchat.config.ConfigManager;
import io.itamio.antiweakchat.event.ChatHistory;
import io.itamio.antiweakchat.event.MessageTransformer;
import io.itamio.antiweakchat.util.ColourUtil;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class ChatRenderHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"antiweakchat");

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        try {
            if (event.type == RenderGameOverlayEvent.ElementType.CHAT) {
                ChatHistory.handleRenderEvent();
                if (event.isCancelable()) {
                    event.setCanceled(true);
                    ChatRenderHandler.renderCustomChat(Minecraft.func_71410_x());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void renderCustomChat(Minecraft mc) {
        if (mc == null || mc.field_71466_p == null) {
            return;
        }
        FontRenderer fr = mc.field_71466_p;
        ScaledResolution sr = new ScaledResolution(mc);
        int width = sr.func_78326_a();
        int height = sr.func_78328_b();
        int marginLeft = 2;
        int marginBottom = 30;
        int lineHeight = fr.field_78288_b + 2;
        int maxLines = 10;
        List<String> recent = ChatHistory.getRecent(maxLines);
        int y = height - marginBottom - lineHeight * recent.size();
        for (String raw : recent) {
            try {
                String sender = MessageTransformer.extractSenderName(raw);
                IChatComponent dec = MessageTransformer.applyDecryptionIfNeeded((IChatComponent)new ChatComponentText(raw), sender);
                if (dec == null) {
                    dec = new ChatComponentText(raw);
                }
                String text = dec.func_150260_c();
                int colour = ChatRenderHandler.resolveColour(text, sender);
                fr.func_175063_a(text, (float)marginLeft, (float)y, 0xFF000000 | colour & 0xFFFFFF);
            }
            catch (Throwable t) {
                fr.func_175063_a(raw, (float)marginLeft, (float)y, -1);
            }
            y += lineHeight;
        }
    }

    private static int resolveColour(String messageText, String senderName) {
        String detectionMethod;
        Config config = ConfigManager.getConfig();
        if (config == null) {
            return 0xFFFFFF;
        }
        String string = detectionMethod = config.playerNameDetectionMethod == null || config.playerNameDetectionMethod.isEmpty() ? "PLAYERNAME" : config.playerNameDetectionMethod;
        if (config.selfColourEnabled) {
            String local;
            if (senderName != null && ChatRenderHandler.isSelfMessage(senderName)) {
                return config.selfColour | 0xFF000000;
            }
            Minecraft mc = Minecraft.func_71410_x();
            String string2 = local = mc != null && mc.field_71439_g != null ? mc.field_71439_g.func_70005_c_() : null;
            if (local != null) {
                String patternStr = detectionMethod.replace("PLAYERNAME", Pattern.quote(local));
                if (Pattern.compile(".*" + patternStr + ".*", 2).matcher(messageText).matches()) {
                    return config.selfColour | 0xFF000000;
                }
            }
        }
        if (config.friendColourEnabled && config.friends != null) {
            for (Map.Entry<String, Config.FriendConfig> e : config.friends.entrySet()) {
                String friendName = e.getKey();
                int friendColour = e.getValue().colour;
                if (!ChatRenderHandler.matchesPlayerName(friendName, messageText, detectionMethod)) continue;
                return friendColour | 0xFF000000;
            }
        }
        if (config.baseColourEnabled) {
            return config.baseColour | 0xFF000000;
        }
        return 0xFFFFFF;
    }

    public static IChatComponent applyColouring(IChatComponent original, String senderName) {
        boolean matched;
        Config config = ConfigManager.getConfig();
        if (original == null || config == null) {
            return original;
        }
        String messageText = original.func_150260_c();
        LOGGER.debug("[ChatRenderHandler] applyColouring - message='{}', senderParam='{}'", new Object[]{messageText, senderName});
        String detectionMethod = config.playerNameDetectionMethod == null || config.playerNameDetectionMethod.isEmpty() ? "PLAYERNAME" : config.playerNameDetectionMethod;
        Function<Integer, IChatComponent> makeColoured = rgb -> {
            ChatComponentText t = new ChatComponentText(messageText);
            t.func_150256_b().func_150238_a(ColourUtil.rgbToEnumChatFormatting(rgb));
            return t;
        };
        if (config.selfColourEnabled) {
            if (senderName != null) {
                boolean isSelf = ChatRenderHandler.isSelfMessage(senderName);
                LOGGER.debug("[ChatRenderHandler] Sender-based self check: sender='{}' -> {}", new Object[]{senderName, isSelf});
                if (isSelf) {
                    return makeColoured.apply(config.selfColour);
                }
            } else {
                Minecraft mc = Minecraft.func_71410_x();
                String local = null;
                if (mc != null && mc.field_71439_g != null) {
                    local = mc.field_71439_g.func_70005_c_();
                }
                if (local != null) {
                    String patternStr = detectionMethod.replace("PLAYERNAME", Pattern.quote(local));
                    Pattern p = Pattern.compile(".*" + patternStr + ".*", 2);
                    matched = p.matcher(messageText).matches();
                    LOGGER.debug("[ChatRenderHandler] Detection-based self check matched={}", new Object[]{matched});
                    if (matched) {
                        return makeColoured.apply(config.selfColour);
                    }
                }
            }
        }
        if (config.friendColourEnabled && config.friends != null && !config.friends.isEmpty()) {
            for (Map.Entry<String, Config.FriendConfig> e : config.friends.entrySet()) {
                String friendName = e.getKey();
                int friendColour = e.getValue().colour;
                matched = ChatRenderHandler.matchesPlayerName(friendName, messageText, detectionMethod);
                LOGGER.debug("[ChatRenderHandler] Friend check '{}' -> matched={}", new Object[]{friendName, matched});
                if (!matched) continue;
                return makeColoured.apply(friendColour);
            }
        }
        if (config.baseColourEnabled) {
            return makeColoured.apply(config.baseColour);
        }
        return new ChatComponentText(messageText);
    }

    private static boolean isSelfMessage(String senderName) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc != null && mc.field_71439_g != null && senderName != null) {
            return mc.field_71439_g.func_70005_c_().equals(senderName);
        }
        return false;
    }

    private static boolean matchesPlayerName(String playerName, String messageText, String detectionMethod) {
        if (playerName == null) {
            return false;
        }
        String pattern = detectionMethod.replace("PLAYERNAME", Pattern.quote(playerName));
        Pattern namePattern = Pattern.compile(".*" + pattern + ".*", 2);
        return namePattern.matcher(messageText).matches();
    }

    public static IChatComponent createColouredComponent(IChatComponent original, int colour) {
        ChatComponentText t = new ChatComponentText(original.func_150260_c());
        t.func_150256_b().func_150238_a(ColourUtil.rgbToEnumChatFormatting(colour));
        return t;
    }
}

