/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.event;

import io.itamio.antiweakchat.config.Config;
import io.itamio.antiweakchat.config.ConfigManager;
import io.itamio.antiweakchat.screen.ConfigScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class ConfigGuiOpener {
    private static final Logger LOGGER = LogManager.getLogger((String)"antiweakchat");
    private static volatile boolean openRequested = false;
    private static boolean lastKeyDown = false;

    public static void requestOpen() {
        openRequested = true;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        final Minecraft mc = Minecraft.func_71410_x();
        if (mc == null) {
            return;
        }
        try {
            Config cfg = ConfigManager.getConfig();
            if (cfg == null) {
                return;
            }
            int keyCode = cfg.openKey;
            boolean isDown = Keyboard.isKeyDown((int)keyCode);
            if (isDown && !lastKeyDown) {
                mc.func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        if (mc.field_71462_r == null) {
                            LOGGER.info("AntiWeakChat: Keybind pressed - opening config screen");
                            mc.func_147108_a((GuiScreen)new ConfigScreen());
                        } else {
                            LOGGER.info("AntiWeakChat: Keybind pressed - closing current screen");
                            mc.func_147108_a(null);
                        }
                    }
                });
            }
            lastKeyDown = isDown;
        }
        catch (Throwable t) {
            LOGGER.debug("AntiWeakChat: keybind check failed", t);
        }
        if (!openRequested) {
            return;
        }
        openRequested = false;
        LOGGER.info("AntiWeakChat: Opening config screen (requested)");
        mc.func_152344_a(new Runnable(){

            @Override
            public void run() {
                try {
                    mc.func_147108_a((GuiScreen)new ConfigScreen());
                }
                catch (Throwable t) {
                    LOGGER.error("AntiWeakChat: Failed to open config screen", t);
                }
            }
        });
    }
}

