/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.event;

import io.itamio.antiweakchat.config.Config;
import io.itamio.antiweakchat.config.ConfigManager;
import io.itamio.antiweakchat.crypto.EncryptionManager;
import io.itamio.antiweakchat.crypto.SelfEncryptionStore;
import io.itamio.antiweakchat.event.ChatHistory;
import io.itamio.antiweakchat.event.ChatRenderHandler;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class MessageTransformer {
    private static final Logger LOGGER = LogManager.getLogger((String)"antiweakchat");
    private static final Pattern ENC_PATTERN = Pattern.compile("E\\[([A-Za-z0-9]+)\\]");

    @SubscribeEvent
    public void onClientChatReceived(ClientChatReceivedEvent event) {
        IChatComponent original = event.message;
        if (original == null) {
            return;
        }
        String rawText = original.func_150260_c();
        LOGGER.debug("[MessageTransformer] Received: '{}'", new Object[]{rawText});
        String senderName = MessageTransformer.extractSenderName(rawText);
        LOGGER.debug("[MessageTransformer] extractSenderName -> {}", new Object[]{senderName});
        try {
            ChatHistory.addRaw(original);
        }
        catch (Exception e) {
            LOGGER.debug("[MessageTransformer] Failed to add raw message", (Throwable)e);
        }
        try {
            if (MessageTransformer.shouldIgnoreMessage(rawText, senderName)) {
                LOGGER.info("[MessageTransformer] Ignoring message due to ignore rules: '{}'", new Object[]{rawText});
                event.setCanceled(true);
                return;
            }
        }
        catch (Exception e) {
            LOGGER.debug("[MessageTransformer] Error while checking ignore rules", (Throwable)e);
        }
        try {
            IChatComponent dec = MessageTransformer.applyDecryptionIfNeeded(original, senderName);
            if (dec != null && dec != original) {
                original = dec;
                rawText = original.func_150260_c();
                LOGGER.debug("[MessageTransformer] Decrypted message: '{}'", new Object[]{rawText});
            }
        }
        catch (Exception e) {
            LOGGER.debug("[MessageTransformer] Error during decryption", (Throwable)e);
        }
        IChatComponent transformed = MessageTransformer.transformMessage(original, senderName);
        if (transformed == null) {
            LOGGER.info("[MessageTransformer] Message suppressed by transform (null returned)");
            event.setCanceled(true);
            return;
        }
        if (transformed != original) {
            LOGGER.debug("[MessageTransformer] Message transformed");
            event.message = transformed;
        } else {
            LOGGER.debug("[MessageTransformer] No transformation applied");
        }
    }

    public static String extractSenderName(String rawText) {
        if (rawText == null) {
            return null;
        }
        String s = rawText.trim();
        try {
            int idx;
            String candidate;
            int end;
            if (s.startsWith("<") && (end = s.indexOf(62)) > 1 && end <= 17 && (candidate = s.substring(1, end).trim()).matches("[A-Za-z0-9_]{1,16}")) {
                return candidate;
            }
            int colon = s.indexOf(58);
            if (colon > 0 && colon <= 16 && (candidate = s.substring(0, colon).trim()).matches("[A-Za-z0-9_]{1,16}")) {
                return candidate;
            }
            Config cfg = ConfigManager.getConfig();
            String method = cfg == null || cfg.playerNameDetectionMethod == null || cfg.playerNameDetectionMethod.isEmpty() ? "PLAYERNAME" : cfg.playerNameDetectionMethod;
            String local = null;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc != null && mc.field_71439_g != null) {
                local = mc.field_71439_g.func_70005_c_();
            }
            if (local != null && (idx = MessageTransformer.indexOfDetection(method.replace("PLAYERNAME", local), s)) >= 0) {
                return local;
            }
            if (cfg != null && cfg.friends != null) {
                for (Map.Entry<String, Config.FriendConfig> e : cfg.friends.entrySet()) {
                    int idx2;
                    String friend = e.getKey();
                    if (friend == null || (idx2 = MessageTransformer.indexOfDetection(method.replace("PLAYERNAME", friend), s)) < 0) continue;
                    return friend;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean shouldIgnoreMessage(String rawText, String senderName) {
        boolean decision;
        String method;
        Config cfg = ConfigManager.getConfig();
        if (cfg == null || !cfg.ignoreEnabled) {
            return false;
        }
        String text = rawText == null ? "" : rawText;
        String string = method = cfg.playerNameDetectionMethod == null || cfg.playerNameDetectionMethod.isEmpty() ? "PLAYERNAME" : cfg.playerNameDetectionMethod;
        if (cfg.ignoreExceptionsEnabled && (MessageTransformer.containsSelf(text, method) || MessageTransformer.containsAnyFriend(text, method))) {
            return false;
        }
        boolean isBlacklist = "blacklist".equalsIgnoreCase(cfg.ignoreMode);
        boolean senderInList = senderName != null && cfg.ignoreList.contains(senderName);
        boolean anyIgnoreNamePresent = false;
        String firstIgnoreFound = null;
        int firstIgnoreIndex = Integer.MAX_VALUE;
        for (String name : cfg.ignoreList) {
            int idx;
            if (name == null || (idx = MessageTransformer.indexOfDetection(method.replace("PLAYERNAME", name), text)) < 0) continue;
            anyIgnoreNamePresent = true;
            if (idx >= firstIgnoreIndex) continue;
            firstIgnoreIndex = idx;
            firstIgnoreFound = name;
        }
        if (!isBlacklist) {
            decision = senderInList || anyIgnoreNamePresent;
        } else if (senderName != null) {
            decision = !senderInList;
        } else {
            boolean bl = decision = !anyIgnoreNamePresent;
        }
        if (decision) {
            try {
                if (cfg.ignoreSelfFrontCheck || cfg.ignoreFriendsFrontCheck) {
                    int ignoreIdx;
                    int selfIdx = cfg.ignoreSelfFrontCheck ? MessageTransformer.indexOfSelf(text, method) : -1;
                    int friendIdx = cfg.ignoreFriendsFrontCheck ? MessageTransformer.indexOfFirstFriend(text, method) : -1;
                    int n = ignoreIdx = firstIgnoreIndex == Integer.MAX_VALUE ? -1 : firstIgnoreIndex;
                    if (ignoreIdx >= 0) {
                        if (cfg.ignoreSelfFrontCheck && selfIdx >= 0 && selfIdx < ignoreIdx) {
                            decision = false;
                        } else if (cfg.ignoreFriendsFrontCheck && friendIdx >= 0 && friendIdx < ignoreIdx) {
                            decision = false;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return decision;
    }

    private static boolean containsSelf(String text, String method) {
        String local;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc != null && mc.field_71439_g != null && (local = mc.field_71439_g.func_70005_c_()) != null) {
            return MessageTransformer.indexOfDetection(method.replace("PLAYERNAME", local), text) >= 0;
        }
        return false;
    }

    private static int indexOfSelf(String text, String method) {
        String local;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc != null && mc.field_71439_g != null && (local = mc.field_71439_g.func_70005_c_()) != null) {
            return MessageTransformer.indexOfDetection(method.replace("PLAYERNAME", local), text);
        }
        return -1;
    }

    private static boolean containsAnyFriend(String text, String method) {
        Config cfg = ConfigManager.getConfig();
        if (cfg == null || cfg.friends == null) {
            return false;
        }
        for (Map.Entry<String, Config.FriendConfig> e : cfg.friends.entrySet()) {
            String name = e.getKey();
            if (name == null || MessageTransformer.indexOfDetection(method.replace("PLAYERNAME", name), text) < 0) continue;
            return true;
        }
        return false;
    }

    private static int indexOfFirstFriend(String text, String method) {
        Config cfg = ConfigManager.getConfig();
        if (cfg == null || cfg.friends == null) {
            return -1;
        }
        int best = Integer.MAX_VALUE;
        for (Map.Entry<String, Config.FriendConfig> e : cfg.friends.entrySet()) {
            int idx;
            String name = e.getKey();
            if (name == null || (idx = MessageTransformer.indexOfDetection(method.replace("PLAYERNAME", name), text)) < 0 || idx >= best) continue;
            best = idx;
        }
        return best == Integer.MAX_VALUE ? -1 : best;
    }

    private static int indexOfDetection(String literalPattern, String text) {
        if (literalPattern == null || text == null) {
            return -1;
        }
        String needle = literalPattern.toLowerCase();
        String hay = text.toLowerCase();
        return hay.indexOf(needle);
    }

    private static boolean isSelfMessage(String senderName) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc != null && mc.field_71439_g != null && senderName != null) {
            return mc.field_71439_g.func_70005_c_().equals(senderName);
        }
        return false;
    }

    public static IChatComponent applyDecryptionIfNeeded(IChatComponent original, String senderName) {
        if (original == null) {
            return null;
        }
        String text = original.func_150260_c();
        try {
            Matcher encMatcher = ENC_PATTERN.matcher(text);
            if (!encMatcher.find()) {
                return original;
            }
            Config cfg = ConfigManager.getConfig();
            StringBuffer sb = new StringBuffer();
            boolean replaced = false;
            do {
                String dec;
                String secret;
                String payload = encMatcher.group(1);
                String replacement = null;
                if (senderName != null && cfg != null && cfg.selfDecryptionEnabled && MessageTransformer.isSelfMessage(senderName)) {
                    String orig = SelfEncryptionStore.retrieve(payload);
                    if (orig == null) {
                        orig = EncryptionManager.getSelfOriginal(payload);
                    }
                    if (orig != null) {
                        replacement = orig;
                    }
                }
                if (replacement == null && senderName != null && cfg != null && cfg.friendDecryptionEnabled && cfg.friendSecrets != null && (secret = cfg.friendSecrets.get(senderName)) != null && !secret.isEmpty() && (dec = EncryptionManager.decrypt(payload, secret)) != null) {
                    replacement = dec;
                }
                if (replacement == null) {
                    replacement = encMatcher.group(0);
                } else {
                    replaced = true;
                }
                encMatcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
            } while (encMatcher.find());
            encMatcher.appendTail(sb);
            if (!replaced) {
                return original;
            }
            ChatComponentText newComponent = new ChatComponentText(sb.toString());
            return newComponent;
        }
        catch (Throwable t) {
            return original;
        }
    }

    public static IChatComponent transformMessage(IChatComponent original, String senderName) {
        return ChatRenderHandler.applyColouring(original, senderName);
    }
}

