/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.screen;

import java.io.IOException;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;

public class ColourPickerPopupScreen
extends GuiScreen {
    private final GuiScreen parent;
    private final Consumer<Integer> callback;
    private int initialColorARGB;
    private int hue = 0;
    private float sat = 1.0f;
    private float val = 1.0f;
    private float alpha = 1.0f;
    private int svX;
    private int svY;
    private int svSize;
    private int hueX;
    private int hueY;
    private int hueW;
    private int hueH;
    private int alphaX;
    private int alphaY;
    private int alphaW;
    private int alphaH;
    private int previewX;
    private int previewY;
    private GuiButton btnConfirm;
    private GuiButton btnCancel;

    public ColourPickerPopupScreen(GuiScreen parent, int initialColorARGB, Consumer<Integer> callback) {
        this.parent = parent;
        this.initialColorARGB = initialColorARGB;
        this.callback = callback;
        int a = initialColorARGB >> 24 & 0xFF;
        int r = initialColorARGB >> 16 & 0xFF;
        int g = initialColorARGB >> 8 & 0xFF;
        int b = initialColorARGB & 0xFF;
        float[] hsv = this.rgbToHsv(r, g, b);
        this.hue = Math.round(hsv[0] * 360.0f) % 360;
        this.sat = hsv[1];
        this.val = hsv[2];
        this.alpha = (float)a / 255.0f;
    }

    public void func_73866_w_() {
        int centerX = this.field_146294_l / 2;
        int centerY = this.field_146295_m / 2;
        this.svSize = Math.min(180, this.field_146295_m / 3);
        this.svX = centerX - this.svSize - 20;
        this.svY = centerY - this.svSize / 2;
        this.hueW = 16;
        this.hueH = this.svSize;
        this.hueX = this.svX + this.svSize + 8;
        this.hueY = this.svY;
        this.alphaW = this.svSize;
        this.alphaH = 12;
        this.alphaX = this.svX;
        this.alphaY = this.svY + this.svSize + 10;
        this.previewX = this.hueX + this.hueW + 12;
        this.previewY = this.svY;
        this.btnConfirm = new GuiButton(1, this.field_146294_l / 2 - 80, this.alphaY + this.alphaH + 20, 70, 20, "Confirm");
        this.btnCancel = new GuiButton(2, this.field_146294_l / 2 + 10, this.alphaY + this.alphaH + 20, 70, 20, "Cancel");
        this.field_146292_n.clear();
        this.field_146292_n.add(this.btnConfirm);
        this.field_146292_n.add(this.btnCancel);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, "Colour Picker", this.field_146294_l / 2, 8, 0xFFFFFF);
        for (int x = 0; x < this.svSize; ++x) {
            float s = (float)x / (float)Math.max(1, this.svSize - 1);
            for (int y = 0; y < this.svSize; ++y) {
                float v = 1.0f - (float)y / (float)Math.max(1, this.svSize - 1);
                int col = this.hsvToRgbInt(this.hue, s, v, 1.0f);
                ColourPickerPopupScreen.func_73734_a((int)(this.svX + x), (int)(this.svY + y), (int)(this.svX + x + 1), (int)(this.svY + y + 1), (int)col);
            }
        }
        ColourPickerPopupScreen.func_73734_a((int)(this.svX - 1), (int)(this.svY - 1), (int)(this.svX + this.svSize + 1), (int)this.svY, (int)-16777216);
        ColourPickerPopupScreen.func_73734_a((int)(this.svX - 1), (int)(this.svY - 1), (int)this.svX, (int)(this.svY + this.svSize + 1), (int)-16777216);
        ColourPickerPopupScreen.func_73734_a((int)(this.svX + this.svSize), (int)(this.svY - 1), (int)(this.svX + this.svSize + 1), (int)(this.svY + this.svSize + 1), (int)-16777216);
        ColourPickerPopupScreen.func_73734_a((int)(this.svX - 1), (int)(this.svY + this.svSize), (int)(this.svX + this.svSize + 1), (int)(this.svY + this.svSize + 1), (int)-16777216);
        for (int y = 0; y < this.hueH; ++y) {
            float h01 = (float)y / (float)Math.max(1, this.hueH - 1);
            int col = this.hsvToRgbInt(Math.round(h01 * 360.0f), 1.0f, 1.0f, 1.0f);
            ColourPickerPopupScreen.func_73734_a((int)this.hueX, (int)(this.hueY + y), (int)(this.hueX + this.hueW), (int)(this.hueY + y + 1), (int)col);
        }
        int checker = 6;
        for (int xx = 0; xx < this.alphaW; xx += checker) {
            for (int yy = 0; yy < this.alphaH; yy += checker) {
                int px = this.alphaX + xx;
                int py = this.alphaY + yy;
                int color = (xx / checker + yy / checker) % 2 == 0 ? -3355444 : -7829368;
                ColourPickerPopupScreen.func_73734_a((int)px, (int)py, (int)Math.min(px + checker, this.alphaX + this.alphaW), (int)Math.min(py + checker, this.alphaY + this.alphaH), (int)color);
            }
        }
        for (int x = 0; x < this.alphaW; ++x) {
            float aVal = (float)x / (float)Math.max(1, this.alphaW - 1);
            int overlay = this.hsvToRgbInt(this.hue, this.sat, this.val, aVal);
            ColourPickerPopupScreen.func_73734_a((int)(this.alphaX + x), (int)this.alphaY, (int)(this.alphaX + x + 1), (int)(this.alphaY + this.alphaH), (int)overlay);
        }
        int previewCol = this.hsvToRgbInt(this.hue, this.sat, this.val, this.alpha);
        ColourPickerPopupScreen.func_73734_a((int)(this.previewX - 1), (int)(this.previewY - 1), (int)(this.previewX + 48 + 1), (int)(this.previewY + 24 + 1), (int)-16777216);
        ColourPickerPopupScreen.func_73734_a((int)this.previewX, (int)this.previewY, (int)(this.previewX + 48), (int)(this.previewY + 24), (int)previewCol);
        int sx = this.svX + Math.round(this.sat * (float)(this.svSize - 1));
        int sy = this.svY + Math.round((1.0f - this.val) * (float)(this.svSize - 1));
        ColourPickerPopupScreen.func_73734_a((int)(sx - 3), (int)(sy - 3), (int)(sx + 4), (int)(sy + 4), (int)-16777216);
        ColourPickerPopupScreen.func_73734_a((int)(sx - 2), (int)(sy - 2), (int)(sx + 3), (int)(sy + 3), (int)-1);
        ColourPickerPopupScreen.func_73734_a((int)(sx - 1), (int)(sy - 1), (int)(sx + 2), (int)(sy + 2), (int)previewCol);
        int hy = this.hueY + Math.round((float)this.hue / 360.0f * (float)(this.hueH - 1));
        ColourPickerPopupScreen.func_73734_a((int)(this.hueX - 4), (int)(hy - 1), (int)(this.hueX + this.hueW + 4), (int)(hy + 2), (int)-16777216);
        ColourPickerPopupScreen.func_73734_a((int)(this.hueX - 3), (int)hy, (int)(this.hueX + this.hueW + 3), (int)(hy + 1), (int)-1);
        int ax = this.alphaX + Math.round(this.alpha * (float)(this.alphaW - 1));
        ColourPickerPopupScreen.func_73734_a((int)(ax - 1), (int)(this.alphaY - 4), (int)(ax + 2), (int)(this.alphaY + this.alphaH + 4), (int)-16777216);
        ColourPickerPopupScreen.func_73734_a((int)ax, (int)(this.alphaY - 3), (int)(ax + 1), (int)(this.alphaY + this.alphaH + 3), (int)-1);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private int hsvToRgbInt(float h, float s, float v, float a) {
        float c = v * s;
        float hf = h / 60.0f;
        float x = c * (1.0f - Math.abs(hf % 2.0f - 1.0f));
        float rf = 0.0f;
        float gf = 0.0f;
        float bf = 0.0f;
        if (0.0f <= hf && hf < 1.0f) {
            rf = c;
            gf = x;
            bf = 0.0f;
        } else if (1.0f <= hf && hf < 2.0f) {
            rf = x;
            gf = c;
            bf = 0.0f;
        } else if (2.0f <= hf && hf < 3.0f) {
            rf = 0.0f;
            gf = c;
            bf = x;
        } else if (3.0f <= hf && hf < 4.0f) {
            rf = 0.0f;
            gf = x;
            bf = c;
        } else if (4.0f <= hf && hf < 5.0f) {
            rf = x;
            gf = 0.0f;
            bf = c;
        } else {
            rf = c;
            gf = 0.0f;
            bf = x;
        }
        float m = v - c;
        int ir = Math.round((rf + m) * 255.0f);
        int ig = Math.round((gf + m) * 255.0f);
        int ib = Math.round((bf + m) * 255.0f);
        int ia = Math.round(a * 255.0f);
        return ia << 24 | ir << 16 | ig << 8 | ib;
    }

    private int hsvToRgbInt(int h, float s, float v, float a) {
        return this.hsvToRgbInt((float)h, s, v, a);
    }

    private float[] rgbToHsv(int r, int g, int b) {
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float min = Math.min(rf, Math.min(gf, bf));
        float d = max - min;
        float h = 0.0f;
        h = d == 0.0f ? 0.0f : (max == rf ? (gf - bf) / d % 6.0f : (max == gf ? (bf - rf) / d + 2.0f : (rf - gf) / d + 4.0f));
        if ((h /= 6.0f) < 0.0f) {
            h += 1.0f;
        }
        float s = max == 0.0f ? 0.0f : d / max;
        float v = max;
        return new float[]{h, s, v};
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            if (mouseX >= this.svX && mouseX <= this.svX + this.svSize && mouseY >= this.svY && mouseY <= this.svY + this.svSize) {
                float s = (float)(mouseX - this.svX) / (float)Math.max(1, this.svSize - 1);
                float v = 1.0f - (float)(mouseY - this.svY) / (float)Math.max(1, this.svSize - 1);
                this.sat = ColourPickerPopupScreen.clamp01(s);
                this.val = ColourPickerPopupScreen.clamp01(v);
            } else if (mouseX >= this.hueX && mouseX <= this.hueX + this.hueW && mouseY >= this.hueY && mouseY <= this.hueY + this.hueH) {
                float h01 = (float)(mouseY - this.hueY) / (float)Math.max(1, this.hueH - 1);
                this.hue = Math.round(h01 * 360.0f) % 360;
            } else if (mouseX >= this.alphaX && mouseX <= this.alphaX + this.alphaW && mouseY >= this.alphaY && mouseY <= this.alphaY + this.alphaH) {
                float a = (float)(mouseX - this.alphaX) / (float)Math.max(1, this.alphaW - 1);
                this.alpha = ColourPickerPopupScreen.clamp01(a);
            }
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 1) {
            int col = this.hsvToRgbInt(this.hue, this.sat, this.val, this.alpha);
            if (this.callback != null) {
                this.callback.accept(col);
            }
            Minecraft.func_71410_x().func_147108_a(this.parent);
        } else if (button.field_146127_k == 2) {
            Minecraft.func_71410_x().func_147108_a(this.parent);
        }
    }

    private static float clamp01(float v) {
        if (v < 0.0f) {
            return 0.0f;
        }
        if (v > 1.0f) {
            return 1.0f;
        }
        return v;
    }

    public boolean func_73868_f() {
        return false;
    }
}

