/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.screen;

import io.itamio.antiweakchat.config.Config;
import io.itamio.antiweakchat.config.ConfigManager;
import io.itamio.antiweakchat.event.ChatHistory;
import io.itamio.antiweakchat.screen.ColourPickerPopupScreen;
import io.itamio.antiweakchat.screen.KeyBindPopupScreen;
import io.itamio.antiweakchat.screen.NameEditPopupScreen;
import io.itamio.antiweakchat.util.KeybindUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntUnaryOperator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Mouse;

public class ConfigScreen
extends GuiScreen {
    private static final Logger LOGGER = LogManager.getLogger((String)"antiweakchat");
    private Config config;
    private static final int CONTENT_WIDTH = 380;
    private static final int PADDING = 10;
    private static final int LINE_HEIGHT = 20;
    private static final int LABEL_HEIGHT = 12;
    private static final int SECTION_SPACING = 10;
    private static final int SECTION_GAP = 16;
    private static final int PREVIEW_SIZE = 18;
    private static final int CONTENT_START_Y = 70;
    private static final int TITLE_BAR_HEIGHT = 30;
    private int scrollOffset = 0;
    private int contentHeight = 0;
    private int maxScroll = 0;
    private int contentX = 0;
    private final Map<Object, WidgetPos> contentWidgets = new LinkedHashMap<Object, WidgetPos>();
    private final List<Band> occupiedBands = new ArrayList<Band>();
    private GuiTextField playerNameDetectionInput;
    private GuiTextField friendNameInput;
    private GuiTextField ignoreNameInput;
    private GuiTextField selfSecretInput;
    private GuiTextField friendDecryptNameInput;
    private GuiTextField friendDecryptSecretInput;
    private GuiButton addFriendButton;
    private GuiButton addIgnoreButton;
    private GuiButton ignoreModeButton;
    private GuiButton addFriendDecryptButton;
    private final List<FriendListItem> friendListItems = new ArrayList<FriendListItem>();
    private final List<FriendListItem> ignoreListItems = new ArrayList<FriendListItem>();
    private final List<FriendSecretItem> friendDecryptItems = new ArrayList<FriendSecretItem>();
    private int newFriendColour = -1;
    private int selfToggleRelX;
    private int selfToggleRelY;
    private int selfPreviewRelX;
    private int selfPreviewRelY;
    private int friendToggleRelX;
    private int friendToggleRelY;
    private int relNewFriendPreviewX;
    private int friendAddRelY;
    private int baseToggleRelX;
    private int baseToggleRelY;
    private int basePreviewRelX;
    private int basePreviewRelY;
    private int ignoreToggleRelX;
    private int ignoreToggleRelY;
    private int ignoreModeRelX;
    private int ignoreModeRelY;
    private int ignoreSectionTopRel = 0;
    private int ignoreSectionBottomRel = 0;
    private int ignoreListStartRelY = 0;
    private int colourSectionTopRel = 0;
    private int colourSectionBottomRel = 0;
    private int exc1ToggleRelX;
    private int exc1ToggleRelY;
    private int exc2ToggleRelX;
    private int exc2ToggleRelY;
    private int exc3ToggleRelX;
    private int exc3ToggleRelY;
    private int encryptionSectionTopRel = 0;
    private int encryptionSectionBottomRel = 0;
    private int encSelfToggleRelX;
    private int encSelfToggleRelY;
    private int encSelfDecryptToggleRelX;
    private int encSelfDecryptToggleRelY;
    private int encFriendDecryptToggleRelX;
    private int encFriendDecryptToggleRelY;
    private int encFriendDecryptLabelRelY;
    private int friendDecryptAddRelY;
    private String lastPersistedDetection = null;
    protected final List<GuiTextField> textFieldList = new ArrayList<GuiTextField>();

    public ConfigScreen() {
        this.config = ConfigManager.getConfig();
        if (this.config == null) {
            this.config = new Config();
        }
        this.lastPersistedDetection = this.config.playerNameDetectionMethod;
    }

    public void func_73866_w_() {
        int friendDecTogRowY;
        int toggleXRight;
        int ignoreControlsY;
        this.field_146292_n.clear();
        this.textFieldList.clear();
        this.contentWidgets.clear();
        this.friendListItems.clear();
        this.ignoreListItems.clear();
        this.friendDecryptItems.clear();
        this.occupiedBands.clear();
        this.scrollOffset = Math.max(0, this.config.lastConfigScroll);
        this.contentX = (this.field_146294_l - 380) / 2;
        int yRel = 0;
        GuiButton closeBtn = new GuiButton(1, this.contentX + 10, 70 + yRel, 80, 20, "Close");
        this.field_146292_n.add(closeBtn);
        this.contentWidgets.put(closeBtn, new WidgetPos(10, yRel));
        this.occupyBand(yRel, 20);
        this.occupyBand(yRel, 30);
        yRel += 30;
        yRel = this.nextClearY(yRel, 12);
        this.occupyBand(yRel, 12);
        int keyBtnRelX = 10;
        int keyBtnYRel = this.nextClearY(yRel += 16, 20);
        GuiButton keyBindBtn = new GuiButton(400, this.contentX + keyBtnRelX, 70 + keyBtnYRel, 80, 20, KeybindUtil.getKeyName(this.config.openKey));
        this.field_146292_n.add(keyBindBtn);
        this.contentWidgets.put(keyBindBtn, new WidgetPos(keyBtnRelX, keyBtnYRel));
        this.occupyBand(keyBtnYRel, 20);
        yRel = keyBtnYRel + 20 + 10;
        yRel = this.nextClearY(yRel, 12);
        this.occupyBand(yRel, 12);
        int inputWidth = 180;
        int inputX = 10;
        int detectYRel = this.nextClearY(yRel += 20, 20);
        this.playerNameDetectionInput = new GuiTextField(101, this.field_146289_q, this.contentX + inputX, 70 + detectYRel, inputWidth, 20);
        this.playerNameDetectionInput.func_146180_a(this.config.playerNameDetectionMethod != null ? this.config.playerNameDetectionMethod : "");
        this.textFieldList.add(this.playerNameDetectionInput);
        this.contentWidgets.put(this.playerNameDetectionInput, new WidgetPos(inputX, detectYRel));
        this.occupyBand(detectYRel, 20);
        yRel = detectYRel + 20 + 10 + 6;
        this.colourSectionTopRel = yRel = this.nextClearY(yRel, 12);
        this.occupyBand(yRel, 12);
        yRel += 16;
        yRel = this.nextClearY(yRel, 12);
        this.occupyBand(yRel, 12);
        int controlsYRel = this.nextClearY(yRel += 16, 20);
        int pickSelfBtnRelX = 320;
        GuiButton pickSelf = new GuiButton(11, this.contentX + pickSelfBtnRelX, 70 + controlsYRel, 50, 20, "Pick");
        this.field_146292_n.add(pickSelf);
        this.contentWidgets.put(pickSelf, new WidgetPos(pickSelfBtnRelX, controlsYRel));
        this.selfToggleRelX = 10;
        this.selfToggleRelY = controlsYRel;
        this.selfPreviewRelX = this.selfToggleRelX + 60;
        this.selfPreviewRelY = controlsYRel;
        this.occupyBand(controlsYRel, 20);
        yRel = controlsYRel + 20 + 10;
        yRel = this.nextClearY(yRel, 12);
        this.occupyBand(yRel, 12);
        this.friendToggleRelX = 10;
        this.friendToggleRelY = this.nextClearY(yRel += 16, 20);
        this.occupyBand(this.friendToggleRelY, 20);
        yRel = this.friendToggleRelY + 20 + 6;
        this.friendAddRelY = this.nextClearY(yRel, 20);
        int friendInputWidth = 292;
        friendInputWidth = Math.max(friendInputWidth, 80);
        this.friendNameInput = new GuiTextField(102, this.field_146289_q, this.contentX + 10, 70 + this.friendAddRelY, friendInputWidth, 20);
        this.friendNameInput.func_146180_a("");
        this.textFieldList.add(this.friendNameInput);
        this.contentWidgets.put(this.friendNameInput, new WidgetPos(10, this.friendAddRelY));
        this.relNewFriendPreviewX = 308;
        this.addFriendButton = new GuiButton(100, this.contentX + 380 - 10 - 40, 70 + this.friendAddRelY, 40, 20, "Add");
        this.field_146292_n.add(this.addFriendButton);
        this.contentWidgets.put(this.addFriendButton, new WidgetPos(330, this.friendAddRelY));
        this.occupyBand(this.friendAddRelY, 20);
        int friendRowRelY = yRel = this.friendAddRelY + 20 + 10;
        if (this.config.friends != null) {
            for (String friendName : new ArrayList<String>(this.config.friends.keySet())) {
                Config.FriendConfig fcfg = this.config.friends.get(friendName);
                int rowY = this.nextClearY(friendRowRelY, 20);
                this.friendListItems.add(new FriendListItem(friendName, fcfg.colour, 10, rowY, 360));
                this.occupyBand(rowY, 20);
                friendRowRelY = rowY + 20 + 6;
            }
        }
        yRel = friendRowRelY + 10;
        yRel = this.nextClearY(yRel, 12);
        this.occupyBand(yRel, 12);
        int baseControlsYRel = this.nextClearY(yRel += 16, 20);
        int pickBaseBtnRelX = 320;
        GuiButton pickBase = new GuiButton(30, this.contentX + pickBaseBtnRelX, 70 + baseControlsYRel, 50, 20, "Pick");
        this.field_146292_n.add(pickBase);
        this.contentWidgets.put(pickBase, new WidgetPos(pickBaseBtnRelX, baseControlsYRel));
        this.baseToggleRelX = 10;
        this.baseToggleRelY = baseControlsYRel;
        this.basePreviewRelX = this.baseToggleRelX + 60;
        this.basePreviewRelY = baseControlsYRel;
        this.occupyBand(baseControlsYRel, 20);
        this.colourSectionBottomRel = yRel = baseControlsYRel + 20 + 10;
        this.ignoreSectionTopRel = yRel = this.colourSectionBottomRel + 16;
        this.occupyBand(yRel, 12);
        this.ignoreToggleRelX = 10;
        this.ignoreToggleRelY = ignoreControlsY = this.nextClearY(yRel += 16, 20);
        this.ignoreModeRelX = 260;
        this.ignoreModeRelY = ignoreControlsY;
        this.ignoreModeButton = new GuiButton(5, this.contentX + this.ignoreModeRelX, 70 + ignoreControlsY, 110, 20, this.config.ignoreMode);
        this.field_146292_n.add(this.ignoreModeButton);
        this.contentWidgets.put(this.ignoreModeButton, new WidgetPos(this.ignoreModeRelX, ignoreControlsY));
        this.occupyBand(ignoreControlsY, 20);
        yRel = ignoreControlsY + 20 + 10;
        int ignoreInputWidth = 292;
        int ignoreInputY = this.nextClearY(yRel, 20);
        this.ignoreNameInput = new GuiTextField(103, this.field_146289_q, this.contentX + 10, 70 + ignoreInputY, ignoreInputWidth, 20);
        this.ignoreNameInput.func_146180_a("");
        this.textFieldList.add(this.ignoreNameInput);
        this.contentWidgets.put(this.ignoreNameInput, new WidgetPos(10, ignoreInputY));
        this.addIgnoreButton = new GuiButton(200, this.contentX + 380 - 10 - 40, 70 + ignoreInputY, 40, 20, "Add");
        this.field_146292_n.add(this.addIgnoreButton);
        this.contentWidgets.put(this.addIgnoreButton, new WidgetPos(330, ignoreInputY));
        this.occupyBand(ignoreInputY, 20);
        this.ignoreListStartRelY = yRel = ignoreInputY + 20 + 10;
        if (this.config.ignoreList != null) {
            for (String name : this.config.ignoreList) {
                int rowY = this.nextClearY(yRel, 20);
                this.ignoreListItems.add(new FriendListItem(name, -1, 10, rowY, 360));
                this.occupyBand(rowY, 20);
                yRel = rowY + 20 + 6;
            }
        }
        yRel += 10;
        yRel = this.nextClearY(yRel, 12);
        this.occupyBand(yRel, 12);
        this.exc1ToggleRelX = toggleXRight = 322;
        this.exc1ToggleRelY = this.nextClearY(yRel += 16, 20);
        this.occupyBand(this.exc1ToggleRelY, 20);
        int c1Lines = 1;
        yRel = this.exc1ToggleRelY + Math.max(20, c1Lines * 16) + 6;
        this.exc2ToggleRelX = toggleXRight;
        this.exc2ToggleRelY = this.nextClearY(yRel, 20);
        this.occupyBand(this.exc2ToggleRelY, 20);
        yRel = this.exc2ToggleRelY + Math.max(20, 16) + 6;
        this.exc3ToggleRelX = toggleXRight;
        this.exc3ToggleRelY = this.nextClearY(yRel, 20);
        this.occupyBand(this.exc3ToggleRelY, 20);
        this.ignoreSectionBottomRel = yRel = this.exc3ToggleRelY + Math.max(20, 16) + 10;
        this.encryptionSectionTopRel = yRel = this.ignoreSectionBottomRel + 16;
        this.occupyBand(yRel, 12);
        this.encSelfToggleRelX = 10;
        this.encSelfToggleRelY = this.nextClearY((yRel += 22) + 12 + 10, 20);
        this.occupyBand(this.encSelfToggleRelY, 20);
        yRel = this.encSelfToggleRelY + 20 + 12 + 10;
        int secretInputWidth = 360;
        int secretRowY = this.nextClearY(yRel, 20);
        this.selfSecretInput = new GuiTextField(104, this.field_146289_q, this.contentX + 10, 70 + secretRowY, secretInputWidth, 20);
        this.selfSecretInput.func_146180_a(this.config.selfSecret != null ? this.config.selfSecret : "");
        this.textFieldList.add(this.selfSecretInput);
        this.contentWidgets.put(this.selfSecretInput, new WidgetPos(10, secretRowY));
        this.occupyBand(secretRowY, 20);
        yRel = secretRowY + 20 + 10 + 12 + 4;
        this.encSelfDecryptToggleRelX = 10;
        this.encSelfDecryptToggleRelY = this.nextClearY(yRel, 20);
        this.occupyBand(this.encSelfDecryptToggleRelY, 20);
        yRel = this.encSelfDecryptToggleRelY + 20 + 10 + 4;
        this.encFriendDecryptToggleRelX = 10;
        this.encFriendDecryptLabelRelY = this.nextClearY(yRel, 12);
        this.occupyBand(this.encFriendDecryptLabelRelY, 12);
        this.encFriendDecryptToggleRelY = friendDecTogRowY = this.nextClearY(this.encFriendDecryptLabelRelY + 12 + 6, 20);
        this.occupyBand(friendDecTogRowY, 20);
        this.friendDecryptAddRelY = this.nextClearY(friendDecTogRowY + 20 + 12 + 10, 20);
        int friendDecNameW = Math.max(80, 130);
        this.friendDecryptNameInput = new GuiTextField(105, this.field_146289_q, this.contentX + 10, 70 + this.friendDecryptAddRelY, friendDecNameW, 20);
        this.friendDecryptNameInput.func_146180_a("");
        this.textFieldList.add(this.friendDecryptNameInput);
        this.contentWidgets.put(this.friendDecryptNameInput, new WidgetPos(10, this.friendDecryptAddRelY));
        this.friendDecryptSecretInput = new GuiTextField(106, this.field_146289_q, this.contentX + 10 + friendDecNameW + 6, 70 + this.friendDecryptAddRelY, 90, 20);
        this.friendDecryptSecretInput.func_146180_a("");
        this.textFieldList.add(this.friendDecryptSecretInput);
        this.contentWidgets.put(this.friendDecryptSecretInput, new WidgetPos(10 + friendDecNameW + 6, this.friendDecryptAddRelY));
        this.addFriendDecryptButton = new GuiButton(600, this.contentX + 380 - 10 - 40, 70 + this.friendDecryptAddRelY, 40, 20, "Add");
        this.field_146292_n.add(this.addFriendDecryptButton);
        this.contentWidgets.put(this.addFriendDecryptButton, new WidgetPos(330, this.friendDecryptAddRelY));
        this.occupyBand(this.friendDecryptAddRelY, 20);
        yRel = this.friendDecryptAddRelY + 20 + 10;
        if (this.config.friendSecrets != null) {
            for (Map.Entry<String, String> e : this.config.friendSecrets.entrySet()) {
                int rowY = this.nextClearY(yRel, 20);
                this.friendDecryptItems.add(new FriendSecretItem(e.getKey(), e.getValue(), 10, rowY, 360));
                this.occupyBand(rowY, 20);
                yRel = rowY + 20 + 6;
            }
        }
        this.encryptionSectionBottomRel = yRel += 10;
        this.contentHeight = (yRel += 10) + 10;
        this.maxScroll = Math.max(0, this.contentHeight - (this.field_146295_m - 90));
        this.scrollOffset = ConfigScreen.clamp(this.scrollOffset, 0, this.maxScroll);
        this.updateWidgetPositions();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == null) {
            return;
        }
        int id = button.field_146127_k;
        if (id == 1) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        if (id == 400) {
            this.field_146297_k.func_147108_a((GuiScreen)new KeyBindPopupScreen(this, this.config.openKey, newKey -> {
                this.config.openKey = newKey;
                ConfigManager.setConfig(this.config);
                ChatHistory.requestRefresh();
                this.func_73866_w_();
            }));
            return;
        }
        if (id == 11) {
            this.field_146297_k.func_147108_a((GuiScreen)new ColourPickerPopupScreen(this, this.config.selfColour | 0xFF000000, col -> {
                this.config.selfColour = col | 0xFF000000;
                ConfigManager.setConfig(this.config);
                ChatHistory.requestRefresh();
                this.func_73866_w_();
            }));
            return;
        }
        if (id == 30) {
            this.field_146297_k.func_147108_a((GuiScreen)new ColourPickerPopupScreen(this, this.config.baseColour | 0xFF000000, col -> {
                this.config.baseColour = col | 0xFF000000;
                ConfigManager.setConfig(this.config);
                ChatHistory.requestRefresh();
                this.func_73866_w_();
            }));
            return;
        }
        if (id == 100) {
            this.addFriendFromInput();
            return;
        }
        if (id == 200) {
            this.addIgnoreFromInput();
            return;
        }
        if (id == 5) {
            this.config.ignoreMode = "blacklist".equalsIgnoreCase(this.config.ignoreMode) ? "whitelist" : "blacklist";
            button.field_146126_j = this.config.ignoreMode;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            this.func_73866_w_();
            return;
        }
        if (id == 600) {
            this.addFriendDecryptFromInput();
            return;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.updateWidgetPositions();
        int absTitleY = 70 - this.scrollOffset;
        this.func_73732_a(this.field_146289_q, "AntiWeakChat Config", this.field_146294_l / 2, absTitleY + 4, 0xFFFFFF);
        IntUnaryOperator absX = new IntUnaryOperator(){

            @Override
            public int applyAsInt(int relX) {
                return ConfigScreen.this.contentX + relX;
            }
        };
        IntUnaryOperator absY = new IntUnaryOperator(){

            @Override
            public int applyAsInt(int relY) {
                return 70 + relY - ConfigScreen.this.scrollOffset;
            }
        };
        int yRelCursor = 30;
        yRelCursor = this.resolveLineY(yRelCursor);
        this.func_73731_b(this.field_146289_q, "Key Bind:", absX.applyAsInt(10), absY.applyAsInt(yRelCursor), 0xAAAAAA);
        yRelCursor += 46;
        yRelCursor = this.resolveLineY(yRelCursor);
        this.func_73731_b(this.field_146289_q, "Player Name Detection:", absX.applyAsInt(10), absY.applyAsInt(yRelCursor), 0xAAAAAA);
        yRelCursor += 56;
        this.drawBoldString("Colour:", absX.applyAsInt(10), absY.applyAsInt(this.colourSectionTopRel), 0xFFFFFF);
        int boxLeft = absX.applyAsInt(6);
        int boxTop = absY.applyAsInt(this.colourSectionTopRel) - 4;
        int boxRight = absX.applyAsInt(374);
        int boxBottom = absY.applyAsInt(this.colourSectionBottomRel + 2);
        ConfigScreen.func_73734_a((int)boxLeft, (int)boxTop, (int)boxRight, (int)(boxTop + 1), (int)-1);
        ConfigScreen.func_73734_a((int)boxLeft, (int)boxTop, (int)(boxLeft + 1), (int)boxBottom, (int)-1);
        ConfigScreen.func_73734_a((int)(boxRight - 1), (int)boxTop, (int)boxRight, (int)boxBottom, (int)-1);
        ConfigScreen.func_73734_a((int)boxLeft, (int)(boxBottom - 1), (int)boxRight, (int)boxBottom, (int)-1);
        this.func_73731_b(this.field_146289_q, "Self Colour:", absX.applyAsInt(10), absY.applyAsInt(this.colourSectionTopRel + 12 + 4), 0xAAAAAA);
        int tX = absX.applyAsInt(this.selfToggleRelX);
        int tY = absY.applyAsInt(this.selfToggleRelY);
        int tW = 48;
        int tBg = this.config.selfColourEnabled ? -13710223 : -11184811;
        ConfigScreen.func_73734_a((int)tX, (int)tY, (int)(tX + tW), (int)(tY + 20), (int)tBg);
        this.func_73732_a(this.field_146289_q, this.config.selfColourEnabled ? "ON" : "OFF", tX + tW / 2, tY + 4, 0xFFFFFF);
        int pX = absX.applyAsInt(this.selfPreviewRelX);
        int pY = absY.applyAsInt(this.selfPreviewRelY) + 1;
        int selfCol = this.config.selfColour != 0 ? this.config.selfColour | 0xFF000000 : -1;
        ConfigScreen.func_73734_a((int)(pX - 1), (int)(pY - 1), (int)(pX + 18 + 1), (int)(pY + 18 + 1), (int)-16777216);
        ConfigScreen.func_73734_a((int)pX, (int)pY, (int)(pX + 18), (int)(pY + 18), (int)selfCol);
        this.func_73731_b(this.field_146289_q, "Friends:", absX.applyAsInt(10), absY.applyAsInt(this.friendToggleRelY - 16), 0xAAAAAA);
        int fTogX = absX.applyAsInt(this.friendToggleRelX);
        int fTogY = absY.applyAsInt(this.friendToggleRelY);
        int fBg = this.config.friendColourEnabled ? -13710223 : -11184811;
        ConfigScreen.func_73734_a((int)fTogX, (int)fTogY, (int)(fTogX + 48), (int)(fTogY + 20), (int)fBg);
        this.func_73732_a(this.field_146289_q, this.config.friendColourEnabled ? "ON" : "OFF", fTogX + 24, fTogY + 4, 0xFFFFFF);
        int fPrevX = absX.applyAsInt(this.relNewFriendPreviewX);
        int fPrevY = absY.applyAsInt(this.friendAddRelY) + 1;
        ConfigScreen.func_73734_a((int)(fPrevX - 1), (int)(fPrevY - 1), (int)(fPrevX + 18 + 1), (int)(fPrevY + 18 + 1), (int)-16777216);
        ConfigScreen.func_73734_a((int)fPrevX, (int)fPrevY, (int)(fPrevX + 18), (int)(fPrevY + 18), (int)(this.newFriendColour | 0xFF000000));
        for (FriendListItem item : this.friendListItems) {
            int rowX = absX.applyAsInt(item.relX);
            int rowY = absY.applyAsInt(item.relY);
            ConfigScreen.func_73734_a((int)(rowX - 1), (int)(rowY - 1), (int)(rowX + 18 + 1), (int)(rowY + 18 + 1), (int)-16777216);
            ConfigScreen.func_73734_a((int)rowX, (int)rowY, (int)(rowX + 18), (int)(rowY + 18), (int)(item.colour | 0xFF000000));
            this.func_73731_b(this.field_146289_q, item.name, rowX + 18 + 6, rowY + 4, 0xFFFFFF);
            int delX = rowX + item.width - 20;
            this.func_73731_b(this.field_146289_q, "-", delX, rowY + 4, 0xFF5555);
        }
        this.func_73731_b(this.field_146289_q, "Base Colour (Override):", absX.applyAsInt(10), absY.applyAsInt(this.baseToggleRelY - 16), 0xAAAAAA);
        int bTogX = absX.applyAsInt(this.baseToggleRelX);
        int bTogY = absY.applyAsInt(this.baseToggleRelY);
        int bBg = this.config.baseColourEnabled ? -13710223 : -11184811;
        ConfigScreen.func_73734_a((int)bTogX, (int)bTogY, (int)(bTogX + 48), (int)(bTogY + 20), (int)bBg);
        this.func_73732_a(this.field_146289_q, this.config.baseColourEnabled ? "ON" : "OFF", bTogX + 24, bTogY + 4, 0xFFFFFF);
        int bPrevX = absX.applyAsInt(this.basePreviewRelX);
        int bPrevY = absY.applyAsInt(this.basePreviewRelY) + 1;
        ConfigScreen.func_73734_a((int)(bPrevX - 1), (int)(bPrevY - 1), (int)(bPrevX + 18 + 1), (int)(bPrevY + 18 + 1), (int)-16777216);
        int baseCol = this.config.baseColour != 0 ? this.config.baseColour | 0xFF000000 : -5592406;
        ConfigScreen.func_73734_a((int)bPrevX, (int)bPrevY, (int)(bPrevX + 18), (int)(bPrevY + 18), (int)baseCol);
        this.drawBoldString("Ignore:", absX.applyAsInt(10), absY.applyAsInt(this.ignoreSectionTopRel), 0xFFFFFF);
        if (this.ignoreSectionBottomRel > this.ignoreSectionTopRel) {
            int iboxLeft = absX.applyAsInt(6);
            int iboxTop = absY.applyAsInt(this.ignoreSectionTopRel) - 4;
            int iboxRight = absX.applyAsInt(374);
            int iboxBottom = absY.applyAsInt(this.ignoreSectionBottomRel + 2);
            ConfigScreen.func_73734_a((int)iboxLeft, (int)iboxTop, (int)iboxRight, (int)(iboxTop + 1), (int)-1);
            ConfigScreen.func_73734_a((int)iboxLeft, (int)iboxTop, (int)(iboxLeft + 1), (int)iboxBottom, (int)-1);
            ConfigScreen.func_73734_a((int)(iboxRight - 1), (int)iboxTop, (int)iboxRight, (int)iboxBottom, (int)-1);
            ConfigScreen.func_73734_a((int)iboxLeft, (int)(iboxBottom - 1), (int)iboxRight, (int)iboxBottom, (int)-1);
        }
        int igTogX = absX.applyAsInt(this.ignoreToggleRelX);
        int igTogY = absY.applyAsInt(this.ignoreToggleRelY);
        int igBg = this.config.ignoreEnabled ? -13710223 : -11184811;
        ConfigScreen.func_73734_a((int)igTogX, (int)igTogY, (int)(igTogX + 48), (int)(igTogY + 20), (int)igBg);
        this.func_73732_a(this.field_146289_q, this.config.ignoreEnabled ? "ON" : "OFF", igTogX + 24, igTogY + 4, 0xFFFFFF);
        for (FriendListItem item : this.ignoreListItems) {
            int rowX = absX.applyAsInt(item.relX);
            int rowY = absY.applyAsInt(item.relY);
            this.func_73731_b(this.field_146289_q, item.name, rowX + 6, rowY + 4, 0xFFFFFF);
            int delX = rowX + item.width - 20;
            this.func_73731_b(this.field_146289_q, "-", delX, rowY + 4, 0xFF5555);
        }
        this.drawBoldString("Ignore Exceptions/Rules:", absX.applyAsInt(10), absY.applyAsInt(this.exc1ToggleRelY - 16), 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "Never ignore me or friends", absX.applyAsInt(10), absY.applyAsInt(this.exc1ToggleRelY + 4), 0xBBBBBB);
        int c1X = absX.applyAsInt(this.exc1ToggleRelX);
        int c1Y = absY.applyAsInt(this.exc1ToggleRelY);
        ConfigScreen.func_73734_a((int)c1X, (int)c1Y, (int)(c1X + 48), (int)(c1Y + 20), (int)(this.config.ignoreExceptionsEnabled ? -13710223 : -11184811));
        this.func_73732_a(this.field_146289_q, this.config.ignoreExceptionsEnabled ? "ON" : "OFF", c1X + 24, c1Y + 4, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "If my name comes first, don't ignore", absX.applyAsInt(10), absY.applyAsInt(this.exc2ToggleRelY + 4), 0xBBBBBB);
        int c2X = absX.applyAsInt(this.exc2ToggleRelX);
        int c2Y = absY.applyAsInt(this.exc2ToggleRelY);
        ConfigScreen.func_73734_a((int)c2X, (int)c2Y, (int)(c2X + 48), (int)(c2Y + 20), (int)(this.config.ignoreSelfFrontCheck ? -13710223 : -11184811));
        this.func_73732_a(this.field_146289_q, this.config.ignoreSelfFrontCheck ? "ON" : "OFF", c2X + 24, c2Y + 4, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "If a friend's name comes first, don't ignore", absX.applyAsInt(10), absY.applyAsInt(this.exc3ToggleRelY + 4), 0xBBBBBB);
        int c3X = absX.applyAsInt(this.exc3ToggleRelX);
        int c3Y = absY.applyAsInt(this.exc3ToggleRelY);
        ConfigScreen.func_73734_a((int)c3X, (int)c3Y, (int)(c3X + 48), (int)(c3Y + 20), (int)(this.config.ignoreFriendsFrontCheck ? -13710223 : -11184811));
        this.func_73732_a(this.field_146289_q, this.config.ignoreFriendsFrontCheck ? "ON" : "OFF", c3X + 24, c3Y + 4, 0xFFFFFF);
        this.drawBoldString("Encryption:", absX.applyAsInt(10), absY.applyAsInt(this.encryptionSectionTopRel), 0xFFFFFF);
        int eboxLeft = absX.applyAsInt(6);
        int eboxTop = absY.applyAsInt(this.encryptionSectionTopRel) - 4;
        int eboxRight = absX.applyAsInt(374);
        int eboxBottom = absY.applyAsInt(this.encryptionSectionBottomRel + 2);
        ConfigScreen.func_73734_a((int)eboxLeft, (int)eboxTop, (int)eboxRight, (int)(eboxTop + 1), (int)-1);
        ConfigScreen.func_73734_a((int)eboxLeft, (int)eboxTop, (int)(eboxLeft + 1), (int)eboxBottom, (int)-1);
        ConfigScreen.func_73734_a((int)(eboxRight - 1), (int)eboxTop, (int)eboxRight, (int)eboxBottom, (int)-1);
        ConfigScreen.func_73734_a((int)eboxLeft, (int)(eboxBottom - 1), (int)eboxRight, (int)eboxBottom, (int)-1);
        this.func_73731_b(this.field_146289_q, "Self Message Encryption:", absX.applyAsInt(10), absY.applyAsInt(this.encSelfToggleRelY - 18), 0xAAAAAA);
        int encX = absX.applyAsInt(this.encSelfToggleRelX);
        int encY = absY.applyAsInt(this.encSelfToggleRelY);
        ConfigScreen.func_73734_a((int)encX, (int)encY, (int)(encX + 48), (int)(encY + 20), (int)(this.config.selfEncryptionEnabled ? -13710223 : -11184811));
        this.func_73732_a(this.field_146289_q, this.config.selfEncryptionEnabled ? "ON" : "OFF", encX + 24, encY + 4, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "Secret:", absX.applyAsInt(10), absY.applyAsInt((this.contentWidgets.containsKey(this.selfSecretInput) ? this.contentWidgets.get((Object)this.selfSecretInput).relY : this.encSelfToggleRelY + 20 + 10) - 18), 0x888888);
        this.func_73731_b(this.field_146289_q, "Self Message Decryption:", absX.applyAsInt(10), absY.applyAsInt(this.encSelfDecryptToggleRelY - 18), 0xAAAAAA);
        int decX = absX.applyAsInt(this.encSelfDecryptToggleRelX);
        int decY = absY.applyAsInt(this.encSelfDecryptToggleRelY);
        ConfigScreen.func_73734_a((int)decX, (int)decY, (int)(decX + 48), (int)(decY + 20), (int)(this.config.selfDecryptionEnabled ? -13710223 : -11184811));
        this.func_73732_a(this.field_146289_q, this.config.selfDecryptionEnabled ? "ON" : "OFF", decX + 24, decY + 4, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "Friend Message Decryption:", absX.applyAsInt(10), absY.applyAsInt(this.encFriendDecryptLabelRelY), 0xAAAAAA);
        int fdecX = absX.applyAsInt(this.encFriendDecryptToggleRelX);
        int fdecY = absY.applyAsInt(this.encFriendDecryptToggleRelY);
        ConfigScreen.func_73734_a((int)fdecX, (int)fdecY, (int)(fdecX + 48), (int)(fdecY + 20), (int)(this.config.friendDecryptionEnabled ? -13710223 : -11184811));
        this.func_73732_a(this.field_146289_q, this.config.friendDecryptionEnabled ? "ON" : "OFF", fdecX + 24, fdecY + 4, 0xFFFFFF);
        for (FriendSecretItem friendSecretItem : this.friendDecryptItems) {
            int rowX = absX.applyAsInt(friendSecretItem.relX);
            int rowY = absY.applyAsInt(friendSecretItem.relY);
            this.func_73731_b(this.field_146289_q, friendSecretItem.name, rowX + 6, rowY + 4, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, friendSecretItem.secret, rowX + 120, rowY + 4, 0xBBBBBB);
            int delX = rowX + friendSecretItem.width - 20;
            this.func_73731_b(this.field_146289_q, "-", delX, rowY + 4, 0xFF5555);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (FriendSecretItem friendSecretItem : this.textFieldList) {
            if (!(friendSecretItem instanceof GuiTextField)) continue;
            ((GuiTextField)friendSecretItem).func_146194_f();
        }
        if (this.playerNameDetectionInput != null) {
            String val = this.playerNameDetectionInput.func_146179_b();
            if (val == null) {
                val = "";
            }
            if (!val.equals(this.config.playerNameDetectionMethod) && !val.equals(this.lastPersistedDetection)) {
                this.config.playerNameDetectionMethod = val;
                this.lastPersistedDetection = val;
                ConfigManager.setConfig(this.config);
                ChatHistory.requestRefresh();
            }
        }
        if (this.selfSecretInput != null) {
            String v = this.selfSecretInput.func_146179_b();
            if (v == null) {
                v = "";
            }
            if (!v.equals(this.config.selfSecret)) {
                this.config.selfSecret = v;
                ConfigManager.setConfig(this.config);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        int delX;
        int rowY;
        int rowX;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (GuiTextField o : this.textFieldList) {
            if (!(o instanceof GuiTextField)) continue;
            o.func_146192_a(mouseX, mouseY, mouseButton);
        }
        IntUnaryOperator absX = new IntUnaryOperator(){

            @Override
            public int applyAsInt(int relX) {
                return ConfigScreen.this.contentX + relX;
            }
        };
        IntUnaryOperator absY = new IntUnaryOperator(){

            @Override
            public int applyAsInt(int relY) {
                return 70 + relY - ConfigScreen.this.scrollOffset;
            }
        };
        if (ConfigScreen.within(mouseX, mouseY, absX.applyAsInt(this.selfToggleRelX), absY.applyAsInt(this.selfToggleRelY), 48, 20)) {
            this.config.selfColourEnabled = !this.config.selfColourEnabled;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            return;
        }
        if (ConfigScreen.within(mouseX, mouseY, absX.applyAsInt(this.selfPreviewRelX), absY.applyAsInt(this.selfPreviewRelY) + 1, 18, 18)) {
            this.field_146297_k.func_147108_a((GuiScreen)new ColourPickerPopupScreen(this, this.config.selfColour | 0xFF000000, col -> {
                this.config.selfColour = col | 0xFF000000;
                ConfigManager.setConfig(this.config);
                ChatHistory.requestRefresh();
            }));
            return;
        }
        if (ConfigScreen.within(mouseX, mouseY, absX.applyAsInt(this.friendToggleRelX), absY.applyAsInt(this.friendToggleRelY), 48, 20)) {
            this.config.friendColourEnabled = !this.config.friendColourEnabled;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            return;
        }
        if (ConfigScreen.within(mouseX, mouseY, absX.applyAsInt(this.relNewFriendPreviewX), absY.applyAsInt(this.friendAddRelY) + 1, 18, 18)) {
            this.field_146297_k.func_147108_a((GuiScreen)new ColourPickerPopupScreen(this, this.newFriendColour | 0xFF000000, col -> {
                this.newFriendColour = col | 0xFF000000;
            }));
            return;
        }
        for (FriendListItem friendListItem : this.friendListItems) {
            rowX = absX.applyAsInt(friendListItem.relX);
            if (ConfigScreen.within(mouseX, mouseY, rowX, rowY = absY.applyAsInt(friendListItem.relY), 18, 18)) {
                String fName = friendListItem.name;
                this.field_146297_k.func_147108_a((GuiScreen)new ColourPickerPopupScreen(this, friendListItem.colour | 0xFF000000, col -> {
                    Config cfg = ConfigManager.getConfig();
                    if (cfg.friends.containsKey(fName)) {
                        cfg.friends.get((Object)fName).colour = col | 0xFF000000;
                        ConfigManager.setConfig(cfg);
                        ChatHistory.requestRefresh();
                    }
                }));
                return;
            }
            int nameX = rowX + 18 + 6;
            int nameW = friendListItem.width - 18 - 30;
            if (ConfigScreen.within(mouseX, mouseY, nameX, rowY, nameW, 20)) {
                String oldName = friendListItem.name;
                this.field_146297_k.func_147108_a((GuiScreen)new NameEditPopupScreen(this, oldName, newName -> {
                    Config cfg = ConfigManager.getConfig();
                    if (cfg.friends.containsKey(oldName)) {
                        int col = cfg.friends.get((Object)oldName).colour;
                        cfg.updateFriend(oldName, (String)newName, col);
                        ConfigManager.setConfig(cfg);
                        ChatHistory.requestRefresh();
                    }
                    this.func_73866_w_();
                }));
                return;
            }
            int delX2 = rowX + friendListItem.width - 20;
            if (!ConfigScreen.within(mouseX, mouseY, delX2, rowY, 16, 20)) continue;
            Config cfg = ConfigManager.getConfig();
            cfg.removeFriend(friendListItem.name);
            ConfigManager.setConfig(cfg);
            ChatHistory.requestRefresh();
            this.func_73866_w_();
            return;
        }
        if (ConfigScreen.within(mouseX, mouseY, absX.applyAsInt(this.baseToggleRelX), absY.applyAsInt(this.baseToggleRelY), 48, 20)) {
            this.config.baseColourEnabled = !this.config.baseColourEnabled;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            return;
        }
        if (ConfigScreen.within(mouseX, mouseY, absX.applyAsInt(this.basePreviewRelX), absY.applyAsInt(this.basePreviewRelY) + 1, 18, 18)) {
            this.field_146297_k.func_147108_a((GuiScreen)new ColourPickerPopupScreen(this, this.config.baseColour | 0xFF000000, col -> {
                this.config.baseColour = col | 0xFF000000;
                ConfigManager.setConfig(this.config);
                ChatHistory.requestRefresh();
            }));
            return;
        }
        for (FriendListItem friendListItem : this.ignoreListItems) {
            rowX = absX.applyAsInt(friendListItem.relX);
            delX = rowX + friendListItem.width - 20;
            if (!ConfigScreen.within(mouseX, mouseY, delX, rowY = absY.applyAsInt(friendListItem.relY), 16, 20)) continue;
            Config cfg = ConfigManager.getConfig();
            cfg.removeIgnore(friendListItem.name);
            ConfigManager.setConfig(cfg);
            ChatHistory.requestRefresh();
            this.func_73866_w_();
            return;
        }
        if (ConfigScreen.within(mouseX, mouseY, absX.applyAsInt(this.ignoreToggleRelX), absY.applyAsInt(this.ignoreToggleRelY), 48, 20)) {
            this.config.ignoreEnabled = !this.config.ignoreEnabled;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            this.func_73866_w_();
            return;
        }
        if (ConfigScreen.within(mouseX, mouseY, absX.applyAsInt(this.exc1ToggleRelX), absY.applyAsInt(this.exc1ToggleRelY), 48, 20)) {
            this.config.ignoreExceptionsEnabled = !this.config.ignoreExceptionsEnabled;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            this.func_73866_w_();
            return;
        }
        if (ConfigScreen.within(mouseX, mouseY, absX.applyAsInt(this.exc2ToggleRelX), absY.applyAsInt(this.exc2ToggleRelY), 48, 20)) {
            this.config.ignoreSelfFrontCheck = !this.config.ignoreSelfFrontCheck;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            this.func_73866_w_();
            return;
        }
        if (ConfigScreen.within(mouseX, mouseY, absX.applyAsInt(this.exc3ToggleRelX), absY.applyAsInt(this.exc3ToggleRelY), 48, 20)) {
            this.config.ignoreFriendsFrontCheck = !this.config.ignoreFriendsFrontCheck;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            this.func_73866_w_();
            return;
        }
        if (ConfigScreen.within(mouseX, mouseY, absX.applyAsInt(this.encSelfToggleRelX), absY.applyAsInt(this.encSelfToggleRelY), 48, 20)) {
            if (this.selfSecretInput != null) {
                this.config.selfSecret = this.selfSecretInput.func_146179_b();
            }
            this.config.selfEncryptionEnabled = !this.config.selfEncryptionEnabled;
            ConfigManager.setConfig(this.config);
            return;
        }
        if (ConfigScreen.within(mouseX, mouseY, absX.applyAsInt(this.encSelfDecryptToggleRelX), absY.applyAsInt(this.encSelfDecryptToggleRelY), 48, 20)) {
            this.config.selfDecryptionEnabled = !this.config.selfDecryptionEnabled;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            return;
        }
        if (ConfigScreen.within(mouseX, mouseY, absX.applyAsInt(this.encFriendDecryptToggleRelX), absY.applyAsInt(this.encFriendDecryptToggleRelY), 48, 20)) {
            this.config.friendDecryptionEnabled = !this.config.friendDecryptionEnabled;
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            return;
        }
        for (FriendSecretItem friendSecretItem : this.friendDecryptItems) {
            rowX = absX.applyAsInt(friendSecretItem.relX);
            delX = rowX + friendSecretItem.width - 20;
            if (!ConfigScreen.within(mouseX, mouseY, delX, rowY = absY.applyAsInt(friendSecretItem.relY), 16, 20)) continue;
            Config cfg = ConfigManager.getConfig();
            cfg.removeFriendSecret(friendSecretItem.name);
            ConfigManager.setConfig(cfg);
            ChatHistory.requestRefresh();
            this.func_73866_w_();
            return;
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int dWheel = Mouse.getEventDWheel();
        if (dWheel != 0) {
            int step = dWheel > 0 ? -20 : 20;
            this.scrollOffset = ConfigScreen.clamp(this.scrollOffset + step, 0, this.maxScroll);
            if (this.config != null) {
                this.config.lastConfigScroll = this.scrollOffset;
                ConfigManager.setConfig(this.config);
            }
            this.updateWidgetPositions();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.persistScroll();
            this.field_146297_k.func_147108_a(null);
            return;
        }
        super.func_73869_a(typedChar, keyCode);
        for (GuiTextField o : this.textFieldList) {
            if (!(o instanceof GuiTextField)) continue;
            o.func_146201_a(typedChar, keyCode);
        }
    }

    public void func_146281_b() {
        this.persistScroll();
        super.func_146281_b();
    }

    private void addFriendFromInput() {
        if (this.friendNameInput != null && !this.friendNameInput.func_146179_b().trim().isEmpty()) {
            String friendName = this.friendNameInput.func_146179_b().trim();
            int colour = this.newFriendColour == 0 ? -1 : this.newFriendColour | 0xFF000000;
            this.config.addFriend(friendName, colour);
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            this.friendNameInput.func_146180_a("");
            this.newFriendColour = -1;
            this.func_73866_w_();
        }
    }

    private void addIgnoreFromInput() {
        if (this.ignoreNameInput != null && !this.ignoreNameInput.func_146179_b().trim().isEmpty()) {
            String name = this.ignoreNameInput.func_146179_b().trim();
            this.config.addIgnore(name);
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            this.ignoreNameInput.func_146180_a("");
            this.func_73866_w_();
        }
    }

    private void addFriendDecryptFromInput() {
        if (this.friendDecryptNameInput != null && !this.friendDecryptNameInput.func_146179_b().trim().isEmpty()) {
            String name = this.friendDecryptNameInput.func_146179_b().trim();
            String secret = this.friendDecryptSecretInput != null ? this.friendDecryptSecretInput.func_146179_b() : "";
            this.config.addFriendSecret(name, secret);
            ConfigManager.setConfig(this.config);
            ChatHistory.requestRefresh();
            this.friendDecryptNameInput.func_146180_a("");
            if (this.friendDecryptSecretInput != null) {
                this.friendDecryptSecretInput.func_146180_a("");
            }
            this.func_73866_w_();
        }
    }

    private void updateWidgetPositions() {
        this.contentX = (this.field_146294_l - 380) / 2;
        for (Map.Entry<Object, WidgetPos> e : this.contentWidgets.entrySet()) {
            Object w = e.getKey();
            WidgetPos pos = e.getValue();
            int ax = this.contentX + pos.relX;
            int ay = 70 + pos.relY - this.scrollOffset;
            if (w instanceof GuiButton) {
                ((GuiButton)w).field_146128_h = ax;
                ((GuiButton)w).field_146129_i = ay;
                continue;
            }
            if (!(w instanceof GuiTextField)) continue;
            GuiTextField tf = (GuiTextField)w;
            tf.field_146209_f = ax;
            tf.field_146210_g = ay;
        }
    }

    private void drawBoldString(String text, int x, int y, int color) {
        this.field_146289_q.func_78276_b(text, x, y, color);
        this.field_146289_q.func_78276_b(text, x + 1, y, color);
    }

    private static boolean within(int mx, int my, int x, int y, int w, int h) {
        return mx >= x && mx <= x + w && my >= y && my <= y + h;
    }

    private int resolveLineY(int proposedRelY) {
        int h = Math.max(12, this.field_146289_q != null ? this.field_146289_q.field_78288_b : 12);
        int y = proposedRelY;
        for (int guard = 0; guard < 50; ++guard) {
            boolean moved = false;
            for (Map.Entry<Object, WidgetPos> e : this.contentWidgets.entrySet()) {
                WidgetPos pos = e.getValue();
                int wTop = pos.relY;
                int wBottom = pos.relY + 20;
                if (!ConfigScreen.overlap(y, y + h, wTop, wBottom)) continue;
                y = wBottom + 2;
                moved = true;
            }
            if (!moved) break;
        }
        return y;
    }

    private int nextClearY(int proposedRelY, int height) {
        int y = Math.max(0, proposedRelY);
        int h = Math.max(1, height);
        for (int guard = 0; guard < 100; ++guard) {
            boolean moved = false;
            for (Map.Entry<Object, WidgetPos> e : this.contentWidgets.entrySet()) {
                WidgetPos pos = e.getValue();
                int wTop = pos.relY;
                int wBottom = pos.relY + 20;
                if (!ConfigScreen.overlap(y, y + h, wTop, wBottom)) continue;
                y = wBottom + 2;
                moved = true;
            }
            for (Band b : this.occupiedBands) {
                if (!ConfigScreen.overlap(y, y + h, b.top, b.bottom)) continue;
                y = b.bottom + 2;
                moved = true;
            }
            if (!moved) break;
        }
        return y;
    }

    private void occupyBand(int top, int height) {
        int h = Math.max(1, height);
        int t = Math.max(0, top);
        this.occupiedBands.add(new Band(t, t + h));
    }

    private static boolean overlap(int a1, int a2, int b1, int b2) {
        return Math.max(a1, b1) < Math.min(a2, b2);
    }

    private void persistScroll() {
        if (this.config != null) {
            this.config.lastConfigScroll = ConfigScreen.clamp(this.scrollOffset, 0, this.maxScroll);
            ConfigManager.setConfig(this.config);
        }
    }

    private static int clamp(int v, int mn, int mx) {
        if (v < mn) {
            return mn;
        }
        if (v > mx) {
            return mx;
        }
        return v;
    }

    private static class Band {
        final int top;
        final int bottom;

        Band(int t, int b) {
            this.top = t;
            this.bottom = b;
        }
    }

    private static class WidgetPos {
        int relX;
        int relY;

        WidgetPos(int x, int y) {
            this.relX = x;
            this.relY = y;
        }
    }

    private static class FriendSecretItem {
        String name;
        String secret;
        int relX;
        int relY;
        int width;

        FriendSecretItem(String n, String s, int rx, int ry, int w) {
            this.name = n;
            this.secret = s;
            this.relX = rx;
            this.relY = ry;
            this.width = w;
        }
    }

    private static class FriendListItem {
        String name;
        int colour;
        int relX;
        int relY;
        int width;

        FriendListItem(String n, int c, int rx, int ry, int w) {
            this.name = n;
            this.colour = c;
            this.relX = rx;
            this.relY = ry;
            this.width = w;
        }
    }
}

