/*
 * Decompiled with CFR 0.152.
 */
package io.itamio.antiweakchat.util;

import net.minecraft.util.EnumChatFormatting;

public class ColourUtil {
    public static int rgbToInt(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int getRed(int colour) {
        return colour >> 16 & 0xFF;
    }

    public static int getGreen(int colour) {
        return colour >> 8 & 0xFF;
    }

    public static int getBlue(int colour) {
        return colour & 0xFF;
    }

    public static String toHexString(int colour) {
        return String.format("%06X", colour & 0xFFFFFF);
    }

    public static int hexStringToInt(String hex) {
        try {
            return 0xFF000000 | Integer.parseInt(hex.replace("#", ""), 16);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static int fromHex(String hex) {
        try {
            String cleanHex = hex.replace("#", "").replace("0x", "");
            if (cleanHex.length() == 6) {
                return 0xFF000000 | Integer.parseInt(cleanHex, 16);
            }
            if (cleanHex.length() == 8) {
                return Integer.parseInt(cleanHex, 16);
            }
        }
        catch (NumberFormatException e) {
            return -1;
        }
        return -1;
    }

    public static float getBrightness(int colour) {
        int r = ColourUtil.getRed(colour);
        int g = ColourUtil.getGreen(colour);
        int b = ColourUtil.getBlue(colour);
        return ((float)r * 0.299f + (float)g * 0.587f + (float)b * 0.114f) / 255.0f;
    }

    public static int getContrastingColour(int colour) {
        return ColourUtil.getBrightness(colour) > 0.5f ? -16777216 : -1;
    }

    public static EnumChatFormatting rgbToEnumChatFormatting(int argb) {
        int r = ColourUtil.getRed(argb);
        int g = ColourUtil.getGreen(argb);
        int b = ColourUtil.getBlue(argb);
        int[] vals = new int[]{0, 170, 43520, 43690, 0xAA0000, 0xAA00AA, 0xFFAA00, 0xAAAAAA, 0x555555, 0x5555FF, 0x55FF55, 0x55FFFF, 0xFF5555, 0xFF55FF, 0xFFFF55, 0xFFFFFF};
        EnumChatFormatting[] fmt = new EnumChatFormatting[]{EnumChatFormatting.BLACK, EnumChatFormatting.DARK_BLUE, EnumChatFormatting.DARK_GREEN, EnumChatFormatting.DARK_AQUA, EnumChatFormatting.DARK_RED, EnumChatFormatting.DARK_PURPLE, EnumChatFormatting.GOLD, EnumChatFormatting.GRAY, EnumChatFormatting.DARK_GRAY, EnumChatFormatting.BLUE, EnumChatFormatting.GREEN, EnumChatFormatting.AQUA, EnumChatFormatting.RED, EnumChatFormatting.LIGHT_PURPLE, EnumChatFormatting.YELLOW, EnumChatFormatting.WHITE};
        double best = Double.MAX_VALUE;
        int bestIdx = vals.length - 1;
        for (int i = 0; i < vals.length; ++i) {
            int vr = vals[i] >> 16 & 0xFF;
            int vg = vals[i] >> 8 & 0xFF;
            int vb = vals[i] & 0xFF;
            double dist = Math.pow(vr - r, 2.0) + Math.pow(vg - g, 2.0) + Math.pow(vb - b, 2.0);
            if (!(dist < best)) continue;
            best = dist;
            bestIdx = i;
        }
        return fmt[bestIdx];
    }
}

